/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.PLSUtil;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.document.PLSEnabledDataSetPopulator;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDManager;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.NewInstanceHelper;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class PreparedIVDataSourceQuery
extends PreparedDataSourceQuery {
    private DataEngineImpl engine;
    private IQueryDefinition queryDefn;
    private String realBasedQueryID;

    PreparedIVDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        super(dataEngine, PLSUtil.isPLSEnabled(queryDefn) ? PLSUtil.populateBindings(queryDefn) : queryDefn, null, null);
        Object[] params = new Object[]{dataEngine, queryDefn};
        logger.entering(PreparedIVDataSourceQuery.class.getName(), "PreparedIVDataSourceQuery", params);
        this.queryDefn = queryDefn;
        this.engine = dataEngine;
        if (!PLSUtil.isPLSEnabled(queryDefn)) {
            this.cleanUpOldRD();
        }
        logger.exiting(PreparedIVDataSourceQuery.class.getName(), "PreparedIVDataSourceQuery");
    }

    private void cleanUpOldRD() throws DataException {
        String basedID = this.queryDefn.getQueryResultsID();
        String _1partID = QueryResultIDUtil.get1PartID(basedID);
        if (_1partID != null) {
            basedID = _1partID;
        }
        StreamManager streamManager = new StreamManager(this.engine.getContext(), new QueryResultInfo(this.queryDefn.getQueryResultsID(), null, 0));
        streamManager.dropStream1(31);
        streamManager.dropStream1(33);
        QueryResultIDManager.cleanChildOfRoot(streamManager);
        streamManager.dropStream1(99);
        streamManager.dropStream1(100);
    }

    protected QueryExecutor newExecutor() {
        return new IVDataSourceExecutor(this.engine.getSession().getSharedScope(), this.queryDefn, this.preparedQuery.getAggrTable());
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    protected void initializeExecution(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        String basedID = this.queryDefn.getQueryResultsID();
        String _1partID = QueryResultIDUtil.get1PartID(basedID);
        this.realBasedQueryID = _1partID == null ? basedID : _1partID;
    }

    protected IQueryResults produceQueryResults(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        QueryResults queryResults = this.preparedQuery.doPrepare(outerResults, scope, this.newExecutor(), this);
        queryResults.setID(this.realBasedQueryID);
        return queryResults;
    }

    private class IVDataSourceExecutor
    extends QueryExecutor {
        private Scriptable queryScope;
        private BaseQuery query;
        private DataSetRuntime dsRuntime;

        IVDataSourceExecutor(Scriptable sharedScope, IBaseQueryDefinition baseQueryDefn, AggregateTable aggrTable) {
            super(sharedScope, baseQueryDefn, aggrTable, PreparedIVDataSourceQuery.this.engine.getSession());
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return NewInstanceHelper.newDataSource();
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            return NewInstanceHelper.newDataSourceRuntime(this.queryScope);
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            this.dsRuntime = new DataSetRuntime(NewInstanceHelper.newIVDataSetDesign(), this, this.getSession());
            return this.dsRuntime;
        }

        public IResultMetaData getResultMetaData() throws DataException {
            RDLoad rdLoad = RDUtil.newLoad(PreparedIVDataSourceQuery.this.engine.getSession().getTempDir(), PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.realBasedQueryID, null, -1));
            return rdLoad.loadResultMetaData();
        }

        protected IQuery createOdiQuery() throws DataException {
            this.query = NewInstanceHelper.newBaseQuery();
            return this.query;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IResultIterator executeOdiQuery(IEventHandler eventHandler, StopSign stopSign) throws DataException {
            try {
                RDLoad rdLoad = RDUtil.newLoad(PreparedIVDataSourceQuery.this.engine.getSession().getTempDir(), PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.realBasedQueryID, null, -1));
                DataSetResultSet dataSetResult = rdLoad.loadDataSetData();
                StreamManager manager = new StreamManager(PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.queryDefn.getQueryResultsID(), null, 0));
                if (PLSUtil.isPLSEnabled(PreparedIVDataSourceQuery.this.queryDefn)) {
                    if (PLSUtil.needUpdateDataSet(PreparedIVDataSourceQuery.this.queryDefn, manager)) {
                        if (PreparedIVDataSourceQuery.this.engine.getContext().getDocWriter() == null) {
                            ResultIterator docIt = new ResultIterator(PreparedIVDataSourceQuery.this.engine.getSession().getTempDir(), PreparedIVDataSourceQuery.this.engine.getContext(), null, PreparedIVDataSourceQuery.this.queryDefn.getQueryResultsID());
                            PLSEnabledDataSetPopulator populator = new PLSEnabledDataSetPopulator(PreparedIVDataSourceQuery.this.queryDefn, PreparedIVDataSourceQuery.this.queryDefn.getQueryExecutionHints().getTargetGroupInstances(), docIt);
                            CachedResultSet resultIterator = new CachedResultSet(this.query, this.populateResultClass(populator.getResultClass()), populator, eventHandler, PreparedIVDataSourceQuery.this.engine.getSession(), stopSign);
                            dataSetResult.close();
                            PreparedIVDataSourceQuery.this.cleanUpOldRD();
                            return resultIterator;
                        }
                        this.populatePLSDataSetData(eventHandler, stopSign, manager);
                        dataSetResult.close();
                        rdLoad = RDUtil.newLoad(PreparedIVDataSourceQuery.this.engine.getSession().getTempDir(), PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.realBasedQueryID, null, -1));
                        dataSetResult = rdLoad.loadDataSetData();
                    } else {
                        PreparedIVDataSourceQuery.this.cleanUpOldRD();
                    }
                }
                IResultClass meta = dataSetResult.getResultClass();
                CachedResultSet resultIterator = new CachedResultSet(this.query, this.populateResultClass(meta), dataSetResult, eventHandler, PreparedIVDataSourceQuery.this.engine.getSession(), stopSign);
                dataSetResult.close();
                return resultIterator;
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage());
            }
        }

        private void populatePLSDataSetData(IEventHandler eventHandler, StopSign stopSign, StreamManager manager) throws DataException, IOException {
            ResultIterator docIt = new ResultIterator(PreparedIVDataSourceQuery.this.engine.getSession().getTempDir(), PreparedIVDataSourceQuery.this.engine.getContext(), null, PreparedIVDataSourceQuery.this.queryDefn.getQueryResultsID());
            PLSEnabledDataSetPopulator populator = new PLSEnabledDataSetPopulator(PreparedIVDataSourceQuery.this.queryDefn, PreparedIVDataSourceQuery.this.queryDefn.getQueryExecutionHints().getTargetGroupInstances(), docIt);
            ResultClass processedRC = (ResultClass)this.populateResultClass(populator.getResultClass());
            SmartCache cache = new SmartCache(new CacheRequest(0, new ArrayList(), null, eventHandler), new OdiAdapter(populator), (IResultClass)processedRC, PreparedIVDataSourceQuery.this.engine.getSession(), stopSign);
            manager.dropStream1(21);
            manager.dropStream1(23);
            PreparedIVDataSourceQuery.this.cleanUpOldRD();
            OutputStream resultClassStream = manager.getOutStream(22, 0, 2);
            processedRC.doSave(resultClassStream, new ArrayList<IBinding>(PreparedIVDataSourceQuery.this.queryDefn.getBindings().values()));
            resultClassStream.close();
            DataOutputStream dataSetDataStream = new DataOutputStream(manager.getOutStream(21, 0, 2));
            DataOutputStream rowLensStream = new DataOutputStream(manager.getOutStream(23, 0, 2));
            cache.doSave(dataSetDataStream, rowLensStream, eventHandler.getAllColumnBindings());
            cache.close();
            DataOutputStream plsGroupLevelStream = new DataOutputStream(manager.getOutStream(102, 0, 2));
            IOUtil.writeInt((OutputStream)plsGroupLevelStream, (int)PLSUtil.getOutmostPlsGroupLevel(PreparedIVDataSourceQuery.this.queryDefn));
            plsGroupLevelStream.close();
        }

        private IResultClass populateResultClass(IResultClass meta) throws DataException {
            ArrayList projectedColumns = new ArrayList();
            this.addOriginalMetadata(meta, projectedColumns);
            this.addComputedColumn(projectedColumns);
            if (this.dataSet.getResultSetHints() != null) {
                List hintList = this.dataSet.getResultSetHints();
                int i = 0;
                while (i < hintList.size()) {
                    IColumnDefinition columnDefinition = (IColumnDefinition)hintList.get(i);
                    int j = 0;
                    while (j < projectedColumns.size()) {
                        ResultFieldMetadata resultFieldMetadata = (ResultFieldMetadata)projectedColumns.get(j);
                        if (columnDefinition.getColumnName().equals(resultFieldMetadata.getName())) {
                            resultFieldMetadata.setAlias(columnDefinition.getAlias());
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return new ResultClass(projectedColumns);
        }

        private void addComputedColumn(List projectedColumns) {
            if (this.dataSet.getComputedColumns() != null) {
                int i = 0;
                while (i < this.dataSet.getComputedColumns().size()) {
                    IComputedColumn cc = (IComputedColumn)this.dataSet.getComputedColumns().get(i);
                    projectedColumns.add(new ResultFieldMetadata(i, cc.getName(), cc.getName(), DataType.getClass((int)cc.getDataType()), null, true));
                    ++i;
                }
            }
        }

        private void addOriginalMetadata(IResultClass meta, List projectedColumns) throws DataException {
            int i = 1;
            while (i <= meta.getFieldCount()) {
                ResultFieldMetadata rfm = new ResultFieldMetadata(i, meta.getFieldName(i), meta.getFieldName(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), false);
                rfm.setAlias(meta.getFieldAlias(i));
                projectedColumns.add(rfm);
                ++i;
            }
        }
    }
}

