/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.PLSUtil;
import org.eclipse.birt.data.engine.impl.document.PLSDataPopulator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.olap.data.util.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSEnabledDataSetPopulator
implements IDataSetPopulator {
    private PLSDataPopulator populator = null;
    private IResultClass resultClass;
    private List<String> originalBindingNames;

    public PLSEnabledDataSetPopulator(IQueryDefinition query, List<IGroupInstanceInfo> targetGroups, ResultIterator docIt) throws DataException {
        this.populator = new PLSDataPopulator(targetGroups, docIt);
        try {
            assert (docIt.getExprResultSet().getDataSetResultSet() != null);
            this.resultClass = this.populateResultClass(query, targetGroups, docIt.getExprResultSet().getDataSetResultSet().getResultClass());
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    @Override
    public IResultObject next() throws DataException {
        if (!this.populator.next()) {
            return null;
        }
        Object[] field = new Object[this.resultClass.getFieldCount()];
        IResultObject curr = this.populator.getDocumentIterator().getExprResultSet().getDataSetResultSet().getResultObject();
        assert (curr != null);
        int i = 0;
        while (i < curr.getResultClass().getFieldCount()) {
            field[i] = curr.getFieldValue(i + 1);
            ++i;
        }
        i = curr.getResultClass().getFieldCount();
        while (i < field.length) {
            try {
                field[i] = this.populator.getDocumentIterator().getValue(this.originalBindingNames.get(i - curr.getResultClass().getFieldCount()));
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            ++i;
        }
        return new ResultObject(this.resultClass, field);
    }

    public IResultClass getResultClass() {
        return this.resultClass;
    }

    private IResultClass populateResultClass(IQueryDefinition query, List<IGroupInstanceInfo> targetGroups, IResultClass original) throws BirtException {
        ArrayList<ResultFieldMetadata> list = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= original.getFieldCount()) {
            list.add(original.getFieldMetaData(i));
            ++i;
        }
        this.originalBindingNames = new ArrayList<String>();
        for (IBinding binding : query.getBindings().values()) {
            if (!PLSUtil.isPLSProcessedBinding(binding)) continue;
            ResultFieldMetadata rfmeta = new ResultFieldMetadata(-1, PLSUtil.constructNonReCalBindingDataSetName(binding.getBindingName()), null, DataType.getClass(binding.getDataType()), null, false);
            list.add(rfmeta);
            this.originalBindingNames.add(binding.getBindingName());
        }
        return new ResultClass(list);
    }
}

