/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.cache.BasicCachedArray;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.RowIndexUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class ExprDataReader2
implements IExprDataReader {
    private int version;
    private RAInputStream rowExprsIs;
    private RAInputStream rowLenIs;
    private DataInputStream rowExprsDis;
    private DataInputStream rowLenDis;
    protected int rowCount;
    private int lastRowIndex;
    private int currRowIndex;
    private int currRowLenReadIndex;
    private RowIndexUtil rowIndexUtil;
    private int nextDestIndex;
    private Map exprValueMap;
    private BasicCachedArray rowIDMap;
    private List exprKeys;
    private int metaOffset;
    private Map dataSetExprKeys;
    private DataSetResultSet dataSetResultSet;
    private Map bindingNameTypeMap;
    private ClassLoader currentClassLoader;

    protected ExprDataReader2(String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs, int rowCount, int version) throws DataException {
        this.version = version;
        this.initialize(tempDir, rowExprsIs, rowLenIs, rowCount, null);
    }

    ExprDataReader2(String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs, RAInputStream rowInfoIs, int version, DataSetResultSet dataSetResultSet) throws DataException {
        this.version = version;
        this.rowIndexUtil = new RowIndexUtil((InputStream)rowInfoIs);
        try {
            int rowCount = (int)(rowInfoIs.length() / 4L);
            this.initialize(tempDir, rowExprsIs, rowLenIs, rowCount, dataSetResultSet);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private void initialize(String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs, int rowCount, DataSetResultSet dataSetResultSet) throws DataException {
        try {
            this.currentClassLoader = DataEngineSession.getCurrentClassLoader();
            IOUtil.readInt((InputStream)rowExprsIs);
            int exprCount = IOUtil.readInt((InputStream)rowExprsIs);
            this.exprKeys = new ArrayList();
            this.dataSetExprKeys = new HashMap();
            this.rowExprsDis = new DataInputStream((InputStream)rowExprsIs);
            this.rowLenDis = new DataInputStream((InputStream)rowLenIs);
            this.bindingNameTypeMap = new HashMap();
            int i = 0;
            while (i < exprCount) {
                String key = IOUtil.readString((DataInputStream)this.rowExprsDis);
                this.exprKeys.add(key);
                if (this.version >= 50) {
                    this.bindingNameTypeMap.put(key, new Integer(IOUtil.readInt((InputStream)this.rowExprsDis)));
                }
                ++i;
            }
            if (this.version >= 50) {
                int dataSetColumnExprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
                int i2 = 0;
                while (i2 < dataSetColumnExprCount) {
                    String key = IOUtil.readObject((DataInputStream)this.rowExprsDis, (ClassLoader)this.currentClassLoader).toString();
                    this.dataSetExprKeys.put(key, IOUtil.readObject((DataInputStream)this.rowExprsDis, (ClassLoader)this.currentClassLoader));
                    this.bindingNameTypeMap.put(key, new Integer(IOUtil.readInt((InputStream)this.rowExprsDis)));
                    ++i2;
                }
            }
            if (this.dataSetExprKeys.size() > 0) {
                this.dataSetResultSet = dataSetResultSet;
            }
            this.metaOffset = 4 + IOUtil.readInt((InputStream)this.rowExprsDis) + 4;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        this.rowExprsIs = rowExprsIs;
        this.rowLenIs = rowLenIs;
        this.currRowIndex = -1;
        this.lastRowIndex = -1;
        this.currRowLenReadIndex = 0;
        this.rowCount = rowCount;
        this.rowIDMap = new BasicCachedArray(tempDir, rowCount);
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getRowId() {
        int destIndex = (Integer)this.rowIDMap.get(this.currRowIndex);
        return destIndex;
    }

    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    public boolean next() {
        boolean hasNext;
        ++this.currRowIndex;
        boolean bl = hasNext = this.currRowIndex < this.rowCount;
        if (hasNext) {
            this.nextDestIndex = this.getNextDestIndex(this.currRowIndex);
            this.rowIDMap.set(this.currRowIndex, new Integer(this.nextDestIndex));
        }
        return hasNext;
    }

    /*
     * Unable to fully structure code
     */
    public void moveTo(int index) throws DataException {
        if (index < 0 || index >= this.rowCount) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(index));
        }
        if (index < this.currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (index != this.currRowIndex) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            this.next();
lbl9:
            // 2 sources

            ** while (this.currRowIndex < index)
        }
lbl10:
        // 1 sources

    }

    protected int getNextDestIndex(int currIndex) {
        return this.rowIndexUtil.read();
    }

    public Map getRowValue() throws DataException {
        try {
            if (this.rowCount == 0) {
                if (this.exprValueMap == null) {
                    this.exprValueMap = this.getValueMap();
                }
            } else {
                if (this.lastRowIndex == this.currRowIndex) {
                    return this.exprValueMap;
                }
                this.lastRowIndex = this.currRowIndex;
                this.skipTo(this.nextDestIndex);
                this.exprValueMap = this.getValueMap();
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteIndex) throws IOException, DataException {
        if (this.dataSetResultSet != null) {
            this.dataSetResultSet.skipTo(absoluteIndex);
        }
        if (this.currRowLenReadIndex == absoluteIndex) {
            return;
        }
        this.currRowLenReadIndex = absoluteIndex + 1;
        this.rowLenIs.seek((long)(absoluteIndex * (this.version > 25 ? 8 : 4)));
        if (this.version <= 25) {
            this.rowExprsIs.seek((long)(IOUtil.readInt((InputStream)this.rowLenIs) + this.metaOffset));
        } else {
            this.rowExprsIs.seek(IOUtil.readLong((DataInputStream)this.rowLenDis) + (long)this.metaOffset);
        }
        this.rowExprsDis = new DataInputStream((InputStream)this.rowExprsIs);
    }

    private Map getValueMap() throws IOException, DataException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
        int i = 0;
        while (i < exprCount) {
            String exprID = this.exprKeys.get(i).toString();
            Object exprValue = IOUtil.readObject((DataInputStream)this.rowExprsDis, (ClassLoader)this.currentClassLoader);
            if (RowSaveUtil.EXCEPTION_INDICATOR.equals(exprValue)) {
                valueMap.put(exprID, (Object)new DataException("data.engine.ReadColumnValueFromDocumentError", exprID));
            } else {
                valueMap.put(exprID, exprValue);
            }
            ++i;
        }
        Iterator it = this.dataSetExprKeys.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = (String)this.dataSetExprKeys.get(key);
            IResultObject o = this.dataSetResultSet.getResultObject();
            try {
                valueMap.put(key, o == null ? null : DataTypeUtil.convert((Object)o.getFieldValue(value), (int)((Integer)this.bindingNameTypeMap.get(key))));
            }
            catch (BirtException e) {
                valueMap.put(key, (Object)e);
            }
        }
        return valueMap;
    }

    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
                this.rowExprsDis = null;
            }
        }
        catch (IOException iOException) {}
    }
}

