/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.group;

import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.group.DateGroupCalculator;
import org.eclipse.birt.data.engine.impl.group.DateTimeUtil;

class WeekGroupCalculator
extends DateGroupCalculator {
    public WeekGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
    }

    public Object calculate(Object value) throws BirtException {
        if (value == null) {
            return new Double(-1.0);
        }
        Date target = this.getDate(value);
        if (this.intervalStart == null) {
            return new Double(Math.floor(DateTimeUtil.diffWeek(defaultStart, target) / (long)this.getDateIntervalRange()));
        }
        if (DateTimeUtil.diffWeek((Date)this.intervalStart, target) < 0L) {
            return new Double(-1.0);
        }
        return new Double(Math.floor(DateTimeUtil.diffWeek((Date)this.intervalStart, target) / (long)this.getDateIntervalRange()));
    }
}

