/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGraph {
    Set<DirectedGraphEdge> edges;

    public DirectedGraph(Set<DirectedGraphEdge> edges) {
        this.edges = edges;
    }

    public void validateCycle() throws CycleFoundException {
        if (this.edges == null) {
            return;
        }
        Map<GraphNode, Set<DirectedGraphEdge>> groupedEdgesByFromNode = this.groupEdgesByFromNode();
        HashSet<GraphNode> checkedNodes = new HashSet<GraphNode>();
        for (GraphNode fromNode : groupedEdgesByFromNode.keySet()) {
            if (checkedNodes.contains(fromNode)) continue;
            Set<GraphNode> reachables = this.getReachableNodes(fromNode, new HashSet<GraphNode>(), groupedEdgesByFromNode);
            checkedNodes.addAll(reachables);
            checkedNodes.add(fromNode);
        }
    }

    private Set<GraphNode> getReachableNodes(GraphNode fromNode, Set<GraphNode> transitions, Map<GraphNode, Set<DirectedGraphEdge>> groupedEdges) throws CycleFoundException {
        HashSet<GraphNode> reachables = new HashSet<GraphNode>();
        Set<DirectedGraphEdge> nextEdges = groupedEdges.get(fromNode);
        if (nextEdges != null) {
            for (DirectedGraphEdge edge : nextEdges) {
                if (edge.getTo().equals(fromNode)) {
                    throw new CycleFoundException(fromNode);
                }
                GraphNode reachable = edge.getTo();
                if (transitions.contains(reachable)) {
                    throw new CycleFoundException(fromNode);
                }
                if (reachables.contains(reachable)) continue;
                reachables.add(reachable);
                HashSet<GraphNode> newTransitons = new HashSet<GraphNode>(transitions);
                newTransitons.add(fromNode);
                reachables.addAll(this.getReachableNodes(reachable, newTransitons, groupedEdges));
            }
        }
        return reachables;
    }

    private Map<GraphNode, Set<DirectedGraphEdge>> groupEdgesByFromNode() {
        HashMap<GraphNode, Set<DirectedGraphEdge>> groups = new HashMap<GraphNode, Set<DirectedGraphEdge>>();
        for (DirectedGraphEdge edge : this.edges) {
            HashSet<DirectedGraphEdge> group = (HashSet<DirectedGraphEdge>)groups.get(edge.getFrom());
            if (group == null) {
                group = new HashSet<DirectedGraphEdge>();
                groups.put(edge.getFrom(), group);
            }
            group.add(edge);
        }
        return groups;
    }

    public static class CycleFoundException
    extends Exception {
        private GraphNode node;

        public CycleFoundException(GraphNode node) {
            this.node = node;
        }

        public GraphNode getNode() {
            return this.node;
        }
    }
}

