/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.EdgeDimensionRelation;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfo;
import org.eclipse.birt.data.engine.olap.cursor.ResultSetFetcher;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

class DimensionTraverse {
    private DimensionAxis[] dimAxis;
    private EdgeDimensionRelation relationMap;
    private ResultSetFetcher fetcher;
    int[] dimensionCursorPosition;
    private int[] startPosition;
    private int[] endPosition;
    private int edgeStart;
    private int edgeEnd;

    DimensionTraverse(DimensionAxis[] axis, EdgeDimensionRelation relationMap) {
        this.dimAxis = axis;
        this.relationMap = relationMap;
        this.dimensionCursorPosition = new int[this.dimAxis.length];
        this.beforeFirst();
        this.fetcher = relationMap.fetcher;
        this.dimensionCursorPosition = this.findDimensionPosition(-1);
        this.endPosition = this.findDimensionPosition(this.relationMap.traverseLength - 1);
        this.edgeStart = 0;
        this.edgeEnd = this.relationMap.traverseLength - 1;
    }

    DimensionTraverse(DimensionAxis[] axis, EdgeDimensionRelation relationMap, int edgeStart, int edgeEnd) {
        this.dimAxis = axis;
        this.relationMap = relationMap;
        this.dimensionCursorPosition = new int[this.dimAxis.length];
        this.beforeFirst();
        this.fetcher = relationMap.fetcher;
        this.edgeStart = edgeStart;
        this.edgeEnd = edgeEnd;
        this.dimensionCursorPosition = this.findDimensionPosition(edgeStart - 1);
        this.endPosition = this.findDimensionPosition(edgeEnd);
    }

    private int[] findDimensionPosition(int currentPosition) {
        int position = currentPosition;
        int[] pos = new int[this.relationMap.mirrorLength.length];
        int count = 0;
        int i = pos.length - 1;
        while (i >= 0) {
            count = 0;
            if (position < 0) {
                pos[i] = -1;
            } else if (this.relationMap.mirrorLength[i] == 0) {
                EdgeInfo info = null;
                if (this.relationMap.currentRelation[i].size() <= position) {
                    pos[i] = -1;
                } else {
                    info = (EdgeInfo)this.relationMap.currentRelation[i].get(position);
                    int j = position - 1;
                    while (j >= 0) {
                        EdgeInfo lastInfo = (EdgeInfo)this.relationMap.currentRelation[i].get(j);
                        if (info.parent != lastInfo.parent) break;
                        ++count;
                        --j;
                    }
                    position = info.parent;
                    pos[i] = count;
                }
            } else {
                int offset = position % this.relationMap.mirrorLength[i];
                position = (position - offset) / this.relationMap.mirrorLength[i];
                pos[i] = offset;
            }
            --i;
        }
        return pos;
    }

    boolean next(int dimAxisIndex) {
        if (this.hasNext(dimAxisIndex)) {
            int n = dimAxisIndex;
            this.dimensionCursorPosition[n] = this.dimensionCursorPosition[n] + 1;
            return true;
        }
        return false;
    }

    boolean previous(int dimAxisIndex) {
        int position = this.dimensionCursorPosition[dimAxisIndex];
        if (--position >= 0) {
            this.dimensionCursorPosition[dimAxisIndex] = position;
            return true;
        }
        this.dimensionCursorPosition[dimAxisIndex] = -1;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean relative(int offset, int dimAxisIndex) {
        block3: {
            index = offset;
            if (offset <= 0) ** GOTO lbl11
            while (index != 0) {
                if (this.next(dimAxisIndex)) {
                    --index;
                    continue;
                }
                break block3;
            }
            break block3;
            while (this.previous(dimAxisIndex)) {
                ++index;
lbl11:
                // 2 sources

                if (index != 0) continue;
            }
        }
        return index == 0;
    }

    boolean first(int dimAxisIndex) {
        if (this.relationMap.traverseLength > 0) {
            this.dimensionCursorPosition[dimAxisIndex] = 0;
            return true;
        }
        return false;
    }

    boolean last(int dimAxisIndex) {
        if (this.relationMap.traverseLength <= 0) {
            return false;
        }
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            int range = this.findFowardOffsetRange(dimAxisIndex);
            int n = dimAxisIndex;
            this.dimensionCursorPosition[n] = this.dimensionCursorPosition[n] + range;
            return true;
        }
        this.dimensionCursorPosition[dimAxisIndex] = this.relationMap.mirrorLength[dimAxisIndex] - 1;
        return true;
    }

    boolean isBeforeFirst(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] < 0;
    }

    boolean isAfterLast(int dimAxisIndex) {
        int offset = this.findFowardOffsetRange(dimAxisIndex);
        return offset < 0;
    }

    boolean isFirst(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex] == 0;
    }

    boolean isLast(int dimAxisIndex) {
        int offset = this.findFowardOffsetRange(dimAxisIndex);
        return offset == 0;
    }

    void afterLast(int dimAxisIndex) {
        int offset = this.findFowardOffsetRange(dimAxisIndex);
        int n = dimAxisIndex;
        this.dimensionCursorPosition[n] = this.dimensionCursorPosition[n] + (offset + 1);
    }

    void beforeFirst(int dimAxisIndex) {
        this.dimensionCursorPosition[dimAxisIndex] = -1;
    }

    void setPosition(int dimAxisIndex, long position) {
        this.dimensionCursorPosition[dimAxisIndex] = (int)position;
    }

    long getPosition(int dimAxisIndex) {
        return this.dimensionCursorPosition[dimAxisIndex];
    }

    int getCurrentRowPosition(int dimAxisIndex) {
        EdgeInfo currentEdgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
        if (currentEdgeInfo == null) {
            return -1;
        }
        EdgeInfo outerMost = this.findOuterMostChildEdgeInfo(dimAxisIndex, currentEdgeInfo);
        return outerMost.firstChild;
    }

    int getEdgeStart(int dimAxisIndex) {
        if (this.relationMap.mirrorStartPosition == 0) {
            int outer = this.relationMap.mirrorStartPosition == 0 ? this.dimAxis.length : this.relationMap.mirrorStartPosition;
            EdgeInfo edgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
            if (edgeInfo == null) {
                return -1;
            }
            int endPosition = edgeInfo.firstChild;
            EdgeInfo info = edgeInfo;
            int position = dimAxisIndex + 1;
            while (position < outer) {
                info = (EdgeInfo)this.relationMap.currentRelation[position].get(endPosition);
                endPosition = info.firstChild;
                ++position;
            }
            return info.firstChild;
        }
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo edgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
            int start = this.findOuterMostChildEdgeInfoIndex(dimAxisIndex, edgeInfo);
            if (this.relationMap.mirrorStartPosition > 0 && start >= 0) {
                int i = this.relationMap.mirrorStartPosition;
                while (i < this.dimAxis.length) {
                    start *= this.relationMap.mirrorLength[i];
                    ++i;
                }
            }
            return start;
        }
        int start = this.caculateOffset(dimAxisIndex, true);
        if (start < 0) {
            return start;
        }
        if (dimAxisIndex == this.dimAxis.length - 1) {
            start += this.dimensionCursorPosition[dimAxisIndex];
        }
        return start;
    }

    int getEdgeEnd(int dimAxisIndex) {
        if (this.relationMap.mirrorStartPosition == 0) {
            EdgeInfo edgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
            if (edgeInfo == null) {
                return -1;
            }
            int endPosition = edgeInfo.firstChild;
            int index = this.relationMap.currentRelation[dimAxisIndex].indexOf(edgeInfo);
            if (index < this.relationMap.currentRelation[dimAxisIndex].size() - 1) {
                EdgeInfo nextEdgeInfo = (EdgeInfo)this.relationMap.currentRelation[dimAxisIndex].get(index + 1);
                EdgeInfo nextOuterEdgeInfo = this.findOuterMostChildEdgeInfo(dimAxisIndex, nextEdgeInfo);
                endPosition = nextOuterEdgeInfo.firstChild - 1;
            } else {
                endPosition = this.relationMap.traverseLength - 1;
            }
            return endPosition;
        }
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo edgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
            int index = this.relationMap.currentRelation[dimAxisIndex].indexOf(edgeInfo);
            if (index < this.relationMap.currentRelation[dimAxisIndex].size() - 1) {
                EdgeInfo nextEdgeInfo = (EdgeInfo)this.relationMap.currentRelation[dimAxisIndex].get(index + 1);
                int start = this.findOuterMostChildEdgeInfoIndex(dimAxisIndex, nextEdgeInfo);
                if (this.relationMap.mirrorStartPosition > 0) {
                    int i = this.relationMap.mirrorStartPosition;
                    while (i < this.dimAxis.length) {
                        start *= this.relationMap.mirrorLength[i];
                        ++i;
                    }
                }
                return start - 1;
            }
            return this.relationMap.traverseLength - 1;
        }
        int start = this.caculateOffset(dimAxisIndex, false);
        if (start < 0) {
            return start;
        }
        if (dimAxisIndex == this.dimAxis.length - 1) {
            start += this.dimensionCursorPosition[dimAxisIndex] + 1;
        }
        return start - 1;
    }

    void beforeFirst() {
        this.dimensionCursorPosition = this.findDimensionPosition(this.edgeStart - 1);
    }

    void first() {
        this.dimensionCursorPosition = this.findDimensionPosition(this.edgeStart);
    }

    boolean isInitialStatus() {
        int i = 0;
        while (i < this.dimensionCursorPosition.length) {
            if (this.dimensionCursorPosition[i] >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Object getCurrentMember(int dimAxisIndex, int attr) {
        return this.fetcher.getValue(this.dimAxis[dimAxisIndex].getLevelIndex(), attr);
    }

    Object getCurrentMember(int dimAxisIndex, String attrName) throws OLAPException {
        int attrIndex = this.fetcher.getAttributeIndex(this.dimAxis[dimAxisIndex].getLevelIndex(), attrName);
        if (attrIndex == -1) {
            throw new OLAPException("data.olap.invalidLevelAttr" + attrName);
        }
        return this.fetcher.getValue(this.dimAxis[dimAxisIndex].getLevelIndex(), attrIndex);
    }

    private EdgeInfo findOuterMostChildEdgeInfo(int dimAxisIndex, EdgeInfo edgeInfo) {
        if (dimAxisIndex < 0 || dimAxisIndex >= this.dimAxis.length || edgeInfo == null) {
            return null;
        }
        int endPosition = edgeInfo.firstChild;
        EdgeInfo info = edgeInfo;
        int i = dimAxisIndex + 1;
        while (i < this.dimAxis.length) {
            if (this.dimAxis[i].isMirrored()) break;
            info = (EdgeInfo)this.relationMap.currentRelation[i].get(endPosition);
            endPosition = info.firstChild;
            ++i;
        }
        return info;
    }

    private int caculateOffset(int dimAxisIndex, boolean isStart) {
        EdgeInfo edgeInfo = this.findCurrentEdgeInfo(this.relationMap.mirrorStartPosition - 1);
        int start = this.findOuterMostChildEdgeInfoIndex(this.relationMap.mirrorStartPosition - 1, edgeInfo);
        if (start < 0) {
            return start;
        }
        int i = this.relationMap.mirrorStartPosition;
        while (i < this.dimAxis.length) {
            start *= this.relationMap.mirrorLength[i];
            ++i;
        }
        int k = this.relationMap.mirrorStartPosition;
        while (k <= dimAxisIndex) {
            int offset = 1;
            int i2 = k + 1;
            while (i2 < this.dimAxis.length) {
                offset = k == dimAxisIndex && !isStart ? offset * (this.dimensionCursorPosition[k] + 1) * this.relationMap.mirrorLength[i2] : offset * this.dimensionCursorPosition[k] * this.relationMap.mirrorLength[i2];
                ++i2;
            }
            if (k + 1 < this.dimAxis.length) {
                start += offset;
            }
            ++k;
        }
        return start;
    }

    private int findOuterMostChildEdgeInfoIndex(int dimAxisIndex, EdgeInfo edgeInfo) {
        if (dimAxisIndex < 0 || dimAxisIndex >= this.dimAxis.length || edgeInfo == null) {
            return -1;
        }
        int endPosition = edgeInfo.firstChild;
        EdgeInfo info = edgeInfo;
        int index = dimAxisIndex + 1;
        while (index < this.dimAxis.length) {
            if (this.dimAxis[index].isMirrored()) break;
            info = (EdgeInfo)this.relationMap.currentRelation[index].get(endPosition);
            endPosition = info.firstChild;
            ++index;
        }
        if (index == this.relationMap.mirrorStartPosition) {
            return this.relationMap.currentRelation[index - 1].indexOf(info);
        }
        return this.relationMap.currentRelation[index].indexOf(info);
    }

    private boolean hasNext(int dimAxisIndex) {
        if (!this.dimAxis[dimAxisIndex].isMirrored()) {
            EdgeInfo currentEdgeInfo = this.findCurrentEdgeInfo(dimAxisIndex);
            if (currentEdgeInfo == null) {
                return this.dimensionCursorPosition[dimAxisIndex] < 0 && this.relationMap.traverseLength > 0;
            }
            int index = this.relationMap.currentRelation[dimAxisIndex].indexOf(currentEdgeInfo);
            EdgeInfo nextEdgeInfo = null;
            if (this.relationMap.currentRelation[dimAxisIndex].size() > index + 1) {
                nextEdgeInfo = (EdgeInfo)this.relationMap.currentRelation[dimAxisIndex].get(index + 1);
            }
            if (nextEdgeInfo == null) {
                return false;
            }
            return currentEdgeInfo.parent == nextEdgeInfo.parent;
        }
        return this.dimensionCursorPosition[dimAxisIndex] < this.relationMap.mirrorLength[dimAxisIndex] - 1;
    }

    private EdgeInfo findCurrentEdgeInfo(int dimensionAxis) {
        if (dimensionAxis < 0 || dimensionAxis > this.dimAxis.length) {
            return null;
        }
        EdgeInfo tempEdgeInfo1 = null;
        EdgeInfo tempEdgeInfo2 = null;
        EdgeInfo edgeInfo = null;
        int endPosition = 0;
        int index = 0;
        while (index <= dimensionAxis) {
            if (dimensionAxis == index) {
                if (this.relationMap.currentRelation[index].size() > endPosition && this.dimensionCursorPosition[index] > -1 && this.dimensionCursorPosition[index] + endPosition < this.relationMap.currentRelation[index].size() && (tempEdgeInfo2 == null || this.dimensionCursorPosition[index] + endPosition < tempEdgeInfo2.firstChild)) {
                    edgeInfo = (EdgeInfo)this.relationMap.currentRelation[index].get(this.dimensionCursorPosition[index] + endPosition);
                    break;
                }
                if (this.dimensionCursorPosition[index] != -1) break;
                return null;
            }
            if (this.dimensionCursorPosition[index] + endPosition < this.relationMap.currentRelation[index].size() && this.dimensionCursorPosition[index] > -1 && this.relationMap.currentRelation[index].size() > endPosition) {
                tempEdgeInfo1 = (EdgeInfo)this.relationMap.currentRelation[index].get(this.dimensionCursorPosition[index] + endPosition);
                if (this.dimensionCursorPosition[index] + endPosition + 1 < this.relationMap.currentRelation[index].size()) {
                    tempEdgeInfo2 = (EdgeInfo)this.relationMap.currentRelation[index].get(this.dimensionCursorPosition[index] + endPosition + 1);
                }
            } else {
                return null;
            }
            if (tempEdgeInfo1 != null) {
                endPosition = tempEdgeInfo1.firstChild;
            }
            ++index;
        }
        return edgeInfo;
    }

    private int findFowardOffsetRange(int dimensionAxis) {
        int range = -1;
        if (dimensionAxis < 0 || dimensionAxis > this.dimAxis.length) {
            return range;
        }
        if (dimensionAxis == 0) {
            if (this.dimensionCursorPosition[0] < this.relationMap.currentRelation[0].size()) {
                return this.relationMap.currentRelation[0].size() - this.dimensionCursorPosition[dimensionAxis] - 1;
            }
            return range;
        }
        if (dimensionAxis >= this.relationMap.mirrorStartPosition && this.relationMap.mirrorStartPosition > 0) {
            return this.relationMap.mirrorLength[dimensionAxis] - this.dimensionCursorPosition[dimensionAxis] - 1;
        }
        EdgeInfo currentInfo = this.findCurrentEdgeInfo(dimensionAxis);
        if (currentInfo == null) {
            return range;
        }
        range = 0;
        while (true) {
            int index = this.relationMap.currentRelation[dimensionAxis].indexOf(currentInfo);
            EdgeInfo nextEdgeInfo = null;
            if (this.relationMap.currentRelation[dimensionAxis].size() <= index + 1 || (nextEdgeInfo = (EdgeInfo)this.relationMap.currentRelation[dimensionAxis].get(index + 1)) == null || currentInfo.parent != nextEdgeInfo.parent) break;
            ++range;
            currentInfo = nextEdgeInfo;
        }
        return range;
    }
}

