/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.olap.cursor.EdgeInfo;
import org.eclipse.birt.data.engine.olap.cursor.ResultSetFetcher;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.cursor.Section;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DimensionAxis;

class EdgeDimensionRelation {
    List[] currentRelation;
    int traverseLength;
    int mirrorStartPosition;
    int[] mirrorLength;
    ResultSetFetcher fetcher;
    private List sectionList;

    EdgeDimensionRelation(RowDataAccessorService service, ResultSetFetcher fetcher, int fetchSize, boolean isPage) throws IOException {
        IAggregationResultSet rs = service.getAggregationResultSet();
        DimensionAxis[] dimAxis = service.getDimensionAxis();
        this.mirrorStartPosition = service.getMirrorStartPosition();
        this.mirrorLength = new int[dimAxis.length];
        this.sectionList = new ArrayList();
        this.fetcher = fetcher;
        int i = 0;
        while (i < dimAxis.length) {
            this.mirrorLength[i] = i >= this.mirrorStartPosition && this.mirrorStartPosition > 0 ? service.getDimensionAxis()[i].getDisctinctValue().size() : 0;
            ++i;
        }
        int customDimSize = this.mirrorStartPosition > 0 ? this.mirrorStartPosition : dimAxis.length;
        this.traverseLength = fetchSize > 0 && rs.length() > fetchSize ? fetchSize : rs.length();
        Object[] preValue = new Object[customDimSize];
        Object[] currValue = new Object[customDimSize];
        Section section = null;
        boolean newSection = true;
        int startId = 0;
        if (this.traverseLength == 0) {
            section = new Section(customDimSize, -1, -1);
            this.sectionList.add(section);
            this.currentRelation = ((Section)this.sectionList.get(0)).getRelation();
        } else {
            int rowId = 0;
            while (rowId < this.traverseLength) {
                int breakLevel;
                rs.seek(rowId);
                int i2 = 0;
                while (i2 < customDimSize) {
                    currValue[i2] = fetcher.getLevelKeyValue(service.getDimensionAxis()[i2].getLevelIndex())[fetcher.getAggrResultSet().getLevelKeyColCount(service.getDimensionAxis()[i2].getLevelIndex()) - 1];
                    ++i2;
                }
                if (newSection) {
                    section = new Section(customDimSize, -1, -1);
                    newSection = false;
                    this.sectionList.add(section);
                    breakLevel = 0;
                } else {
                    breakLevel = this.getBreakLevel(currValue, preValue, section, rowId);
                    if (breakLevel <= service.getPagePosition() && !isPage) {
                        section.setBaseStart(startId);
                        section.setBaseEnd(rowId - 1);
                        startId = rowId--;
                        newSection = true;
                    }
                }
                if (!newSection) {
                    int level = breakLevel;
                    while (level < customDimSize) {
                        EdgeInfo edge = new EdgeInfo();
                        if (level != 0) {
                            edge.parent = section.getRelation()[level - 1].size() - 1;
                        }
                        edge.firstChild = level == section.getRelation().length - 1 ? rowId : section.getRelation()[level + 1].size();
                        section.getRelation()[level].add(edge);
                        ++level;
                    }
                    int i3 = 0;
                    while (i3 < customDimSize) {
                        preValue[i3] = currValue[i3];
                        ++i3;
                    }
                }
                ++rowId;
            }
            section.setBaseStart(startId);
            section.setBaseEnd(this.traverseLength - 1);
            this.currentRelation = ((Section)this.sectionList.get(0)).getRelation();
            if (this.mirrorStartPosition > 0) {
                this.traverseLength = this.currentRelation[this.mirrorStartPosition - 1].size();
                int i4 = this.mirrorStartPosition;
                while (i4 < dimAxis.length) {
                    this.traverseLength *= this.mirrorLength[i4];
                    ++i4;
                }
            } else {
                this.traverseLength = ((Section)this.sectionList.get(0)).getBaseEnd() - ((Section)this.sectionList.get(0)).getBaseStart() + 1;
            }
        }
    }

    private int getBreakLevel(Object[] currValue, Object[] preValue, Section section, int rowId) {
        assert (preValue != null && currValue != null);
        int breakLevel = 0;
        while (breakLevel < currValue.length) {
            List list = section.getRelation()[breakLevel];
            EdgeInfo edgeInfo = (EdgeInfo)list.get(list.size() - 1);
            int child = edgeInfo.firstChild;
            Object currObjectValue = currValue[breakLevel];
            Object prevObjectValue = preValue[breakLevel];
            int level = breakLevel + 1;
            while (level < section.getRelation().length) {
                list = section.getRelation()[level];
                edgeInfo = (EdgeInfo)list.get(child);
                child = edgeInfo.firstChild;
                ++level;
            }
            if (!this.isEqualObject(currObjectValue, prevObjectValue)) break;
            ++breakLevel;
        }
        return breakLevel;
    }

    public void synchronizedWithPage(int position) {
        if (this.sectionList.size() > position) {
            this.currentRelation = ((Section)this.sectionList.get(position)).getRelation();
            if (this.mirrorStartPosition > 0) {
                this.traverseLength = this.currentRelation[this.mirrorStartPosition - 1].size();
                int i = this.mirrorStartPosition;
                while (i < this.mirrorLength.length) {
                    this.traverseLength *= this.mirrorLength[i];
                    ++i;
                }
            } else {
                this.traverseLength = ((Section)this.sectionList.get(position)).getBaseEnd() - ((Section)this.sectionList.get(position)).getBaseStart() + 1;
            }
        }
    }

    private boolean isEqualObject(Object preValue, Object currentValue) {
        if (preValue == currentValue) {
            return true;
        }
        if (preValue == null || currentValue == null) {
            return false;
        }
        return preValue.equals(currentValue);
    }
}

