/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.cursor.DimensionTraverse;
import org.eclipse.birt.data.engine.olap.cursor.EdgeTraverse;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataAccessorService;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;

public class SubRowDataAccessor
extends RowDataAccessor {
    private int startingLevel = -1;
    private int edgeStart = 0;
    private int edgeEnd = 0;
    private RowDataAccessor parentNavigator;
    private IAggregationResultSet rs;
    private RowDataAccessorService service;

    public SubRowDataAccessor(RowDataAccessorService service, IRowDataAccessor parentNavigator, int startingLevel) {
        super(service);
        this.parentNavigator = (RowDataAccessor)parentNavigator;
        this.startingLevel = startingLevel;
        this.service = service;
        this.rs = service.getAggregationResultSet();
    }

    public void initialize(boolean isPage) throws IOException {
        if (this.startingLevel < 0) {
            this.edgeStart = 0;
            int fetchSize = this.parentNavigator.getDataAccessorService().getFetchSize();
            this.edgeEnd = fetchSize > 0 && this.rs.length() > fetchSize ? fetchSize - 1 : this.parentNavigator.edgeDimensRelation.traverseLength - 1;
        } else {
            this.edgeStart = this.parentNavigator.getEdgeStart(this.startingLevel);
            this.edgeEnd = this.parentNavigator.getEdgeEnd(this.startingLevel);
        }
        this.edgeDimensRelation = this.parentNavigator.edgeDimensRelation;
        this.dimTraverse = new DimensionTraverse(this.service.getDimensionAxis(), this.parentNavigator.edgeDimensRelation, this.edgeStart, this.edgeEnd);
        this.edgeTraverse = new EdgeTraverse(this.parentNavigator.edgeDimensRelation, this.edgeStart, this.edgeEnd);
    }
}

