/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.BufferedRandomDataAccessObject;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.document.SimpleRandomAccessObject;

public class DirectoryDocumentManager
implements IDocumentManager {
    private String documentDir = null;

    public DirectoryDocumentManager(final String documentDir, final boolean deleteOld) throws DataException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    DirectoryDocumentManager.this.documentDir = documentDir;
                    File dir = new File(documentDir);
                    if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
                        throw new DataException("data.olap.OlapDirCreateFail", documentDir);
                    }
                    if (deleteOld) {
                        File[] oldFiles = dir.listFiles();
                        int i = 0;
                        while (i < oldFiles.length) {
                            oldFiles[i].delete();
                            ++i;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    public void close() throws IOException {
    }

    public IDocumentObject createDocumentObject(final String documentObjectName) throws IOException {
        try {
            return (IDocumentObject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File file = new File(String.valueOf(DirectoryDocumentManager.this.documentDir) + File.separatorChar + documentObjectName);
                    if (file.exists()) {
                        return null;
                    }
                    if (!file.createNewFile()) {
                        return null;
                    }
                    return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IDocumentObject openDocumentObject(String documentObjectName) throws IOException {
        final File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        Boolean piTmp0 = null;
        piTmp0 = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (!piTmp0.booleanValue()) {
            return null;
        }
        return new DocumentObject(new BufferedRandomDataAccessObject(new SimpleRandomAccessObject(file, "rw"), 1024));
    }

    public boolean exist(String documentObjectName) {
        final File file = new File(String.valueOf(this.documentDir) + File.separatorChar + documentObjectName);
        Boolean piTmp0 = null;
        piTmp0 = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(file.exists());
            }
        });
        return piTmp0;
    }

    public void flush() throws IOException {
    }
}

