/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import java.sql.Time;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class DocumentObjectUtil {
    public static void writeValue(IDocumentObject documentObject, int[] dataType, Object[] value) throws IOException, DataException {
        int i = 0;
        while (i < dataType.length) {
            DocumentObjectUtil.writeValue(documentObject, dataType[i], value[i]);
            ++i;
        }
    }

    public static void writeValue(IDocumentObject documentObject, int dataType, Object value) throws IOException, DataException {
        try {
            if (value == null) {
                documentObject.writeByte(0);
                return;
            }
            documentObject.writeByte(1);
            switch (dataType) {
                case 1: {
                    documentObject.writeBoolean(DataTypeUtil.toBoolean((Object)value));
                    break;
                }
                case 2: {
                    documentObject.writeInt(DataTypeUtil.toInteger((Object)value));
                    break;
                }
                case 3: {
                    documentObject.writeDouble(DataTypeUtil.toDouble((Object)value));
                    break;
                }
                case 5: {
                    documentObject.writeString(DataTypeUtil.toString((Object)value));
                    break;
                }
                case 6: {
                    documentObject.writeDate(DataTypeUtil.toDate((Object)value));
                    break;
                }
                case 4: {
                    documentObject.writeBigDecimal(DataTypeUtil.toBigDecimal((Object)value));
                    break;
                }
                case 7: {
                    Bytes bytesValue = new Bytes((byte[])value);
                    documentObject.writeBytes(bytesValue);
                    break;
                }
                case 102: {
                    documentObject.writeBytes((Bytes)value);
                    break;
                }
                case 9: {
                    if (value instanceof java.sql.Date) {
                        documentObject.writeDate((Date)value);
                    } else {
                        documentObject.writeDate(DataTypeUtil.toSqlDate((Object)value));
                    }
                    break;
                }
                case 10: {
                    if (value instanceof Time) {
                        documentObject.writeDate((Date)value);
                    } else {
                        documentObject.writeDate(DataTypeUtil.toSqlTime((Object)value));
                    }
                    break;
                }
                default: {
                    assert (false);
                }
            }
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public static Object[] readValue(IDocumentObject documentObject, int[] dataType) throws IOException {
        Object[] result = new Object[dataType.length];
        int i = 0;
        while (i < result.length) {
            result[i] = DocumentObjectUtil.readValue(documentObject, dataType[i]);
            ++i;
        }
        return result;
    }

    public static Object readValue(IDocumentObject documentObject, int dataType) throws IOException {
        byte nullSign = documentObject.readByte();
        if (nullSign == 0) {
            return null;
        }
        switch (dataType) {
            case 1: {
                return new Boolean(documentObject.readBoolean());
            }
            case 2: {
                return new Integer(documentObject.readInt());
            }
            case 3: {
                return new Double(documentObject.readDouble());
            }
            case 5: {
                return documentObject.readString();
            }
            case 6: {
                return documentObject.readDate();
            }
            case 4: {
                return documentObject.readBigDecimal();
            }
            case 7: {
                return documentObject.readBytes().bytesValue();
            }
            case 102: {
                return documentObject.readBytes();
            }
            case 9: {
                Date date = documentObject.readDate();
                if (date == null) {
                    return null;
                }
                return new java.sql.Date(date.getTime());
            }
            case 10: {
                Date time = documentObject.readDate();
                if (time == null) {
                    return null;
                }
                return new Time(time.getTime());
            }
        }
        assert (false);
        return null;
    }
}

