/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.aggregation.AggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.FacttableRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.IJSMeasureFilterEvalHelper;

public class AggregationCalculator {
    AggregationDefinition aggregation;
    private Accumulator[] accumulators;
    private int levelCount;
    private int[] measureIndexes;
    private MeasureInfo[] measureInfos;
    private IDiskArray result = null;
    private IAggregationResultRow currentResultObj = null;
    private int[] parameterColIndex;
    private FacttableRow facttableRow;
    private static Logger logger = Logger.getLogger(AggregationCalculator.class.getName());

    AggregationCalculator(AggregationDefinition aggregationDef, DimColumn[] parameterColNames, IDataSet4Aggregation.MetaInfo metaInfo) throws IOException, DataException {
        Object[] params = new Object[]{aggregationDef, parameterColNames, metaInfo};
        logger.entering(AggregationCalculator.class.getName(), "AggregationCalculator", params);
        this.aggregation = aggregationDef;
        AggregationFunctionDefinition[] aggregationFunction = aggregationDef.getAggregationFunctions();
        this.levelCount = aggregationDef.getLevels() == null ? 0 : aggregationDef.getLevels().length;
        if (aggregationFunction != null) {
            this.accumulators = new Accumulator[aggregationFunction.length];
            this.measureIndexes = new int[aggregationFunction.length];
            this.parameterColIndex = new int[aggregationFunction.length];
            int i = 0;
            while (i < aggregationFunction.length) {
                IAggrFunction aggregation = AggregationManager.getInstance().getAggregation(aggregationFunction[i].getFunctionName());
                if (aggregation == null) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + aggregationFunction[i].getFunctionName());
                }
                this.parameterColIndex[i] = AggregationUtil.needDataField(aggregation) ? AggregationCalculator.find(parameterColNames, aggregationFunction[i].getParaCol()) : -1;
                this.accumulators[i] = aggregation.newAccumulator();
                this.accumulators[i].start();
                String measureName = aggregationFunction[i].getMeasureName();
                this.measureIndexes[i] = metaInfo.getMeasureIndex(measureName);
                if (this.measureIndexes[i] == -1 && measureName != null) {
                    throw new DataException("data.olap.measureNameNotFound", measureName);
                }
                ++i;
            }
        }
        this.result = new BufferedStructureArray(AggregationResultRow.getCreator(), 4000);
        this.measureInfos = metaInfo.getMeasureInfos();
        this.facttableRow = new FacttableRow(this.measureInfos);
        logger.exiting(AggregationCalculator.class.getName(), "AggregationCalculator");
    }

    private static int find(DimColumn[] colArray, DimColumn col) {
        if (colArray == null || col == null) {
            return -1;
        }
        int i = 0;
        while (i < colArray.length) {
            if (col.equals(colArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void onRow(Row4Aggregation row) throws IOException, DataException {
        if (this.currentResultObj == null) {
            this.newAggregationResultRow(row);
        } else if (this.currentResultObj.getLevelMembers() == null || this.compare(row.getLevelMembers(), this.currentResultObj.getLevelMembers()) == 0) {
            if (this.accumulators != null) {
                int i = 0;
                while (i < this.accumulators.length) {
                    if (this.getFilterResult(row, i)) {
                        this.accumulators[i].onRow(this.getAccumulatorParameter(row, i));
                    }
                    ++i;
                }
            }
        } else {
            if (this.accumulators != null) {
                this.currentResultObj.setAggregationValues(new Object[this.accumulators.length]);
                int i = 0;
                while (i < this.accumulators.length) {
                    this.accumulators[i].finish();
                    this.currentResultObj.getAggregationValues()[i] = this.accumulators[i].getValue();
                    this.accumulators[i].start();
                    ++i;
                }
            }
            this.result.add(this.currentResultObj);
            this.newAggregationResultRow(row);
        }
    }

    private boolean getFilterResult(Row4Aggregation row, int functionNo) throws DataException {
        this.facttableRow.setMeasure(row.getMeasures());
        IJSMeasureFilterEvalHelper filterEvalHelper = this.aggregation.getAggregationFunctions()[functionNo].getFilterEvalHelper();
        if (filterEvalHelper == null) {
            return true;
        }
        return filterEvalHelper.evaluateFilter(this.facttableRow);
    }

    IDiskArray getResult() throws IOException, DataException {
        if (this.currentResultObj != null && this.accumulators != null) {
            this.currentResultObj.setAggregationValues(new Object[this.accumulators.length]);
            int i = 0;
            while (i < this.accumulators.length) {
                this.accumulators[i].finish();
                this.currentResultObj.getAggregationValues()[i] = this.accumulators[i].getValue();
                this.accumulators[i].start();
                ++i;
            }
        }
        if (this.currentResultObj != null) {
            this.result.add(this.currentResultObj);
        }
        return this.result;
    }

    private void newAggregationResultRow(Row4Aggregation row) throws DataException {
        this.currentResultObj = new AggregationResultRow();
        if (this.levelCount > 0) {
            this.currentResultObj.setLevelMembers(new Member[this.levelCount]);
            System.arraycopy(row.getLevelMembers(), 0, this.currentResultObj.getLevelMembers(), 0, this.currentResultObj.getLevelMembers().length);
        }
        if (this.accumulators != null) {
            int i = 0;
            while (i < this.accumulators.length) {
                if (this.getFilterResult(row, i)) {
                    this.accumulators[i].onRow(this.getAccumulatorParameter(row, i));
                }
                ++i;
            }
        }
    }

    private Object[] getAccumulatorParameter(Row4Aggregation row, int funcIndex) {
        Object[] parameters = null;
        if (this.parameterColIndex[funcIndex] == -1) {
            parameters = new Object[1];
            if (this.measureIndexes[funcIndex] < 0) {
                return null;
            }
            parameters[0] = row.getMeasures()[this.measureIndexes[funcIndex]];
        } else {
            parameters = new Object[]{this.measureIndexes[funcIndex] < 0 ? null : row.getMeasures()[this.measureIndexes[funcIndex]], row.getParameterValues()[this.parameterColIndex[funcIndex]]};
        }
        return parameters;
    }

    private int compare(Object[] key1, Object[] key2) {
        int i = 0;
        while (i < this.aggregation.getLevels().length) {
            int result = ((Comparable)key1[i]).compareTo(key2[i]);
            if (result < 0) {
                return result;
            }
            if (result > 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }
}

