/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;

public class DataSetFromAggregationResultSet
implements IDataSet4Aggregation {
    private IAggregationResultSet aggregationResultSet;
    DummyDimension[] dimensions;
    private int currentCursor = -1;

    public DataSetFromAggregationResultSet(IAggregationResultSet aggregationResultSet) {
        this.aggregationResultSet = aggregationResultSet;
        this.initDummyDimensions();
    }

    private void initDummyDimensions() {
        DimLevel[] dimLevels = this.aggregationResultSet.getAllLevels();
        if (dimLevels == null || dimLevels.length == 0) {
            this.dimensions = new DummyDimension[0];
            return;
        }
        HashMap<String, HashSet<String>> dimNameToLevelNamesMap = new HashMap<String, HashSet<String>>();
        DimLevel[] dimLevelArray = dimLevels;
        int n = dimLevels.length;
        int n2 = 0;
        while (n2 < n) {
            DimLevel dl = dimLevelArray[n2];
            String dimName = dl.getDimensionName();
            HashSet<String> levelNames = (HashSet<String>)dimNameToLevelNamesMap.get(dimName);
            if (levelNames == null) {
                levelNames = new HashSet<String>();
                dimNameToLevelNamesMap.put(dimName, levelNames);
            }
            levelNames.add(dl.getLevelName());
            ++n2;
        }
        this.dimensions = new DummyDimension[dimNameToLevelNamesMap.keySet().size()];
        int i = 0;
        for (String dimName : dimNameToLevelNamesMap.keySet()) {
            Set levelNameSet = (Set)dimNameToLevelNamesMap.get(dimName);
            String[] levelNames = levelNameSet.toArray(new String[0]);
            DummyDimension dd = new DummyDimension(dimName, levelNames);
            int[] indexesInAggregationResultSet = new int[levelNames.length];
            int j = 0;
            while (j < indexesInAggregationResultSet.length) {
                DimLevel dl = new DimLevel(dimName, levelNames[j]);
                indexesInAggregationResultSet[j] = this.aggregationResultSet.getLevelIndex(dl);
                ++j;
            }
            dd.setDimLevelIndexesInAggregationResultSet(indexesInAggregationResultSet);
            this.dimensions[i++] = dd;
        }
    }

    private DummyDimension getDimension(String dimensionName) {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].getDimensionName().equals(dimensionName)) {
                return this.dimensions[i];
            }
            ++i;
        }
        return null;
    }

    private DummyDimension getDimension(int dimIndex) {
        return this.dimensions[dimIndex];
    }

    private int getDimensionIndex(String dimensionName) {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].getDimensionName().equals(dimensionName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getInnerIndexInAggregationResultSet(int dimIndex, int levelIndex) {
        DummyDimension dd = this.getDimension(dimIndex);
        return dd.getIndexInAggregationResultSet(levelIndex);
    }

    public Object getMeasureValue(int measureIndex) throws IOException {
        return this.aggregationResultSet.getAggregationValue(measureIndex);
    }

    public Member getMember(int dimIndex, int levelIndex) throws BirtException, IOException {
        int index = this.getInnerIndexInAggregationResultSet(dimIndex, levelIndex);
        return this.aggregationResultSet.getCurrentRow().getLevelMembers()[index];
    }

    public IDataSet4Aggregation.MetaInfo getMetaInfo() {
        return new IDataSet4Aggregation.MetaInfo(){

            public String[] getAttributeNames(int dimIndex, int levelIndex) {
                int index = DataSetFromAggregationResultSet.this.getInnerIndexInAggregationResultSet(dimIndex, levelIndex);
                return DataSetFromAggregationResultSet.this.aggregationResultSet.getAggributeNames()[index];
            }

            public IDataSet4Aggregation.ColumnInfo getColumnInfo(DimColumn dimColumn) throws DataException {
                String dimensionName = dimColumn.getDimensionName();
                String levelName = dimColumn.getLevelName();
                String columnName = dimColumn.getColumnName();
                int dimIndex = DataSetFromAggregationResultSet.this.getDimensionIndex(dimensionName);
                if (dimIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentDimension")) + dimensionName);
                }
                DummyDimension dd = DataSetFromAggregationResultSet.this.getDimension(dimensionName);
                int levelIndex = dd.getLevelIndex(levelName);
                if (levelIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + "<" + dimensionName + " , " + levelName + ">");
                }
                DimLevel dl = new DimLevel(dimensionName, levelName);
                int index = DataSetFromAggregationResultSet.this.aggregationResultSet.getLevelIndex(dl);
                int columnIndex = -1;
                boolean isKey = false;
                String[] keys = DataSetFromAggregationResultSet.this.aggregationResultSet.getKeyNames()[index];
                int i = 0;
                while (i < keys.length) {
                    if (keys[i].equals(columnName)) {
                        columnIndex = i;
                        isKey = true;
                        break;
                    }
                    ++i;
                }
                if (!isKey) {
                    String[] attrs = DataSetFromAggregationResultSet.this.aggregationResultSet.getAggributeNames()[index];
                    int i2 = 0;
                    while (i2 < attrs.length) {
                        if (attrs[i2].equals(columnName)) {
                            columnIndex = i2;
                            break;
                        }
                        ++i2;
                    }
                }
                if (columnIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentKeyOrAttr")) + "<" + dimensionName + " , " + levelName + " , " + columnName + ">");
                }
                return new IDataSet4Aggregation.ColumnInfo(dimIndex, levelIndex, columnIndex, isKey);
            }

            public int getDimensionIndex(String dimensionName) {
                return DataSetFromAggregationResultSet.this.getDimensionIndex(dimensionName);
            }

            public String[] getKeyNames(int dimIndex, int levelIndex) {
                int index = DataSetFromAggregationResultSet.this.getInnerIndexInAggregationResultSet(dimIndex, levelIndex);
                return DataSetFromAggregationResultSet.this.aggregationResultSet.getKeyNames()[index];
            }

            public int getLevelIndex(String dimensionName, String levelName) {
                DummyDimension dd = DataSetFromAggregationResultSet.this.getDimension(dimensionName);
                if (dd != null) {
                    return dd.getLevelIndex(levelName);
                }
                return -1;
            }

            public int getMeasureIndex(String measureName) throws IOException {
                return DataSetFromAggregationResultSet.this.aggregationResultSet.getAggregationIndex(measureName);
            }

            public MeasureInfo[] getMeasureInfos() throws IOException {
                int aggrCount = DataSetFromAggregationResultSet.this.aggregationResultSet.getAggregationCount();
                MeasureInfo[] mis = new MeasureInfo[aggrCount];
                int i = 0;
                while (i < aggrCount) {
                    MeasureInfo mi;
                    mis[i] = mi = new MeasureInfo(DataSetFromAggregationResultSet.this.aggregationResultSet.getAggregationName(i), DataSetFromAggregationResultSet.this.aggregationResultSet.getAggregationDataType(i));
                    ++i;
                }
                return mis;
            }
        };
    }

    public boolean next() throws DataException, IOException {
        if (this.aggregationResultSet.length() <= 0) {
            return false;
        }
        ++this.currentCursor;
        if (this.currentCursor < this.aggregationResultSet.length()) {
            this.aggregationResultSet.seek(this.currentCursor);
            return true;
        }
        return false;
    }

    static class DummyDimension {
        String dimensionName;
        String[] levelNames;
        int[] dimLevelIndexesInAggregationResultSet;

        public DummyDimension(String dimensionName, String[] levelNames) {
            this.dimensionName = dimensionName;
            this.levelNames = levelNames;
        }

        public void setDimLevelIndexesInAggregationResultSet(int[] indexes) {
            this.dimLevelIndexesInAggregationResultSet = indexes;
        }

        public int getIndexInAggregationResultSet(int levelIndex) {
            return this.dimLevelIndexesInAggregationResultSet[levelIndex];
        }

        public String getLevelName(int index) {
            return this.levelNames[index];
        }

        public int getLevelIndex(String name) {
            int i = 0;
            while (i < this.levelNames.length) {
                if (this.levelNames[i].equals(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }
    }
}

