/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AbstractRowAccessor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class AggregationRowAccessor
extends AbstractRowAccessor {
    private IAggregationResultSet resultSet;

    public AggregationRowAccessor(IAggregationResultSet resultSet) {
        this.resultSet = resultSet;
        this.populateFieldIndexMap();
    }

    protected void populateFieldIndexMap() {
        int i = 0;
        while (i < this.resultSet.getLevelCount()) {
            DimLevel level = this.resultSet.getAllLevels()[i];
            int j = 0;
            while (j < this.resultSet.getLevelKeyColCount(i)) {
                String levelKeyName = this.resultSet.getLevelKeyName(i, j);
                String name = OlapExpressionUtil.getAttrReference(level.getDimensionName(), level.getLevelName(), levelKeyName);
                this.fieldIndexMap.put(name, new AggregationKeyIndex(i, j));
                ++j;
            }
            String[] attrNames = this.resultSet.getLevelAttributes(i);
            if (attrNames != null) {
                int j2 = 0;
                while (j2 < attrNames.length) {
                    String attrName = this.parseAttributeName(attrNames[j2]);
                    String name = OlapExpressionUtil.getAttrReference(level.getDimensionName(), level.getLevelName(), attrName);
                    this.fieldIndexMap.put(name, new AggregationAttrIndex(i, j2));
                    ++j2;
                }
            }
            ++i;
        }
    }

    public Object getAggrValue(String aggrName) throws DataException {
        try {
            int aggrIndex = this.resultSet.getAggregationIndex(aggrName);
            return this.resultSet.getAggregationValue(aggrIndex);
        }
        catch (IOException e) {
            throw new DataException("", e);
        }
    }

    public Object getFieldValue(String fieldName) throws DataException {
        AbstractRowAccessor.FieldIndex index = (AbstractRowAccessor.FieldIndex)this.fieldIndexMap.get(fieldName);
        return index != null ? index.getValue() : null;
    }

    class AggregationAttrIndex
    extends AbstractRowAccessor.AttributeIndex {
        AggregationAttrIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() {
            return AggregationRowAccessor.this.resultSet.getLevelAttribute(this.levelIndex, this.attrIndex);
        }
    }

    class AggregationKeyIndex
    extends AbstractRowAccessor.KeyIndex {
        AggregationKeyIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() {
            return AggregationRowAccessor.this.resultSet.getLevelKeyValue(this.levelIndex)[this.keyIndex];
        }
    }
}

