/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AbstractRowAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;

public class DimensionRowAccessor
extends AbstractRowAccessor {
    private Dimension dimension;
    private DimensionRow dimRow;

    public DimensionRowAccessor(Dimension dimension) {
        this.dimension = dimension;
        this.populateFieldIndexMap();
    }

    protected void populateFieldIndexMap() {
        this.fieldIndexMap = new HashMap();
        ILevel[] levels = this.dimension.getHierarchy().getLevels();
        int i = 0;
        while (i < levels.length) {
            String[] attrNames;
            String[] keyNames = levels[i].getKeyNames();
            if (keyNames != null) {
                int j = 0;
                while (j < keyNames.length) {
                    String name = OlapExpressionUtil.getAttrReference(this.dimension.getName(), levels[i].getName(), keyNames[j]);
                    this.fieldIndexMap.put(name, new DimensionKeyIndex(i, j));
                    ++j;
                }
            }
            if ((attrNames = levels[i].getAttributeNames()) != null) {
                int j = 0;
                while (j < attrNames.length) {
                    String attrName = this.parseAttributeName(attrNames[j]);
                    String name = OlapExpressionUtil.getAttrReference(this.dimension.getName(), levels[i].getName(), attrName);
                    this.fieldIndexMap.put(name, new DimensionAttrIndex(i, j));
                    ++j;
                }
            }
            ++i;
        }
    }

    public void seek(int position) throws IOException {
        this.dimRow = this.dimension.getRowByPosition(position);
    }

    public DimensionRow getCurrentRow() {
        return this.dimRow;
    }

    public Object getAggrValue(String aggrName) throws DataException {
        return null;
    }

    public Object getFieldValue(String fieldName) throws DataException {
        if (this.dimRow == null) {
            throw new DataException("data.olap.CannotAccessNullDimensionRow");
        }
        AbstractRowAccessor.FieldIndex index = (AbstractRowAccessor.FieldIndex)this.fieldIndexMap.get(fieldName);
        return index != null ? index.getValue() : null;
    }

    class DimensionAttrIndex
    extends AbstractRowAccessor.AttributeIndex {
        DimensionAttrIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() throws DataException {
            return DimensionRowAccessor.this.dimRow.getMembers()[this.levelIndex].getAttributes()[this.attrIndex];
        }
    }

    class DimensionKeyIndex
    extends AbstractRowAccessor.KeyIndex {
        DimensionKeyIndex(int levelIndex, int keyIndex) {
            super(levelIndex, keyIndex);
        }

        Object getValue() throws DataException {
            return DimensionRowAccessor.this.dimRow.getMembers()[this.levelIndex].getKeyValues()[this.keyIndex];
        }
    }
}

