/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationRowAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.CompareIndex;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.WrapperedDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.sort.IJSSortHelper;

public class AggregationSortHelper {
    public static IAggregationResultSet sort(IAggregationResultSet base, ITargetSort[] targetSorts, IAggregationResultSet[] targetResultSets) throws IOException, DataException {
        IDiskArray baseDiskArray = AggregationSortHelper.getRowsFromBaseResultSet(base);
        IDiskArray[] keyDiskArrays = AggregationSortHelper.populateKeyDiskArray(base, targetSorts, targetResultSets);
        CompareUtil.sort(new WrapperedDiskArray(baseDiskArray, keyDiskArrays), new AggrResultRowComparator(base, targetSorts), AggregationResultRow.getCreator());
        AggregationSortHelper.releaseDiskArrays(keyDiskArrays);
        return new AggregationResultSet(base.getAggregationDefinition(), baseDiskArray, base.getKeyNames(), base.getAggributeNames());
    }

    private static void releaseDiskArrays(IDiskArray[] keyDiskArrays) throws IOException {
        int i = 0;
        while (i < keyDiskArrays.length) {
            keyDiskArrays[i].close();
            ++i;
        }
    }

    private static IDiskArray getRowsFromBaseResultSet(IAggregationResultSet base) throws IOException {
        BufferedStructureArray diskArray = new BufferedStructureArray(AggregationResultRow.getCreator(), 4096);
        int j = 0;
        while (j < base.length()) {
            base.seek(j);
            IAggregationResultRow temp = base.getCurrentRow();
            diskArray.add(temp);
            ++j;
        }
        return diskArray;
    }

    private static IDiskArray[] populateKeyDiskArray(IAggregationResultSet base, ITargetSort[] targetSorts, IAggregationResultSet[] targetResultSets) throws DataException, IOException {
        IDiskArray[] keyDiskArrays = new IDiskArray[targetSorts.length];
        int i = 0;
        while (i < keyDiskArrays.length) {
            keyDiskArrays[i] = new BufferedPrimitiveDiskArray();
            ++i;
        }
        HashMap<DimLevel, ArrayList<Integer>> indexMap = new HashMap<DimLevel, ArrayList<Integer>>();
        ArrayList<Integer> sortHelperIndex = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < targetSorts.length) {
            if (targetSorts[i2] instanceof AggrSortDefinition) {
                DimLevel targetLevel = targetSorts[i2].getTargetLevel();
                ArrayList<Integer> sortDefnIndex = (ArrayList<Integer>)indexMap.get(targetLevel);
                if (sortDefnIndex == null) {
                    sortDefnIndex = new ArrayList<Integer>();
                    indexMap.put(targetLevel, sortDefnIndex);
                }
                sortDefnIndex.add(new Integer(i2));
            } else {
                sortHelperIndex.add(new Integer(i2));
            }
            ++i2;
        }
        Iterator itr = indexMap.values().iterator();
        while (itr.hasNext()) {
            int[] sortIndex = AggregationSortHelper.toIntArray((List)itr.next());
            if (sortIndex.length <= 0) continue;
            AggregationSortHelper.populateAggrKeysForTargetLevel(base, sortIndex, targetSorts, targetResultSets, keyDiskArrays);
        }
        int[] sortIndex = AggregationSortHelper.toIntArray(sortHelperIndex);
        if (sortIndex.length > 0) {
            AggregationSortHelper.populateExprKeyDiskArray(base, targetSorts, sortIndex, keyDiskArrays);
        }
        return keyDiskArrays;
    }

    private static void populateAggrKeysForTargetLevel(IAggregationResultSet base, int[] sortIndex, ITargetSort[] targetSorts, IAggregationResultSet[] targetResultSets, IDiskArray[] keyDiskArrays) throws IOException {
        HashMap<IAggregationResultSet, ArrayList<Integer>> map = new HashMap<IAggregationResultSet, ArrayList<Integer>>();
        int i = 0;
        while (i < sortIndex.length) {
            int index = sortIndex[i];
            ArrayList<Integer> list = (ArrayList<Integer>)map.get(targetResultSets[index]);
            if (list == null) {
                list = new ArrayList<Integer>();
                map.put(targetResultSets[index], list);
            }
            list.add(new Integer(index));
            ++i;
        }
        for (IAggregationResultSet resultSet : map.keySet()) {
            int[] targetSortIndex = AggregationSortHelper.toIntArray((List)map.get(resultSet));
            AggregationSortHelper.populateAggrKeysForTargetResultSet(base, resultSet, targetSortIndex, targetSorts, keyDiskArrays);
        }
    }

    private static void populateAggrKeysForTargetResultSet(IAggregationResultSet base, IAggregationResultSet targetResultSet, int[] sortIndex, ITargetSort[] targetSorts, IDiskArray[] keyDiskArrays) throws IOException {
        AggrSortDefinition sortDefinition = (AggrSortDefinition)targetSorts[sortIndex[0]];
        DimLevel targetLevel = sortDefinition.getTargetLevel();
        AggregationDefinition aggrDefinition = targetResultSet.getAggregationDefinition();
        if (aggrDefinition == null || aggrDefinition.getAggregationFunctions() == null) {
            int levelIndex = targetResultSet.getLevelIndex(targetLevel);
            int i = 0;
            while (i < base.length()) {
                base.seek(i);
                Object key = base.getLevelKeyValue(levelIndex)[0];
                int j = 0;
                while (j < sortIndex.length) {
                    keyDiskArrays[sortIndex[j]].add(key);
                    ++j;
                }
                ++i;
            }
            return;
        }
        DimLevel[] axisQualifierLevel = sortDefinition.getAxisQualifierLevel();
        int[] levelIndex = new int[axisQualifierLevel.length];
        int i = 0;
        while (i < levelIndex.length) {
            levelIndex[i] = targetResultSet.getLevelIndex(axisQualifierLevel[i]);
            ++i;
        }
        Object[] axisQualifierValue = sortDefinition.getAxisQualifierValue();
        int[] aggrIndex = new int[sortIndex.length];
        int i2 = 0;
        while (i2 < sortIndex.length) {
            AggrSortDefinition sortDefn = (AggrSortDefinition)targetSorts[sortIndex[i2]];
            aggrIndex[i2] = targetResultSet.getAggregationIndex(sortDefn.getAggrName());
            ++i2;
        }
        int indexInBase = base.getLevelIndex(targetLevel);
        CompareIndex compareIndex = AggregationSortHelper.getCompareIndex(base, targetResultSet, indexInBase);
        int baseRowIndex = 0;
        int i3 = 0;
        while (i3 < targetResultSet.length()) {
            targetResultSet.seek(i3);
            Object[] values = new Object[levelIndex.length];
            int j = 0;
            while (j < levelIndex.length) {
                values[j] = targetResultSet.getLevelKeyValue(levelIndex[j])[0];
                ++j;
            }
            if (CompareUtil.compare(values, axisQualifierValue) == 0) {
                IAggregationResultRow targetRow = targetResultSet.getCurrentRow();
                boolean found = false;
                while (baseRowIndex < base.length()) {
                    base.seek(baseRowIndex);
                    IAggregationResultRow baseRow = base.getCurrentRow();
                    if (AggregationSortHelper.shareLevelKey(baseRow, targetRow, compareIndex)) {
                        int j2 = 0;
                        while (j2 < sortIndex.length) {
                            keyDiskArrays[sortIndex[j2]].add(targetRow.getAggregationValues()[aggrIndex[j2]]);
                            ++j2;
                        }
                        ++baseRowIndex;
                        found = true;
                        continue;
                    }
                    if (found) break;
                    AggregationSortHelper.fillNullValues(sortIndex, keyDiskArrays);
                    ++baseRowIndex;
                }
            }
            ++i3;
        }
        while (baseRowIndex < base.length()) {
            AggregationSortHelper.fillNullValues(sortIndex, keyDiskArrays);
            ++baseRowIndex;
        }
    }

    private static CompareIndex getCompareIndex(IAggregationResultSet base, IAggregationResultSet targetResultSet, int indexInBase) {
        DimLevel[] baseLevels = base.getAllLevels();
        DimLevel[] targetAllLevels = targetResultSet.getAllLevels();
        ArrayList<Integer> baseMemberIndex = new ArrayList<Integer>();
        ArrayList<Integer> targetMemberIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < targetAllLevels.length) {
            int j = 0;
            while (j <= indexInBase) {
                if (baseLevels[j].equals(targetAllLevels[i])) {
                    baseMemberIndex.add(new Integer(j));
                    targetMemberIndex.add(new Integer(i));
                    break;
                }
                ++j;
            }
            ++i;
        }
        CompareIndex compareIndex = new CompareIndex();
        compareIndex.memberIndex1 = AggregationSortHelper.toIntArray(baseMemberIndex);
        compareIndex.memberIndex2 = AggregationSortHelper.toIntArray(targetMemberIndex);
        return compareIndex;
    }

    private static boolean shareLevelKey(IAggregationResultRow currentRow, IAggregationResultRow targetRow, CompareIndex compareIndex) {
        int[] index1 = compareIndex.memberIndex1;
        int[] index2 = compareIndex.memberIndex2;
        int i = 0;
        while (i < index1.length) {
            int ret = currentRow.getLevelMembers()[index1[i]].compareTo(targetRow.getLevelMembers()[index2[i]]);
            if (ret != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void fillNullValues(int[] sortIndex, IDiskArray[] keyDiskArrays) throws IOException {
        int j = 0;
        while (j < sortIndex.length) {
            keyDiskArrays[sortIndex[j]].add(null);
            ++j;
        }
    }

    private static int[] toIntArray(List list) {
        int[] index = new int[list.size()];
        int i = 0;
        while (i < index.length) {
            index[i] = (Integer)list.get(i);
            ++i;
        }
        return index;
    }

    private static void populateExprKeyDiskArray(IAggregationResultSet base, ITargetSort[] targetSorts, int[] sortHelperIndex, IDiskArray[] keyDiskArrays) throws IOException, DataException {
        AggregationRowAccessor rowAccessor = new AggregationRowAccessor(base);
        int i = 0;
        while (i < base.length()) {
            base.seek(i);
            int j = 0;
            while (j < sortHelperIndex.length) {
                int index = sortHelperIndex[j];
                IJSSortHelper sortHelper = (IJSSortHelper)targetSorts[index];
                Object keyValue = sortHelper.evaluate(rowAccessor);
                keyDiskArrays[index].add(keyValue);
                ++j;
            }
            ++i;
        }
    }
}

