/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.util.BaseDiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.SetUtil;

public class DimensionFilterHelper {
    public static IDiskArray find(Level[] levels, ISelection[][] filters) throws IOException, DataException {
        ArrayList<BaseDiskSortedStack> filterResults = new ArrayList<BaseDiskSortedStack>();
        int i = 0;
        while (i < levels.length) {
            filterResults.add(DimensionFilterHelper.find(levels[i], filters[i]));
            ++i;
        }
        PrimitiveDiskSortedStack[] stackResults = new PrimitiveDiskSortedStack[filterResults.size()];
        System.arraycopy(filterResults.toArray(), 0, stackResults, 0, stackResults.length);
        IDiskArray AndFilterResults = SetUtil.getIntersection(stackResults);
        return AndFilterResults;
    }

    private static BaseDiskSortedStack find(Level level, ISelection[] filter) throws IOException, DataException {
        IDiskArray indexKeyArray = level.getDiskIndex().find(filter);
        if (indexKeyArray != null) {
            PrimitiveDiskSortedStack resultStack = new PrimitiveDiskSortedStack(Math.min(indexKeyArray.size(), 6000), true, true);
            int i = 0;
            while (i < indexKeyArray.size()) {
                IndexKey key = (IndexKey)indexKeyArray.get(i);
                resultStack.push(new Integer(key.getDimensionPos()));
                ++i;
            }
            return resultStack;
        }
        return new PrimitiveDiskSortedStack(1, true, true);
    }
}

