/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.olap.data.document.AbstractBufferedRandomAccessObject;

public class BufferedRandomAccessFile
extends AbstractBufferedRandomAccessObject {
    private RandomAccessFile delegate;
    private byte[] memoryDelegate;
    private int pointer;
    private int length;
    private File file;
    private String mode;

    public BufferedRandomAccessFile(final File file, String mode, int bufferSize, int cacheSize) throws IOException {
        super(bufferSize);
        this.file = file;
        this.mode = mode;
        Boolean piTmp0 = null;
        piTmp0 = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(file.exists());
            }
        });
        if (piTmp0.booleanValue() || cacheSize <= 0) {
            this.createRandomAccessFile();
        } else {
            this.memoryDelegate = new byte[cacheSize];
        }
        this.fillBuffer();
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws IOException {
        this(file, mode, bufferSize, 0);
    }

    private void createRandomAccessFile() throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File parent = BufferedRandomAccessFile.this.file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    BufferedRandomAccessFile.this.delegate = new RandomAccessFile(BufferedRandomAccessFile.this.file, BufferedRandomAccessFile.this.mode);
                    if (BufferedRandomAccessFile.this.memoryDelegate != null || BufferedRandomAccessFile.this.length > 0) {
                        BufferedRandomAccessFile.this.delegate.write(BufferedRandomAccessFile.this.memoryDelegate, 0, BufferedRandomAccessFile.this.length);
                        BufferedRandomAccessFile.this.delegate.seek(BufferedRandomAccessFile.this.pointer);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    protected void delegateClose() throws IOException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.close();
    }

    protected long delegateGetFilePointer() throws IOException {
        if (this.delegate == null) {
            return this.pointer;
        }
        return this.delegate.getFilePointer();
    }

    protected long delegateLength() throws IOException {
        if (this.delegate == null) {
            return this.length;
        }
        return this.delegate.length();
    }

    protected int delegateRead(byte[] b, int pos, int len) throws IOException {
        if (this.delegate == null) {
            int size = Math.min(this.length - this.pointer, len);
            if (size <= 0) {
                return -1;
            }
            System.arraycopy(this.memoryDelegate, this.pointer, b, pos, size);
            return size;
        }
        return this.delegate.read(b, pos, len);
    }

    protected int delegateRead(byte[] b) throws IOException {
        return this.delegateRead(b, 0, b.length);
    }

    protected void delegateSeek(long pos) throws IOException {
        if (this.delegate == null) {
            if (pos > (long)this.memoryDelegate.length) {
                this.createRandomAccessFile();
            } else {
                this.pointer = (int)pos;
                return;
            }
        }
        this.delegate.seek(pos);
    }

    protected void delegateSetLength(long newLength) throws IOException {
        if (this.delegate == null) {
            if (newLength > (long)this.memoryDelegate.length) {
                this.createRandomAccessFile();
            } else {
                this.length = (int)newLength;
            }
            return;
        }
        this.delegate.setLength(newLength);
    }

    protected void delegateWrite(byte[] b, int pos, int len) throws IOException {
        if (this.delegate == null) {
            if (this.pointer + len > this.memoryDelegate.length) {
                this.createRandomAccessFile();
            } else {
                System.arraycopy(b, pos, this.memoryDelegate, this.pointer, len);
                if (this.pointer + len > this.length) {
                    this.length = this.pointer + len;
                }
                this.pointer += len;
                return;
            }
        }
        this.delegate.write(b, pos, len);
    }
}

