/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.driver;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import javax.olap.OLAPException;
import javax.olap.cursor.RowDataMetaData;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.cursor.RowDataMetaDataImpl;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.driver.EdgeAxis;
import org.eclipse.birt.data.engine.olap.driver.IResultSetMetaData;
import org.eclipse.birt.data.engine.olap.driver.ResultSetMetadata;

public class DimensionAxis {
    private IResultSetMetaData metaData;
    private IAggregationResultSet rs;
    private int dimAxisIndex;
    private int levelIndex;
    private IRowDataAccessor accessor;
    private boolean isMirrored = false;
    private int aggrSortType = -1;
    private Vector valueObjects = null;

    public DimensionAxis(EdgeAxis container, IAggregationResultSet rs, int dimAxisIndex, int levelIndex) {
        this(container, rs, dimAxisIndex, levelIndex, false, null);
    }

    public DimensionAxis(EdgeAxis container, IAggregationResultSet rs, int dimAixsIndex, int levelIndex, boolean isMirrored, AggrSortDefinition aggrSortDefinition) {
        this.metaData = new ResultSetMetadata(rs, levelIndex);
        this.rs = rs;
        this.levelIndex = levelIndex;
        this.accessor = container.getRowDataAccessor();
        this.dimAxisIndex = dimAixsIndex;
        this.isMirrored = isMirrored;
        if (this.isMirrored) {
            this.valueObjects = this.populateValueVector(aggrSortDefinition);
        }
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }

    private Vector populateValueVector(AggrSortDefinition aggrSortDefinition) {
        HashSet<Object> valueSet = new HashSet<Object>();
        if (aggrSortDefinition != null) {
            this.aggrSortType = aggrSortDefinition.getSortDirection();
        }
        int i = 0;
        while (i < this.rs.length()) {
            try {
                this.rs.seek(i);
            }
            catch (IOException iOException) {}
            valueSet.add(this.rs.getLevelKeyValue(this.levelIndex)[this.rs.getLevelKeyColCount(this.levelIndex) - 1]);
            ++i;
        }
        final int sortType = this.rs.getSortType(this.levelIndex);
        Object[] value = valueSet.toArray();
        Arrays.sort(value, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (sortType == 0 || sortType == -1) {
                    return ((Comparable)arg0).compareTo(arg1);
                }
                return ((Comparable)arg0).compareTo(arg1) * -1;
            }
        });
        Vector v = new Vector();
        v.addAll(Arrays.asList(value));
        return v;
    }

    public Vector getDisctinctValue() {
        return this.valueObjects;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public int getDimensionAxisIndex() {
        return this.dimAxisIndex;
    }

    public IRowDataAccessor getRowDataAccessor() {
        return this.accessor;
    }

    public IAggregationResultSet getAssociationQueryResultSet() {
        return this.rs;
    }

    public RowDataMetaData getRowDataMetaData() {
        return new RowDataMetaDataImpl(this.metaData);
    }

    public boolean next() throws OLAPException {
        return this.accessor.dim_next(this.dimAxisIndex);
    }

    public boolean previous() throws OLAPException {
        return this.accessor.dim_previous(this.dimAxisIndex);
    }

    public boolean relative(int arg0) throws OLAPException {
        return this.accessor.dim_relative(arg0, this.dimAxisIndex);
    }

    public boolean first() throws OLAPException {
        return this.accessor.dim_first(this.dimAxisIndex);
    }

    public boolean last() throws OLAPException {
        return this.accessor.dim_last(this.dimAxisIndex);
    }

    public boolean isBeforeFirst() {
        return this.accessor.dim_isBeforeFirst(this.dimAxisIndex);
    }

    public boolean isAfterLast() throws OLAPException {
        return this.accessor.dim_isAfterLast(this.dimAxisIndex);
    }

    public boolean isFirst() throws OLAPException {
        return this.accessor.dim_isFirst(this.dimAxisIndex);
    }

    public boolean isLast() throws OLAPException {
        return this.accessor.dim_isLast(this.dimAxisIndex);
    }

    public void afterLast() throws OLAPException {
        this.accessor.dim_afterLast(this.dimAxisIndex);
    }

    public void beforeFirst() throws OLAPException {
        this.accessor.dim_beforeFirst(this.dimAxisIndex);
    }

    public void setPosition(long position) throws OLAPException {
        this.accessor.dim_setPosition(this.dimAxisIndex, position);
    }

    public long getPosition() throws OLAPException {
        return this.accessor.dim_getPosition(this.dimAxisIndex);
    }

    public void close() throws OLAPException {
        try {
            this.rs.close();
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public long getExtend() {
        return 0L;
    }

    public int getType() {
        return 0;
    }

    public long getEdgeEnd() throws OLAPException {
        return this.accessor.getEdgeEnd(this.dimAxisIndex);
    }

    public long getEdgeStart() throws OLAPException {
        return this.accessor.getEdgeStart(this.dimAxisIndex);
    }

    public Object getCurrentMember(int attr) throws OLAPException {
        return this.accessor.dim_getCurrentMember(this.dimAxisIndex, attr, this.aggrSortType);
    }

    public Object getCurrentMember(String attrName) throws OLAPException {
        return this.accessor.dim_getCurrentMember(this.dimAxisIndex, attrName, this.aggrSortType);
    }

    public void setEdgeInfo(IRowDataAccessor accessor) {
        this.accessor = accessor;
    }
}

