/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.IPreparedCubeOperation;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.ICubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedAddingNestAggregations
implements IPreparedCubeOperation {
    private AddingNestAggregations cubeOperation;
    private Scriptable scope;
    private CalculatedMember[] newMembers;

    public PreparedAddingNestAggregations(AddingNestAggregations cubeOperation, Scriptable scope, int startRsId, ScriptContext cx) throws DataException {
        assert (cubeOperation != null);
        this.cubeOperation = cubeOperation;
        this.scope = scope;
        ICubeAggrDefn[] aggrDefns = OlapExpressionUtil.getAggrDefnsByNestBinding(Arrays.asList(cubeOperation.getNewBindings()));
        this.newMembers = CubeQueryDefinitionUtil.createCalculatedMembersByAggrOnListAndMeasureName(startRsId, aggrDefns, this.scope, cx);
    }

    @Override
    public IAggregationResultSet[] execute(ICubeQueryDefinition cubeQueryDefn, IAggregationResultSet[] sources, StopSign stopSign) throws IOException, BirtException {
        AggregationDefinition[] definitions = CubeQueryDefinitionUtil.createAggregationDefinitons(this.newMembers, cubeQueryDefn);
        ArrayList<IAggregationResultSet> currentSources = new ArrayList<IAggregationResultSet>((Collection)Arrays.asList(sources));
        AggregationDefinition[] aggregationDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationDefinition definiton = aggregationDefinitionArray[n2];
            IAggregationResultSet dataSource = this.findDataSource(currentSources, definiton);
            IAggregationResultSet result = CubeQueryExecutorHelper.computeNestAggregation(dataSource, definiton, stopSign);
            currentSources.add(result);
            ++n2;
        }
        return currentSources.toArray(new IAggregationResultSet[0]);
    }

    @Override
    public ICubeOperation getCubeOperation() {
        return this.cubeOperation;
    }

    @Override
    public CalculatedMember[] getNewCalculatedMembers() {
        return this.newMembers;
    }

    private IAggregationResultSet findDataSource(List<IAggregationResultSet> sources, AggregationDefinition definition) throws DataException {
        String baseAggrName = definition.getAggregationFunctions()[0].getMeasureName();
        if (baseAggrName == null) {
            throw new DataException("data.olap.NotNestAggregationBinding", PreparedAddingNestAggregations.getAllBindingNames(definition));
        }
        for (IAggregationResultSet resultSet : sources) {
            int i = 0;
            while (i < resultSet.getAggregationCount()) {
                String aggrName = resultSet.getAggregationName(i);
                if (baseAggrName.equals(aggrName)) {
                    return resultSet;
                }
                ++i;
            }
        }
        throw new DataException("data.olap.NotNestAggregationBinding", PreparedAddingNestAggregations.getAllBindingNames(definition));
    }

    private static String getAllBindingNames(AggregationDefinition definition) {
        StringBuffer allBindingNames = new StringBuffer("");
        AggregationFunctionDefinition[] aggregationFunctionDefinitionArray = definition.getAggregationFunctions();
        int n = aggregationFunctionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AggregationFunctionDefinition function = aggregationFunctionDefinitionArray[n2];
            allBindingNames.append("[").append(function.getName()).append("]");
            ++n2;
        }
        return allBindingNames.toString();
    }
}

