/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryResults;
import org.eclipse.birt.data.engine.olap.util.OlapQueryUtil;
import org.mozilla.javascript.Scriptable;

public class PreparedCubeQuery
implements IPreparedCubeQuery {
    private ICubeQueryDefinition cubeQueryDefn;
    private DataEngineSession session;
    private DataEngineContext context;
    private Map appContext;

    public PreparedCubeQuery(ICubeQueryDefinition defn, DataEngineSession session, DataEngineContext context, Map appContext) throws DataException {
        this.cubeQueryDefn = defn;
        this.session = session;
        this.context = context;
        this.appContext = appContext;
        this.validateQuery();
    }

    public ICubeQueryResults execute(Scriptable scope) throws DataException {
        return this.execute(null, scope);
    }

    public ICubeQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        Scriptable cubeScope = this.session.getEngineContext().getScriptContext().getContext().newObject(scope == null ? this.session.getSharedScope() : scope);
        cubeScope.setParentScope(scope == null ? this.session.getSharedScope() : scope);
        cubeScope.setPrototype(scope == null ? this.session.getSharedScope() : scope);
        return new CubeQueryResults(outerResults, this, this.session, cubeScope, this.context, this.appContext);
    }

    public IBaseCubeQueryDefinition getCubeQueryDefinition() {
        return this.cubeQueryDefn;
    }

    private void validateQuery() throws DataException {
        this.validateBinding();
    }

    private void validateBinding() throws DataException {
        OlapQueryUtil.validateBinding(this.cubeQueryDefn, false);
    }
}

