/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.cursor.CubeCursorImpl;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationFactory;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.IPreparedCubeOperation;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.MeasureNameManager;
import org.eclipse.birt.data.engine.olap.query.view.QueryExecutor;
import org.mozilla.javascript.Scriptable;

public class BirtCubeView {
    private BirtEdgeView columnEdgeView;
    private BirtEdgeView rowEdgeView;
    private BirtEdgeView pageEdgeView;
    private MeasureNameManager manager;
    private CubeQueryExecutor executor;
    private Map appContext;
    private Map measureMapping;
    private QueryExecutor queryExecutor;
    private IResultSet parentResultSet;
    private IPreparedCubeOperation[] preparedCubeOperations;

    private BirtCubeView() {
    }

    public BirtCubeView(CubeQueryExecutor queryExecutor, Map appContext) throws DataException {
        this.executor = queryExecutor;
        this.pageEdgeView = this.createBirtEdgeView(this.getCubeQueryDefinition().getEdge(3), 3);
        this.columnEdgeView = this.createBirtEdgeView(this.getCubeQueryDefinition().getEdge(2), 2);
        this.rowEdgeView = this.createBirtEdgeView(this.getCubeQueryDefinition().getEdge(1), 1);
        this.executor = queryExecutor;
        this.appContext = appContext;
        this.measureMapping = new HashMap();
        CalculatedMember[] members = CubeQueryDefinitionUtil.getCalculatedMembers(this.getCubeQueryDefinition(), queryExecutor.getSession().getSharedScope(), this.measureMapping, queryExecutor.getSession().getEngineContext().getScriptContext());
        this.manager = new MeasureNameManager(members);
        this.prepareCubeOperations(this.manager.getBasedRsIndex() + 1);
    }

    private void prepareCubeOperations(int startRsId) throws DataException {
        Scriptable scope = this.executor.getSession().getSharedScope();
        this.preparedCubeOperations = new IPreparedCubeOperation[this.getCubeQueryDefinition().getCubeOperations().length];
        int i = 0;
        int startId = startRsId;
        ICubeOperation[] iCubeOperationArray = this.getCubeQueryDefinition().getCubeOperations();
        int n = iCubeOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreparedCubeOperation pco;
            ICubeOperation co = iCubeOperationArray[n2];
            this.preparedCubeOperations[i] = pco = CubeOperationFactory.createPreparedCubeOperation(co, scope, startId, this.executor.getSession().getEngineContext().getScriptContext());
            CalculatedMember[] newMembers = pco.getNewCalculatedMembers();
            if (newMembers != null && newMembers.length > 0) {
                startId = newMembers[newMembers.length - 1].getRsID() + 1;
            }
            this.manager.addCalculatedMembersFromCubeOperation(newMembers);
            ++i;
            ++n2;
        }
    }

    public BirtCubeView createSubView() throws DataException {
        BirtCubeView subView = new BirtCubeView();
        subView.executor = this.executor;
        subView.pageEdgeView = this.createBirtEdgeView(subView.getCubeQueryDefinition().getEdge(3), 3);
        subView.columnEdgeView = this.createBirtEdgeView(subView.getCubeQueryDefinition().getEdge(2), 2);
        subView.rowEdgeView = this.createBirtEdgeView(subView.getCubeQueryDefinition().getEdge(1), 1);
        subView.measureMapping = this.measureMapping;
        subView.preparedCubeOperations = this.preparedCubeOperations;
        subView.manager = this.manager;
        return subView;
    }

    public MeasureNameManager getMeasureNameManger() {
        return this.manager;
    }

    public BirtCubeView(CubeQueryExecutor queryExecutor) throws DataException {
        this(queryExecutor, null);
    }

    public CubeCursor getCubeCursor(StopSign stopSign) throws OLAPException, DataException {
        Map relationMap = CubeQueryDefinitionUtil.getRelationWithMeasure(this.getCubeQueryDefinition(), this.measureMapping);
        this.queryExecutor = new QueryExecutor();
        try {
            this.parentResultSet = this.queryExecutor.execute(this, stopSign);
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage(), e);
        }
        catch (BirtException e) {
            throw new OLAPException(e.getLocalizedMessage(), e);
        }
        CubeCursorImpl cubeCursor = this.appContext != null && this.executor.getContext().getMode() == 3 ? new CubeCursorImpl(this, this.parentResultSet, relationMap, this.appContext) : new CubeCursorImpl(this, this.parentResultSet, relationMap);
        return cubeCursor;
    }

    public CubeCursor getCubeCursor(StopSign stopSign, String startingColumnLevel, String startingRowLevel, BirtCubeView parentView) throws OLAPException, DataException {
        if (parentView == null || parentView.getCubeQueryExecutor() == null) {
            throw new DataException("data.olap.missingParentCursor");
        }
        Map relationMap = CubeQueryDefinitionUtil.getRelationWithMeasure(this.getCubeQueryDefinition(), this.measureMapping);
        int startingColumnLevelIndex = -1;
        int startingRowLevelIndex = -1;
        if (startingColumnLevel != null) {
            startingColumnLevelIndex = CubeQueryDefinitionUtil.getLevelIndex(this.getCubeQueryDefinition(), startingColumnLevel, 2);
        }
        if (startingRowLevel != null) {
            startingRowLevelIndex = CubeQueryDefinitionUtil.getLevelIndex(this.getCubeQueryDefinition(), startingRowLevel, 1);
        }
        if (startingColumnLevelIndex == -1 && startingRowLevelIndex == -1) {
            startingColumnLevelIndex = CubeQueryDefinitionUtil.getLevelsOnEdge(this.getCubeQueryDefinition().getEdge(2)).length - 1;
            startingRowLevelIndex = CubeQueryDefinitionUtil.getLevelsOnEdge(this.getCubeQueryDefinition().getEdge(1)).length - 1;
        }
        this.queryExecutor = parentView.getQueryExecutor();
        try {
            this.parentResultSet = this.queryExecutor.executeSubQuery(parentView.getResultSet(), this, startingColumnLevelIndex, startingRowLevelIndex);
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        CubeCursorImpl cubeCursor = new CubeCursorImpl(this, this.parentResultSet, relationMap);
        return cubeCursor;
    }

    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public CubeQueryExecutor getCubeQueryExecutor() {
        return this.executor;
    }

    public IResultSet getResultSet() {
        return this.parentResultSet;
    }

    public BirtEdgeView getRowEdgeView() {
        return this.rowEdgeView;
    }

    public BirtEdgeView getColumnEdgeView() {
        return this.columnEdgeView;
    }

    public BirtEdgeView getPageEdgeView() {
        return this.pageEdgeView;
    }

    public BirtEdgeView[] getMeasureEdgeView() {
        BirtEdgeView[] calculatedMemberViews = null;
        CalculatedMember[] members = this.manager.getCalculatedMembers();
        if (members != null && members.length > 0) {
            HashSet<Integer> rsIDSet = new HashSet<Integer>();
            calculatedMemberViews = new BirtEdgeView[members.length];
            int index = 0;
            int i = 0;
            while (i < members.length) {
                if (!rsIDSet.contains(new Integer(members[i].getRsID()))) {
                    calculatedMemberViews[index] = this.createBirtEdgeView(members[i]);
                    rsIDSet.add(new Integer(members[i].getRsID()));
                    ++index;
                }
                ++i;
            }
        }
        return calculatedMemberViews;
    }

    public Map getMeasureMapping() {
        return this.measureMapping;
    }

    private BirtEdgeView createBirtEdgeView(IEdgeDefinition edgeDefn, int type) {
        if (edgeDefn == null) {
            return null;
        }
        return new BirtEdgeView(this, edgeDefn, type);
    }

    private BirtEdgeView createBirtEdgeView(CalculatedMember calculatedMember) {
        return new BirtEdgeView(calculatedMember);
    }

    public ICubeQueryDefinition getCubeQueryDefinition() {
        return this.executor.getCubeQueryDefinition();
    }

    protected IPreparedCubeOperation[] getPreparedCubeOperations() {
        return this.preparedCubeOperations;
    }
}

