/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.LevelDefiniton;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;
import org.eclipse.birt.data.engine.olap.util.ICubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.JSMeasureFilterEvalHelper;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeQueryDefinitionUtil {
    static CalculatedMember[] getCalculatedMembers(ICubeQueryDefinition queryDefn, Scriptable scope, Map measureMapping, ScriptContext cx) throws DataException {
        List measureList = queryDefn.getMeasures();
        ICubeAggrDefn[] cubeAggrs = OlapExpressionUtil.getAggrDefns(queryDefn.getBindings());
        CubeQueryDefinitionUtil.populateMeasureFromBinding(queryDefn, cx);
        CubeQueryDefinitionUtil.populateMeasureFromFilter(queryDefn, cx);
        CubeQueryDefinitionUtil.populateMeasureFromSort(queryDefn, cx);
        if (measureList == null) {
            return new CalculatedMember[0];
        }
        List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
        List unreferencedMeasures = CubeQueryDefinitionUtil.getUnreferencedMeasures(queryDefn, measureList, measureMapping, measureAggrOns);
        CalculatedMember[] calculatedMembers1 = new CalculatedMember[unreferencedMeasures.size()];
        int index = 0;
        for (MeasureDefinition measureDefn : unreferencedMeasures) {
            String innerName = OlapExpressionUtil.createMeasureCalculateMemeberName(measureDefn.getName());
            measureMapping.put(measureDefn.getName(), innerName);
            calculatedMembers1[index] = new CalculatedMember(innerName, measureDefn.getName(), measureAggrOns, CubeQueryDefinitionUtil.adaptAggrFunction(measureDefn), 0);
            ++index;
        }
        int startRsId = calculatedMembers1.length == 0 ? 0 : 1;
        CalculatedMember[] calculatedMembers2 = CubeQueryDefinitionUtil.createCalculatedMembersByAggrOnList(startRsId, cubeAggrs, scope, cx);
        return CubeQueryDefinitionUtil.uniteCalculatedMember(calculatedMembers1, calculatedMembers2);
    }

    public static CalculatedMember[] createCalculatedMembersByAggrOnList(int startRsId, ICubeAggrDefn[] cubeAggrs, Scriptable scope, ScriptContext cx) throws DataException {
        if (cubeAggrs == null) {
            return new CalculatedMember[0];
        }
        assert (startRsId >= 0);
        int preparedRsId = startRsId;
        CalculatedMember[] result = new CalculatedMember[cubeAggrs.length];
        ArrayList<CalculatedMember> withDistinctRsIds = new ArrayList<CalculatedMember>();
        int index = 0;
        ICubeAggrDefn[] iCubeAggrDefnArray = cubeAggrs;
        int n = cubeAggrs.length;
        int n2 = 0;
        while (n2 < n) {
            ICubeAggrDefn cubeAggrDefn = iCubeAggrDefnArray[n2];
            int id = CubeQueryDefinitionUtil.getResultSetIndex(withDistinctRsIds, cubeAggrDefn.getAggrLevels());
            if (id == -1) {
                result[index] = new CalculatedMember(cubeAggrDefn, preparedRsId);
                withDistinctRsIds.add(result[index]);
                ++preparedRsId;
            } else {
                result[index] = new CalculatedMember(cubeAggrDefn, id);
            }
            if (cubeAggrDefn.getFilter() != null) {
                JSMeasureFilterEvalHelper filterEvalHelper = new JSMeasureFilterEvalHelper(scope, cx, new FilterDefinition(cubeAggrDefn.getFilter()));
                result[index].setFilterEvalHelper(filterEvalHelper);
            }
            ++index;
            ++n2;
        }
        return result;
    }

    public static CalculatedMember[] createCalculatedMembersByAggrOnListAndMeasureName(int startRsId, ICubeAggrDefn[] cubeAggrs, Scriptable scope, ScriptContext cx) throws DataException {
        if (cubeAggrs == null) {
            return new CalculatedMember[0];
        }
        assert (startRsId >= 0);
        int preparedRsId = startRsId;
        CalculatedMember[] result = new CalculatedMember[cubeAggrs.length];
        ArrayList<CalculatedMember> withDistinctRsIds = new ArrayList<CalculatedMember>();
        int index = 0;
        ICubeAggrDefn[] iCubeAggrDefnArray = cubeAggrs;
        int n = cubeAggrs.length;
        int n2 = 0;
        while (n2 < n) {
            ICubeAggrDefn cubeAggrDefn = iCubeAggrDefnArray[n2];
            int id = CubeQueryDefinitionUtil.getResultSetIndex(withDistinctRsIds, cubeAggrDefn.getAggrLevels(), cubeAggrDefn.getMeasure());
            if (id == -1) {
                result[index] = new CalculatedMember(cubeAggrDefn, preparedRsId);
                withDistinctRsIds.add(result[index]);
                ++preparedRsId;
            } else {
                result[index] = new CalculatedMember(cubeAggrDefn, id);
            }
            if (cubeAggrDefn.getFilter() != null) {
                JSMeasureFilterEvalHelper filterEvalHelper = new JSMeasureFilterEvalHelper(scope, cx, new FilterDefinition(cubeAggrDefn.getFilter()));
                result[index].setFilterEvalHelper(filterEvalHelper);
            }
            ++index;
            ++n2;
        }
        return result;
    }

    public static CalculatedMember[] uniteCalculatedMember(CalculatedMember[] array1, CalculatedMember[] array2) {
        assert (array1 != null && array2 != null);
        int size = array1.length + array2.length;
        CalculatedMember[] result = new CalculatedMember[size];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static AggregationDefinition[] createAggregationDefinitons(CalculatedMember[] calculatedMembers, ICubeQueryDefinition query) throws DataException {
        if (calculatedMembers == null) {
            return new AggregationDefinition[0];
        }
        ArrayList<AggregationDefinition> result = new ArrayList<AggregationDefinition>();
        HashSet<Integer> rsIDSet = new HashSet<Integer>();
        int i = 0;
        while (i < calculatedMembers.length) {
            if (!rsIDSet.contains(calculatedMembers[i].getRsID())) {
                List<CalculatedMember> list = CubeQueryDefinitionUtil.getCalculatedMemberWithSameRSId(calculatedMembers, i);
                AggregationFunctionDefinition[] funcitons = new AggregationFunctionDefinition[list.size()];
                int index = 0;
                while (index < list.size()) {
                    String[] dimInfo = list.get(index).getFirstArgumentInfo();
                    String dimName = null;
                    String levelName = null;
                    String attributeName = null;
                    DimLevel dimLevel = null;
                    if (dimInfo != null && dimInfo.length == 3) {
                        dimName = list.get(index).getFirstArgumentInfo()[0];
                        levelName = list.get(index).getFirstArgumentInfo()[1];
                        attributeName = list.get(index).getFirstArgumentInfo()[2];
                        dimLevel = new DimLevel(dimName, levelName);
                    }
                    funcitons[index] = new AggregationFunctionDefinition(list.get(index).getName(), list.get(index).getMeasureName(), dimLevel, attributeName, list.get(index).getAggrFunction(), list.get(index).getFilterEvalHelper());
                    ++index;
                }
                DimLevel[] levels = new DimLevel[calculatedMembers[i].getAggrOnList().size()];
                int[] sortType = new int[calculatedMembers[i].getAggrOnList().size()];
                int index2 = 0;
                while (index2 < calculatedMembers[i].getAggrOnList().size()) {
                    Object obj = calculatedMembers[i].getAggrOnList().get(index2);
                    levels[index2] = (DimLevel)obj;
                    sortType[index2] = CubeQueryDefinitionUtil.getSortDirection(levels[index2], query);
                    ++index2;
                }
                rsIDSet.add(calculatedMembers[i].getRsID());
                result.add(new AggregationDefinition(levels, sortType, funcitons));
            }
            ++i;
        }
        return result.toArray(new AggregationDefinition[0]);
    }

    public static int getSortDirection(DimLevel level, ICubeQueryDefinition query) throws DataException {
        if (query.getSorts() != null && !query.getSorts().isEmpty()) {
            int i = 0;
            while (i < query.getSorts().size()) {
                ISortDefinition sortDfn = (ISortDefinition)query.getSorts().get(i);
                String expr = sortDfn.getExpression().getText();
                DimLevel info = CubeQueryDefinitionUtil.getDimLevel(expr, query.getBindings());
                if (level.equals(info)) {
                    return sortDfn.getSortDirection();
                }
                ++i;
            }
        }
        return -1;
    }

    private static DimLevel getDimLevel(String expr, List bindings) throws DataException {
        String bindingName = OlapExpressionUtil.getBindingName(expr);
        if (bindingName != null) {
            int j = 0;
            while (j < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(j);
                if (binding.getBindingName().equals(bindingName)) {
                    if (!(binding.getExpression() instanceof IScriptExpression)) {
                        return null;
                    }
                    return CubeQueryDefinitionUtil.getDimLevel(((IScriptExpression)binding.getExpression()).getText(), bindings);
                }
                ++j;
            }
        }
        if (!OlapExpressionUtil.isReferenceToDimLevel(expr)) {
            return null;
        }
        return OlapExpressionUtil.getTargetDimLevel(expr);
    }

    private static List<CalculatedMember> getCalculatedMemberWithSameRSId(CalculatedMember[] calMember, int index) {
        CalculatedMember member = calMember[index];
        ArrayList<CalculatedMember> list = new ArrayList<CalculatedMember>();
        list.add(member);
        int i = index + 1;
        while (i < calMember.length) {
            if (calMember[i].getRsID() == member.getRsID()) {
                list.add(calMember[i]);
            }
            ++i;
        }
        return list;
    }

    static int getLevelIndex(ICubeQueryDefinition queryDefn, String levelExpr, int type) throws DataException {
        int index = -1;
        DimLevel dimLevel = OlapExpressionUtil.getTargetDimLevel(levelExpr);
        IEdgeDefinition edgeDefn = queryDefn.getEdge(type);
        for (IDimensionDefinition dimDefn : edgeDefn.getDimensions()) {
            for (IHierarchyDefinition hierarchyDefn : dimDefn.getHierarchy()) {
                int i = 0;
                while (i < hierarchyDefn.getLevels().size()) {
                    ++index;
                    ILevelDefinition levelDefn = (ILevelDefinition)hierarchyDefn.getLevels().get(i);
                    if (dimDefn.getName().equals(dimLevel.getDimensionName()) && levelDefn.getName().equals(dimLevel.getLevelName())) {
                        return index;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    private static String adaptAggrFunction(MeasureDefinition measureDefn) {
        return measureDefn.getAggrFunction() == null ? "SUM" : measureDefn.getAggrFunction();
    }

    private static List getUnreferencedMeasures(ICubeQueryDefinition queryDefn, List measureList, Map measureMapping, List measureAggrOns) throws DataException {
        ArrayList<MeasureDefinition> result = new ArrayList<MeasureDefinition>();
        List bindings = queryDefn.getBindings();
        for (MeasureDefinition measure : measureList) {
            IBinding referenceBinding = CubeQueryDefinitionUtil.getMeasureDirectReferenceBinding(measure, bindings, measureAggrOns);
            if (referenceBinding != null) {
                measureMapping.put(measure.getName(), referenceBinding.getBindingName());
                continue;
            }
            result.add(measure);
        }
        return result;
    }

    private static IBinding getMeasureDirectReferenceBinding(MeasureDefinition measure, List bindings, List measureAggrOns) throws DataException {
        for (IBinding binding : bindings) {
            IBaseExpression expression;
            String funcName;
            String aggrFunction;
            if (binding.getAggregatOns().size() != measureAggrOns.size() || !(aggrFunction = CubeQueryDefinitionUtil.adaptAggrFunction(measure)).equals(funcName = binding.getAggrFunction()) || !((expression = binding.getExpression()) instanceof IScriptExpression)) continue;
            IScriptExpression expr = (IScriptExpression)expression;
            String measureName = OlapExpressionUtil.getMeasure(expr.getText());
            if (!measure.getName().equals(measureName)) continue;
            return binding;
        }
        return null;
    }

    private static void populateMeasureFromSort(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getSorts().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((ISortDefinition)queryDefn.getSorts().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static void populateMeasureFromFilter(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getFilters().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((IFilterDefinition)queryDefn.getFilters().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static void populateMeasureFromBinding(ICubeQueryDefinition queryDefn, ScriptContext cx) throws DataException {
        int i = 0;
        while (i < queryDefn.getBindings().size()) {
            CubeQueryDefinitionUtil.createRelationalMeasures(queryDefn, ((IBinding)queryDefn.getBindings().get(i)).getExpression(), cx);
            ++i;
        }
    }

    private static List createRelationalMeasures(ICubeQueryDefinition queryDefn, IBaseExpression expression, ScriptContext cx) throws DataException {
        ArrayList<IMeasureDefinition> measures = new ArrayList<IMeasureDefinition>();
        List exprTextList = CubeQueryDefinitionUtil.getExprTextList(expression);
        int i = 0;
        while (i < exprTextList.size()) {
            String exprText = (String)exprTextList.get(i);
            String measureName = OlapExpressionCompiler.getReferencedScriptObject(exprText, "measure");
            if (measureName != null && measureName.trim().length() > 0) {
                List existMeasures = queryDefn.getMeasures();
                boolean exist = false;
                int j = 0;
                while (j < existMeasures.size()) {
                    if (((IMeasureDefinition)existMeasures.get(j)).getName().equals(measureName)) {
                        exist = true;
                        break;
                    }
                    ++j;
                }
                if (!exist) {
                    measures.add(queryDefn.createMeasure(measureName));
                }
            }
            ++i;
        }
        return measures;
    }

    private static List getExprTextList(IBaseExpression expression) {
        ArrayList<String> textList = new ArrayList<String>();
        if (expression instanceof IScriptExpression) {
            textList.add(((IScriptExpression)expression).getText());
        } else if (expression instanceof IExpressionCollection) {
            List exprList = (List)((IExpressionCollection)expression).getExpressions();
            int i = 0;
            while (i < exprList.size()) {
                IBaseExpression baseExpr = (IBaseExpression)exprList.get(i);
                textList.addAll(CubeQueryDefinitionUtil.getExprTextList(baseExpr));
                ++i;
            }
        } else if (expression instanceof IConditionalExpression) {
            textList.add(((IConditionalExpression)expression).getExpression().getText());
            textList.addAll(CubeQueryDefinitionUtil.getExprTextList(((IConditionalExpression)expression).getOperand1()));
            textList.addAll(CubeQueryDefinitionUtil.getExprTextList(((IConditionalExpression)expression).getOperand2()));
        }
        return textList;
    }

    public static List populateMeasureAggrOns(ICubeQueryDefinition queryDefn) {
        ArrayList<DimLevel> levelList = new ArrayList<DimLevel>();
        ILevelDefinition[] rowLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
        ILevelDefinition[] columnLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
        ILevelDefinition[] pageLevels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(3));
        int i = 0;
        while (i < rowLevels.length) {
            levelList.add(new DimLevel(rowLevels[i]));
            ++i;
        }
        i = 0;
        while (i < columnLevels.length) {
            levelList.add(new DimLevel(columnLevels[i]));
            ++i;
        }
        i = 0;
        while (i < pageLevels.length) {
            levelList.add(new DimLevel(pageLevels[i]));
            ++i;
        }
        return levelList;
    }

    private static int getResultSetIndex(List aggrList, List levelList) {
        int i = 0;
        while (i < aggrList.size()) {
            CalculatedMember member = (CalculatedMember)aggrList.get(i);
            if (member.getAggrOnList().equals(levelList)) {
                return member.getRsID();
            }
            ++i;
        }
        return -1;
    }

    private static int getResultSetIndex(List aggrList, List levelList, String measureName) {
        int i = 0;
        while (i < aggrList.size()) {
            CalculatedMember member = (CalculatedMember)aggrList.get(i);
            if (member.getAggrOnList().equals(levelList) && CubeQueryDefinitionUtil.isSameString(member.getMeasureName(), measureName)) {
                return member.getRsID();
            }
            ++i;
        }
        return -1;
    }

    private static boolean isSameString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    static ILevelDefinition[] getLevelsOnEdge(IEdgeDefinition edgeDefn) {
        if (edgeDefn == null) {
            return new ILevelDefinition[0];
        }
        ArrayList levelList = new ArrayList();
        for (IDimensionDefinition dimDefn : edgeDefn.getDimensions()) {
            for (IHierarchyDefinition hierarchyDefn : dimDefn.getHierarchy()) {
                levelList.addAll(hierarchyDefn.getLevels());
            }
        }
        ILevelDefinition[] levelDefn = new LevelDefiniton[levelList.size()];
        int i = 0;
        while (i < levelList.size()) {
            levelDefn[i] = (ILevelDefinition)levelList.get(i);
            ++i;
        }
        return levelDefn;
    }

    public static Map getRelationWithMeasure(ICubeQueryDefinition queryDefn, Map measureMapping) throws DataException {
        int i;
        ILevelDefinition[] levels;
        HashMap<Object, Relationship> measureRelationMap = new HashMap<Object, Relationship>();
        ArrayList<DimLevel> pageLevelList = new ArrayList<DimLevel>();
        ArrayList<DimLevel> rowLevelList = new ArrayList<DimLevel>();
        ArrayList<DimLevel> columnLevelList = new ArrayList<DimLevel>();
        if (queryDefn.getEdge(3) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(3));
            i = 0;
            while (i < levels.length) {
                pageLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getEdge(2) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(2));
            i = 0;
            while (i < levels.length) {
                columnLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getEdge(1) != null) {
            levels = CubeQueryDefinitionUtil.getLevelsOnEdge(queryDefn.getEdge(1));
            i = 0;
            while (i < levels.length) {
                rowLevelList.add(new DimLevel(levels[i]));
                ++i;
            }
        }
        if (queryDefn.getMeasures() != null && !queryDefn.getMeasures().isEmpty()) {
            for (MeasureDefinition measure : queryDefn.getMeasures()) {
                measureRelationMap.put(measureMapping.get(measure.getName()), new Relationship(rowLevelList, columnLevelList, pageLevelList));
            }
        }
        List orignalBindings = queryDefn.getBindings();
        List<IBinding> newBindings = CubeQueryDefinitionUtil.getNewBindingsFromCubeOperations(queryDefn);
        ICubeAggrDefn[] cubeAggrs1 = OlapExpressionUtil.getAggrDefns(orignalBindings);
        ICubeAggrDefn[] cubeAggrs2 = OlapExpressionUtil.getAggrDefnsByNestBinding(newBindings);
        ICubeAggrDefn[] cubeAggrs = new ICubeAggrDefn[cubeAggrs1.length + cubeAggrs2.length];
        System.arraycopy(cubeAggrs1, 0, cubeAggrs, 0, cubeAggrs1.length);
        System.arraycopy(cubeAggrs2, 0, cubeAggrs, cubeAggrs1.length, cubeAggrs2.length);
        if (cubeAggrs != null && cubeAggrs.length > 0) {
            int i2 = 0;
            while (i2 < cubeAggrs.length) {
                if (cubeAggrs[i2].getAggrName() != null) {
                    List aggrOns = cubeAggrs[i2].getAggrLevels();
                    ArrayList usedLevelOnRow = new ArrayList();
                    ArrayList usedLevelOnColumn = new ArrayList();
                    ArrayList usedLevelOnPage = new ArrayList();
                    int j = 0;
                    while (j < aggrOns.size()) {
                        if (pageLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnPage.add(aggrOns.get(j));
                        }
                        if (rowLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnRow.add(aggrOns.get(j));
                        } else if (columnLevelList.contains(aggrOns.get(j))) {
                            usedLevelOnColumn.add(aggrOns.get(j));
                        }
                        ++j;
                    }
                    measureRelationMap.put(cubeAggrs[i2].getName(), new Relationship(usedLevelOnRow, usedLevelOnColumn, usedLevelOnPage));
                }
                ++i2;
            }
        }
        return measureRelationMap;
    }

    public static List<IBinding> getNewBindingsFromCubeOperations(ICubeQueryDefinition cubeQueryDefn) {
        ArrayList<IBinding> list = new ArrayList<IBinding>();
        ICubeOperation[] iCubeOperationArray = cubeQueryDefn.getCubeOperations();
        int n = iCubeOperationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICubeOperation co = iCubeOperationArray[n2];
            IBinding[] newBindings = co.getNewBindings();
            list.addAll((Collection<IBinding>)Arrays.asList(newBindings));
            ++n2;
        }
        return list;
    }

    public static List<IBinding> getAllBindings(ICubeQueryDefinition cubeQueryDefn) {
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        result.addAll(cubeQueryDefn.getBindings());
        result.addAll(CubeQueryDefinitionUtil.getNewBindingsFromCubeOperations(cubeQueryDefn));
        return result;
    }
}

