/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.List;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.impl.query.ComputedMeasureDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;

class CubeQueryValidator {
    private CubeQueryValidator() {
    }

    static void validateCubeQueryDefinition(ICubeQueryDefinition defn, BirtCubeView view, ICube cube, CalculatedMember[] calculatedMember) throws DataException {
        if (view.getColumnEdgeView() == null && view.getRowEdgeView() == null) {
            throw new DataException("data.olap.NoEdgeDefinitionFound");
        }
        if (view.getColumnEdgeView() != null) {
            CubeQueryValidator.validateOnEdgeDefinition(cube, view.getColumnEdgeView());
        }
        if (view.getRowEdgeView() != null) {
            CubeQueryValidator.validateOnEdgeDefinition(cube, view.getRowEdgeView());
        }
        if (calculatedMember != null && calculatedMember.length > 0) {
            CubeQueryValidator.validateCalculatedMember(defn, cube, calculatedMember);
        }
    }

    static void validateCalculatedMember(ICubeQueryDefinition defn, ICube cube, CalculatedMember[] calculatedMember) throws DataException {
        boolean findMeasure = false;
        int i = 0;
        while (i < calculatedMember.length) {
            findMeasure = false;
            String measureName = calculatedMember[i].getMeasureName();
            String[] names = cube.getMeasureNames();
            if (names != null && names.length > 0) {
                int k = 0;
                while (k < names.length) {
                    if (names[k].equals(measureName)) {
                        findMeasure = true;
                        break;
                    }
                    ++k;
                }
            }
            if (!findMeasure) {
                List computedMeasures = defn.getComputedMeasures();
                int k = 0;
                while (k < computedMeasures.size()) {
                    if (((ComputedMeasureDefinition)computedMeasures.get(k)).getName().equals(measureName)) {
                        findMeasure = true;
                        break;
                    }
                    ++k;
                }
                AggregationManager.getInstance().getAggregation(calculatedMember[i].getAggrFunction());
            }
            ++i;
        }
    }

    static void validateOnEdgeDefinition(ICube cube, BirtEdgeView edgeView) throws DataException {
        int i = 0;
        while (i < edgeView.getDimensionViews().size()) {
            BirtDimensionView birtDimensionView = (BirtDimensionView)edgeView.getDimensionViews().get(i);
            int j = 0;
            while (j < birtDimensionView.getMemberSelection().size()) {
                String hierarchyName;
                ILevelDefinition levelDefinition = (ILevelDefinition)birtDimensionView.getMemberSelection().get(j);
                String dimensionName = levelDefinition.getHierarchy().getDimension().getName();
                String levelName = levelDefinition.getName();
                if (!CubeQueryValidator.validateWithRawCube(cube, levelName, dimensionName, hierarchyName = levelDefinition.getHierarchy().getName())) {
                    throw new DataException("data.olap.CannotFindLevel", new Object[]{levelName, hierarchyName, dimensionName});
                }
                ++j;
            }
            ++i;
        }
    }

    static boolean validateWithRawCube(ICube cube, String levelName, String dimensionName, String hierarchyName) {
        boolean validate = false;
        int k = 0;
        while (k < cube.getDimesions().length) {
            if (dimensionName.equals(cube.getDimesions()[k].getName()) && hierarchyName.equals(cube.getDimesions()[k].getHierarchy().getName())) {
                int t = 0;
                while (t < cube.getDimesions()[k].getHierarchy().getLevels().length) {
                    if (levelName.equals(cube.getDimesions()[k].getHierarchy().getLevels()[t].getName())) {
                        validate = true;
                        return validate;
                    }
                    ++t;
                }
            }
            ++k;
        }
        return validate;
    }
}

