/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.mozilla.javascript.Scriptable;

public abstract class BaseJSEvalHelper {
    protected Scriptable scope;
    protected ICubeQueryDefinition queryDefn;
    protected IBaseExpression expr;
    protected IBaseQueryResults outResults;
    private List jsObjectPopulators;
    protected ScriptContext cx;

    protected void init(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, ScriptContext cx, IBaseExpression expr) throws DataException {
        this.scope = cx.getContext().initStandardObjects();
        this.scope.setParentScope(parentScope);
        this.queryDefn = queryDefn;
        this.expr = expr;
        this.outResults = outResults;
        this.cx = cx;
        this.jsObjectPopulators = new ArrayList();
        this.registerJSObjectPopulators();
        OLAPExpressionCompiler.compile(cx.getContext(), this.expr);
    }

    protected abstract void registerJSObjectPopulators() throws DataException;

    protected void register(IJSObjectPopulator populator) throws DataException {
        populator.doInit();
        this.jsObjectPopulators.add(populator);
    }

    protected void setData(Object resultRow) {
        for (IJSObjectPopulator populator : this.jsObjectPopulators) {
            populator.setData(resultRow);
        }
    }

    public void close() {
        for (IJSObjectPopulator populator : this.jsObjectPopulators) {
            populator.cleanUp();
        }
        this.jsObjectPopulators = null;
    }
}

