/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.util.ICubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapExpressionUtil {
    public static String getAttrReference(String dimName, String levelName, String attrName) {
        return String.valueOf(dimName) + '/' + levelName + '/' + attrName;
    }

    public static String createMeasureCalculateMemeberName(String originalMeasureName) {
        return "_&$" + originalMeasureName + "$&_";
    }

    public static boolean isReferenceToDimLevel(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    private static String[] getTargetLevel(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = expr.split("\\Q\"][\"\\E");
        result[0] = result[0].replaceAll("\\Q[\"\\E", "");
        result[1] = result[1].replaceAll("\\Q\"]\\E", "");
        return result;
    }

    private static String[] getTargetAttribute(String expr, List bindings) throws DataException {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E") && !expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            if (bindingName != null) {
                int i = 0;
                while (i < bindings.size()) {
                    IBinding binding = (IBinding)bindings.get(i);
                    if (bindingName.equals(binding.getBindingName()) && binding.getExpression() instanceof IScriptExpression) {
                        return OlapExpressionUtil.getTargetAttribute(((IScriptExpression)binding.getExpression()).getText(), bindings);
                    }
                    ++i;
                }
            }
            throw new DataException("data.engine.InvalidExpression", expr);
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = new String[3];
        String[] candidateResult = expr.split("\\Q\"][\"\\E");
        if (candidateResult.length == 2) {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1].replaceAll("\\Q\"]\\E", "");
        } else {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1];
            result[2] = candidateResult[2].replaceAll("\\Q\"]\\E", "");
        }
        return result;
    }

    public static DimLevel getTargetDimLevel(String expr) throws DataException {
        String[] target = OlapExpressionUtil.getTargetLevel(expr);
        if (target == null || target.length < 2) {
            throw new DataException("data.olap.levelNameNotFound", expr);
        }
        switch (target.length) {
            case 2: {
                return new DimLevel(target[0], target[1]);
            }
            case 3: {
                return new DimLevel(target[0], target[1], target[2]);
            }
        }
        throw new DataException("data.olap.levelNameNotFound", expr);
    }

    public static String getMeasure(String expr) throws DataException {
        if (expr == null) {
            return null;
        }
        String result = OlapExpressionUtil.findMeasure(expr);
        if (result == null) {
            throw new DataException("data.olap.invalidMeasureRef", expr);
        }
        return result;
    }

    private static String findMeasure(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qmeasure[\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        return expr.replaceFirst("\\Qmeasure[\"\\E", "").replaceFirst("\\Q\"]\\E", "");
    }

    public static String getMeasure(IBaseExpression expr) {
        if (expr instanceof IScriptExpression) {
            return OlapExpressionUtil.findMeasure(((IScriptExpression)expr).getText());
        }
        return null;
    }

    public static boolean isDirectRerenrence(IBaseExpression expression, List<IBinding> bindings) throws DataException {
        if (!(expression instanceof IScriptExpression)) {
            return false;
        }
        String expr = ((IScriptExpression)expression).getText();
        if (expr == null) {
            return false;
        }
        if (expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            return true;
        }
        if (expr.matches("\\Qmeasure[\"\\E.*\\Q\"]\\E")) {
            return true;
        }
        if (expr.matches("\\Qdata[\"\\E.*\\Q\"]\\E")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            for (IBinding binding : bindings) {
                if (!binding.getBindingName().equals(bindingName)) continue;
                return OlapExpressionUtil.isDirectRerenrence(binding.getExpression(), bindings);
            }
        }
        return false;
    }

    public static String getBindingName(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.matches("\\Qdata[\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        return expr.replaceFirst("\\Qdata[\"\\E", "").replaceFirst("\\Q\"]\\E", "");
    }

    public static String getAttributeColumnName(String level, String attribute) {
        return String.valueOf(level) + "/" + attribute;
    }

    public static String getQualifiedLevelName(String dimensionName, String levelName) {
        return String.valueOf(dimensionName) + "/" + levelName;
    }

    public static String getDisplayColumnName(String level) {
        return String.valueOf(level) + "/" + "DisplayName";
    }

    public static ICubeAggrDefn[] getAggrDefns(List bindings) throws DataException {
        if (bindings == null || bindings.size() == 0) {
            return new ICubeAggrDefn[0];
        }
        ArrayList<CubeAggrDefn> cubeAggrDefns = new ArrayList<CubeAggrDefn>();
        for (IBinding binding : bindings) {
            try {
                if (binding.getAggrFunction() == null && binding.getAggregatOns().size() == 0) continue;
                cubeAggrDefns.add(new CubeAggrDefn(binding.getBindingName(), OlapExpressionUtil.getMeasure(binding.getExpression() == null ? null : ((IScriptExpression)binding.getExpression()).getText()), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), OlapExpressionUtil.convertToDimLevelAttribute(binding.getArguments(), bindings), binding.getFilter()));
            }
            catch (DataException ex) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression", (Throwable)((Object)ex), binding.getBindingName());
            }
        }
        ICubeAggrDefn[] result = new ICubeAggrDefn[cubeAggrDefns.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (ICubeAggrDefn)cubeAggrDefns.get(i);
            ++i;
        }
        return result;
    }

    public static ICubeAggrDefn[] getAggrDefnsByNestBinding(List<IBinding> bindings) throws DataException {
        if (bindings == null || bindings.size() == 0) {
            return new ICubeAggrDefn[0];
        }
        ArrayList<CubeAggrDefn> cubeAggrDefns = new ArrayList<CubeAggrDefn>();
        for (IBinding binding : bindings) {
            try {
                if (binding.getAggrFunction() == null) continue;
                cubeAggrDefns.add(new CubeAggrDefn(binding.getBindingName(), OlapExpressionUtil.getBindingName(((IScriptExpression)binding.getExpression()).getText()), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), OlapExpressionUtil.convertToDimLevelAttribute(binding.getArguments(), bindings), binding.getFilter()));
            }
            catch (DataException ex) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression", (Throwable)((Object)ex), binding.getBindingName());
            }
        }
        return cubeAggrDefns.toArray(new CubeAggrDefn[0]);
    }

    public static boolean isAggregationBinding(IBinding binding) throws DataException {
        if (binding == null) {
            return false;
        }
        return binding.getAggrFunction() != null;
    }

    public static String getReferencedDimensionName(IBaseExpression expr, List bindings) throws DataException {
        String result = OlapExpressionCompiler.getReferencedScriptObject(expr, "dimension");
        if (result == null) {
            String bindingName = OlapExpressionCompiler.getReferencedScriptObject(expr, "data");
            if (bindingName == null) {
                return null;
            }
            int i = 0;
            while (i < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(i);
                if (binding.getBindingName().equals(bindingName)) {
                    return OlapExpressionUtil.getReferencedDimensionName(binding.getExpression(), bindings);
                }
                ++i;
            }
        }
        return result;
    }

    private static List convertToDimLevel(List dimLevelExpressions) throws DataException {
        ArrayList<DimLevel> result = new ArrayList<DimLevel>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            result.add(OlapExpressionUtil.getTargetDimLevel(dimLevelExpressions.get(i).toString()));
            ++i;
        }
        return result;
    }

    private static List convertToDimLevelAttribute(List dimLevelExpressions, List bindings) throws DataException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            result.add(OlapExpressionUtil.getTargetAttribute(((IScriptExpression)dimLevelExpressions.get(i)).getText(), bindings));
            ++i;
        }
        return result;
    }

    public static boolean isComplexDimensionExpr(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E\\S+?") || expr.matches("\\S+?\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    public static boolean isReferenceToAttribute(IBaseExpression expr, List bindings) throws DataException {
        Set set = OlapExpressionCompiler.getReferencedDimLevel(expr, bindings);
        if (set.size() != 1) {
            return false;
        }
        for (Object obj : set) {
            DimLevel dimLevel;
            if (!(obj instanceof DimLevel) || (dimLevel = (DimLevel)obj).getAttrName() == null) continue;
            return true;
        }
        return false;
    }

    public static Scriptable createQueryResultsScriptable(IBaseQueryResults outResults) throws DataException {
        if (outResults instanceof ICubeQueryResults) {
            return new JSCubeBindingObject(((ICubeQueryResults)outResults).getCubeCursor());
        }
        if (outResults instanceof IQueryService) {
            try {
                return ((IQueryService)((Object)outResults)).getExecutorHelper().getScriptable();
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        return null;
    }

    private static class CubeAggrDefn
    implements ICubeAggrDefn {
        private String name;
        private String measure;
        private List aggrLevels;
        private List arguments;
        private String aggrName;
        private IBaseExpression filterExpression;

        CubeAggrDefn(String name, String measure, List aggrLevels, String aggrName, List arguments, IBaseExpression filterExpression) {
            assert (name != null);
            assert (aggrLevels != null);
            this.name = name;
            this.measure = measure;
            this.aggrLevels = aggrLevels;
            this.aggrName = aggrName;
            this.arguments = arguments;
            this.filterExpression = filterExpression;
        }

        public List getAggrLevels() {
            return this.aggrLevels;
        }

        public List getArguments() {
            return this.arguments;
        }

        public String getMeasure() {
            return this.measure;
        }

        public String getName() {
            return this.name;
        }

        public String getAggrName() {
            return this.aggrName;
        }

        public IBaseExpression getFilter() {
            return this.filterExpression;
        }
    }
}

