/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util.sort;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.util.DataJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.DimensionJSEvalHelper;
import org.eclipse.birt.data.engine.olap.util.IJSObjectPopulator;
import org.eclipse.birt.data.engine.olap.util.filter.IResultRow;
import org.eclipse.birt.data.engine.olap.util.sort.IJSSortHelper;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class DimensionSortEvalHelper
extends DimensionJSEvalHelper
implements IJSSortHelper {
    protected ICubeSortDefinition sortDefinition;
    private DimLevel targetLevel;

    public DimensionSortEvalHelper(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, ICubeSortDefinition sortDefinition, ScriptContext cx) throws DataException {
        assert (sortDefinition != null);
        this.initialize(outResults, parentScope, queryDefn, sortDefinition, cx);
    }

    protected void initialize(IBaseQueryResults outResults, Scriptable parentScope, ICubeQueryDefinition queryDefn, ICubeSortDefinition sortDefinition, ScriptContext cx) throws DataException {
        super.init(outResults, parentScope, queryDefn, cx, sortDefinition.getExpression());
        this.sortDefinition = sortDefinition;
    }

    public Object evaluate(IResultRow resultRow) throws DataException {
        super.setData(resultRow);
        try {
            return ScriptEvalUtil.evalExpr(this.expr, this.cx, this.scope, ScriptExpression.defaultID, 0);
        }
        catch (IJSObjectPopulator.InMatchDimensionIndicator inMatchDimensionIndicator) {
            return null;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public DimLevel getTargetLevel() {
        if (this.targetLevel == null) {
            this.targetLevel = new DimLevel(this.sortDefinition.getTargetLevel());
        }
        return this.targetLevel;
    }

    public int getSortDirection() {
        return this.sortDefinition.getSortDirection();
    }

    protected void registerJSObjectPopulators() throws DataException {
        super.registerJSObjectPopulators();
        this.register(new DataJSObjectPopulator(this.outResults, this.scope, this.queryDefn.getBindings(), false, this.cx));
    }
}

