/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.command.BackRefRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class ElementBackRefRecord
extends BackRefRecord {
    protected IReferencableElement referred = null;
    private DesignElement target;

    public ElementBackRefRecord(Module module, IReferencableElement referred, DesignElement reference, String propName) {
        super(module, reference, propName);
        this.referred = referred;
        assert (referred != null);
        this.target = reference;
    }

    public ElementBackRefRecord(Module module, IReferencableElement referred, Structure reference, String propName) {
        super(module, reference, propName);
        this.referred = referred;
        assert (referred != null);
        this.target = reference.getElement();
    }

    protected void perform(boolean undo) {
        if (undo) {
            if (this.reference instanceof DesignElement) {
                DesignElement tmpElement = (DesignElement)this.reference;
                ElementPropertyDefn propDefn = tmpElement.getPropertyDefn(this.propName);
                if ("style".equals(this.propName)) {
                    tmpElement.getStyle(this.module);
                } else if ("theme".equals(this.propName)) {
                    ((Module)tmpElement).getTheme(this.module);
                } else {
                    tmpElement.getLocalProperty(this.module, propDefn);
                }
            } else {
                ((Structure)this.reference).getLocalProperty(this.module, this.propName);
            }
        } else if (this.reference instanceof DesignElement) {
            this.removeElementRefOfProperty();
        } else {
            this.removeBackRefOfStructMember();
        }
    }

    private void removeBackRefOfStructMember() {
        Structure struct = (Structure)this.reference;
        Object value = struct.getLocalProperty(this.module, this.propName);
        assert (value instanceof ElementRefValue);
        ElementRefValue refValue = (ElementRefValue)value;
        refValue.unresolved(refValue.getName());
        this.referred.dropClient(struct, this.propName);
    }

    private void removeElementRefOfProperty() {
        DesignElement tmpElement = (DesignElement)this.reference;
        Object value = tmpElement.getLocalProperty(this.module, this.propName);
        if (value instanceof ElementRefValue) {
            ElementRefValue refValue = (ElementRefValue)value;
            refValue.unresolved(refValue.getName());
            this.referred.dropClient(tmpElement);
        } else if (value instanceof List) {
            List listValue = (List)value;
            int i = 0;
            while (i < listValue.size()) {
                ElementRefValue item = (ElementRefValue)listValue.get(i);
                if (item.getElement() == this.referred) {
                    item.unresolved(item.getName());
                    this.referred.dropClient(tmpElement);
                    break;
                }
                ++i;
            }
        }
    }

    public DesignElement getTarget() {
        return this.target;
    }
}

