/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.command.ViewsContentEvent;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.AbstractMultiViews;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.IMultiViewsModel;

public class MultiViews
extends AbstractMultiViews
implements IMultiViewsModel {
    public void apply(ElementVisitor visitor) {
        visitor.visitMultiView(this);
    }

    public String getElementName() {
        return "MultiViews";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    private MultiViewsHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new MultiViewsHandle(module, this);
        }
        return (MultiViewsHandle)this.handle;
    }

    public void broadcast(NotificationEvent ev, Module module) {
        super.broadcast(ev, module);
        DesignElement tmpContainer = this.getContainer();
        if (tmpContainer == null) {
            return;
        }
        NotificationEvent newEvent = MultiViews.adjustEvent(ev, tmpContainer);
        if (newEvent != null) {
            tmpContainer.broadcast(newEvent, module);
        }
    }

    private static NotificationEvent adjustEvent(NotificationEvent ev, DesignElement tmpContainer) {
        if (ev instanceof PropertyEvent) {
            return new PropertyEvent(tmpContainer, "multiViews");
        }
        if (!(ev instanceof ContentEvent)) {
            return null;
        }
        ContentEvent tmpEv = (ContentEvent)ev;
        int action = tmpEv.getAction();
        int newAction = -1;
        switch (action) {
            case 1: {
                newAction = 10;
                break;
            }
            case 2: {
                newAction = 11;
                break;
            }
            case 3: {
                newAction = 12;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        ContainerContext tmpContext = new ContainerContext(tmpContainer, "multiViews");
        ev = new ViewsContentEvent(tmpContext, (DesignElement)tmpEv.getContent(), newAction);
        ev.setDeliveryPath(6);
        return ev;
    }
}

