/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.simpleapi.IAction;
import org.eclipse.birt.report.model.simpleapi.Structure;

public class ActionImpl
extends Structure
implements IAction {
    private ReportItemHandle handle;

    public ActionImpl(ActionHandle action, ReportItemHandle handle) {
        super(action);
        this.handle = handle;
    }

    public String getURI() {
        return ((ActionHandle)this.structureHandle).getURI();
    }

    public String getTargetWindow() {
        return ((ActionHandle)this.structureHandle).getTargetWindow();
    }

    public String getLinkType() {
        return ((ActionHandle)this.structureHandle).getLinkType();
    }

    public void setLinkType(String type) throws SemanticException {
        this.checkAction();
        ActivityStack cmdStack = this.handle.getModule().getActivityStack();
        cmdStack.startNonUndoableTrans(null);
        try {
            ((ActionHandle)this.structureHandle).setLinkType(type);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void setFormatType(String type) throws SemanticException {
        this.checkAction();
        this.setProperty("formatType", type);
    }

    public String getFormatType() {
        return ((ActionHandle)this.structureHandle).getFormatType();
    }

    public void setTargetWindow(String window) throws SemanticException {
        this.checkAction();
        this.setProperty("targetWindow", window);
    }

    public void setURI(String uri) throws SemanticException {
        this.checkAction();
        this.setProperty("uri", uri);
    }

    public String getReportName() {
        return ((ActionHandle)this.structureHandle).getReportName();
    }

    public void setReportName(String reportName) throws SemanticException {
        this.checkAction();
        this.setProperty("reportName", reportName);
    }

    public String getTargetBookmark() {
        return ((ActionHandle)this.structureHandle).getTargetBookmark();
    }

    public void setTargetBookmark(String bookmark) throws SemanticException {
        this.checkAction();
        this.setProperty("targetBookmark", bookmark);
    }

    private void checkAction() throws SemanticException {
        if (this.structureHandle != null) {
            return;
        }
        Action a = new Action();
        if (this.handle instanceof LabelHandle) {
            ((LabelHandle)this.handle).setAction(a);
            this.structureHandle = ((LabelHandle)this.handle).getActionHandle();
        } else if (this.handle instanceof ImageHandle) {
            ((ImageHandle)this.handle).setAction(a);
            this.structureHandle = ((ImageHandle)this.handle).getActionHandle();
        } else if (this.handle instanceof DataItemHandle) {
            ((DataItemHandle)this.handle).setAction(a);
            this.structureHandle = ((DataItemHandle)this.handle).getActionHandle();
        } else {
            throw new PropertyNameException(this.handle == null ? null : this.handle.getElement(), "action");
        }
    }
}

