/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import java.io.IOException;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IDataItem;
import org.eclipse.birt.report.model.api.simpleapi.IDataSet;
import org.eclipse.birt.report.model.api.simpleapi.IDataSource;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.IDynamicText;
import org.eclipse.birt.report.model.api.simpleapi.IGrid;
import org.eclipse.birt.report.model.api.simpleapi.IImage;
import org.eclipse.birt.report.model.api.simpleapi.ILabel;
import org.eclipse.birt.report.model.api.simpleapi.IList;
import org.eclipse.birt.report.model.api.simpleapi.IMasterPage;
import org.eclipse.birt.report.model.api.simpleapi.IReportDesign;
import org.eclipse.birt.report.model.api.simpleapi.IReportElement;
import org.eclipse.birt.report.model.api.simpleapi.ITable;
import org.eclipse.birt.report.model.api.simpleapi.ITextItem;
import org.eclipse.birt.report.model.simpleapi.DataSet;
import org.eclipse.birt.report.model.simpleapi.DataSource;
import org.eclipse.birt.report.model.simpleapi.DesignElement;
import org.eclipse.birt.report.model.simpleapi.ElementUtil;
import org.eclipse.birt.report.model.simpleapi.MasterPage;

class InternalReportDesign
extends DesignElement
implements IReportDesign {
    private ReportDesignHandle report;

    public InternalReportDesign(ReportDesignHandle report) {
        super(report);
        this.report = report;
    }

    public IMasterPage getMasterPage(String name) {
        MasterPageHandle masterPage = this.report.findMasterPage(name);
        if (masterPage == null) {
            return null;
        }
        return new MasterPage(masterPage);
    }

    public IDataSet getDataSet(String name) {
        DataSetHandle dataSet = this.report.findDataSet(name);
        if (dataSet == null) {
            return null;
        }
        return new DataSet(dataSet);
    }

    public IDataSource getDataSource(String name) {
        DataSourceHandle dataSource = this.report.findDataSource(name);
        if (dataSource == null) {
            return null;
        }
        return new DataSource(dataSource);
    }

    public IReportElement getReportElement(String name) {
        DesignElementHandle element = this.report.findElement(name);
        IDesignElement elementDesign = ElementUtil.getElement(element);
        return elementDesign instanceof IReportElement ? (IReportElement)elementDesign : null;
    }

    public IReportElement getReportElementByID(long id) {
        DesignElementHandle element = this.report.getElementByID(id);
        IDesignElement elementDesign = ElementUtil.getElement(element);
        return elementDesign instanceof IReportElement ? (IReportElement)elementDesign : null;
    }

    public IDataItem getDataItem(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof IDataItem) {
            return (IDataItem)element;
        }
        return null;
    }

    public IGrid getGrid(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof IGrid) {
            return (IGrid)element;
        }
        return null;
    }

    public IImage getImage(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof IImage) {
            return (IImage)element;
        }
        return null;
    }

    public ILabel getLabel(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof ILabel) {
            return (ILabel)element;
        }
        return null;
    }

    public IList getList(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof IList) {
            return (IList)element;
        }
        return null;
    }

    public ITable getTable(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof ITable) {
            return (ITable)element;
        }
        return null;
    }

    public IDynamicText getDynamicText(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof IDynamicText) {
            return (IDynamicText)element;
        }
        return null;
    }

    public ITextItem getTextItem(String name) {
        IReportElement element = this.getReportElement(name);
        if (element != null && element instanceof ITextItem) {
            return (ITextItem)element;
        }
        return null;
    }

    public void setDisplayNameKey(String displayNameKey) throws SemanticException {
        this.setProperty("displayNameID", displayNameKey);
    }

    public String getDisplayNameKey() {
        return this.report.getDisplayNameKey();
    }

    public void setDisplayName(String displayName) throws SemanticException {
        this.setProperty("displayName", displayName);
    }

    public String getDisplayName() {
        return this.report.getDisplayName();
    }

    public void save() throws IOException {
        this.report.save();
    }

    public void saveAs(String newName) throws IOException {
        this.report.saveAs(newName);
    }

    public String getTheme() {
        return this.report.getStringProperty("theme");
    }

    public void setTheme(String theme) throws SemanticException {
        this.setProperty("theme", theme);
    }
}

