/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.AbstractChartBaseQueryGenerator;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.emf.common.util.EList;

public class ChartBaseQueryHelper
extends AbstractChartBaseQueryGenerator {
    public ChartBaseQueryHelper(ReportItemHandle handle, Chart cm) {
        this(handle, cm, false);
    }

    public ChartBaseQueryHelper(ReportItemHandle handle, Chart cm, boolean bCreateBindingForExpression) {
        super(handle, cm, bCreateBindingForExpression);
    }

    public IDataQueryDefinition createBaseQuery(IDataQueryDefinition parent) throws ChartException {
        BaseQueryDefinition query = this.createQueryDefinition(parent);
        if (query == null) {
            return null;
        }
        this.generateGroupBindings(query);
        return query;
    }

    protected BaseQueryDefinition createQueryDefinition(IDataQueryDefinition parent) throws ChartException {
        DataSetHandle dsHandle;
        QueryDefinition query = null;
        BaseQueryDefinition parentQuery = null;
        if (parent instanceof BaseQueryDefinition) {
            parentQuery = (BaseQueryDefinition)parent;
        }
        if ((dsHandle = this.fReportItemHandle.getDataSet()) == null) {
            String dsName = (String)this.fReportItemHandle.getProperty("dataSet");
            if (dsName != null && dsName.length() > 0) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)new EngineException("Error.UndefinedDatasetError", (Object)dsName));
            }
            if (parent instanceof ICubeQueryDefinition) {
                return null;
            }
            if (ChartReportItemUtil.canScaleShared(this.fReportItemHandle, this.fChartModel)) {
                this.addMinMaxBinding(ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.fReportItemHandle), parentQuery);
            }
            query = this.createSubQuery(this.fReportItemHandle, parentQuery);
        } else {
            query = new QueryDefinition(parentQuery);
            query.setDataSetName(dsHandle.getQualifiedName());
            query.getInputParamBindings().addAll(this.createParamBindings(this.fReportItemHandle.paramBindingsIterator()));
            Iterator iter = this.fReportItemHandle.columnBindingsIterator();
            while (iter.hasNext()) {
                ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
                this.addColumBinding((IBaseQueryDefinition)query, binding);
            }
            this.addSortAndFilter(this.fReportItemHandle, (BaseQueryDefinition)query);
        }
        return query;
    }

    protected void addColumBinding(IBaseQueryDefinition transfer, ComputedColumnHandle columnBinding) throws ChartException {
        String name = columnBinding.getName();
        String expr = columnBinding.getExpression();
        String type = columnBinding.getDataType();
        int dbType = ModelDteApiAdapter.toDteDataType((String)type);
        ScriptExpression dbExpr = expr == null ? null : new ScriptExpression(expr, dbType);
        Binding binding = new Binding(name, (IBaseExpression)dbExpr);
        try {
            Iterator arguments;
            String filter;
            if (columnBinding.getAggregateOn() != null) {
                binding.addAggregateOn(columnBinding.getAggregateOn());
            }
            if (columnBinding.getAggregateFunction() != null) {
                binding.setAggrFunction(columnBinding.getAggregateFunction());
            }
            if ((filter = columnBinding.getFilterExpression()) != null) {
                binding.setFilter((IBaseExpression)new ScriptExpression(filter));
            }
            if ((arguments = columnBinding.argumentsIterator()) != null) {
                while (arguments.hasNext()) {
                    AggregationArgumentHandle argumentHandle = (AggregationArgumentHandle)arguments.next();
                    String argument = argumentHandle.getValue();
                    if (argument == null) continue;
                    binding.addArgument((IBaseExpression)new ScriptExpression(argument));
                }
            }
            transfer.addBinding((IBinding)binding);
        }
        catch (DataException ex) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)ex);
        }
    }

    private void addMinMaxBinding(ReportItemHandle handle, BaseQueryDefinition query) throws ChartException {
        try {
            String queryExp = this.getExpressionOfValueSeries();
            ComputedColumn ccMin = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)"chart__min");
            ccMin.setAggregateFunction("min");
            ccMin.setExpression(queryExp);
            this.addColumBinding((IBaseQueryDefinition)query, handle.addColumnBinding(ccMin, false));
            ComputedColumn ccMax = StructureFactory.newComputedColumn((DesignElementHandle)handle, (String)"chart__max");
            ccMax.setAggregateFunction("max");
            ccMax.setExpression(queryExp);
            this.addColumBinding((IBaseQueryDefinition)query, handle.addColumnBinding(ccMax, false));
        }
        catch (SemanticException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
        }
    }

    protected BaseQueryDefinition createSubQuery(ReportItemHandle handle, BaseQueryDefinition parentQuery) throws ChartException {
        QueryDefinition query = null;
        if (parentQuery == null) {
            query = new QueryDefinition(null);
        } else {
            query = new SubqueryDefinition("chart_subquery" + handle.getElement().getID(), (IBaseQueryDefinition)parentQuery);
            parentQuery.getSubqueries().add(query);
        }
        Iterator iter = handle.columnBindingsIterator();
        while (iter.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iter.next();
            this.addColumBinding((IBaseQueryDefinition)query, binding);
        }
        this.addSortAndFilter(handle, (BaseQueryDefinition)query);
        return query;
    }

    protected void addSortAndFilter(ReportItemHandle handle, BaseQueryDefinition query) {
        if (handle instanceof ExtendedItemHandle) {
            query.getFilters().addAll(ChartBaseQueryHelper.createFilters(((ExtendedItemHandle)handle).filtersIterator()));
        } else if (handle instanceof TableHandle) {
            query.getFilters().addAll(ChartBaseQueryHelper.createFilters(((TableHandle)handle).filtersIterator()));
        }
    }

    protected static ArrayList createFilters(Iterator iter) {
        ArrayList<IFilterDefinition> filters = new ArrayList<IFilterDefinition>();
        if (iter != null) {
            while (iter.hasNext()) {
                FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
                IFilterDefinition filter = ChartBaseQueryHelper.createFilter(filterHandle);
                filters.add(filter);
            }
        }
        return filters;
    }

    private static IFilterDefinition createFilter(FilterConditionHandle handle) {
        String filterExpr = handle.getExpr();
        if (filterExpr == null || filterExpr.length() == 0) {
            return null;
        }
        String filterOpr = handle.getOperator();
        if (filterOpr == null || filterOpr.length() == 0) {
            return new FilterDefinition((IBaseExpression)new ScriptExpression(filterExpr));
        }
        String column = filterExpr;
        int dteOpr = ModelDteApiAdapter.toDteFilterOperator((String)filterOpr);
        if (ModuleUtil.isListFilterValue((FilterConditionHandle)handle)) {
            List operand1List = handle.getValue1List();
            return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1List));
        }
        String operand1 = handle.getValue1();
        String operand2 = handle.getValue2();
        return new FilterDefinition((IBaseExpression)new ConditionalExpression(column, dteOpr, operand1, operand2));
    }

    protected List createParamBindings(Iterator iter) {
        ArrayList<IInputParameterBinding> list = new ArrayList<IInputParameterBinding>();
        if (iter != null) {
            while (iter.hasNext()) {
                ParamBindingHandle modelParamBinding = (ParamBindingHandle)iter.next();
                IInputParameterBinding binding = this.createParamBinding(modelParamBinding);
                if (binding == null) continue;
                list.add(binding);
            }
        }
        return list;
    }

    protected IInputParameterBinding createParamBinding(ParamBindingHandle handle) {
        if (handle.getExpression() == null) {
            return null;
        }
        ScriptExpression expr = new ScriptExpression(handle.getExpression());
        return new InputParameterBinding(handle.getParamName(), (IBaseExpression)expr);
    }

    private String getExpressionOfValueSeries() {
        SeriesDefinition ySd;
        if (this.fChartModel instanceof ChartWithAxes) {
            Axis yAxis = (Axis)((Axis)((ChartWithAxes)this.fChartModel).getAxes().get(0)).getAssociatedAxes().get(0);
            ySd = (SeriesDefinition)yAxis.getSeriesDefinitions().get(0);
        } else {
            ySd = (SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.fChartModel).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0);
        }
        Query query = (Query)ySd.getDesignTimeSeries().getDataDefinition().get(0);
        return query.getDefinition();
    }

    public IDataQueryDefinition createBaseQuery(List columns) {
        throw new UnsupportedOperationException("Don't be implemented in the class.");
    }

    public static List getAllQueryExpressionDefinitions(Chart chart) {
        ArrayList<Query> queryList = new ArrayList<Query>();
        if (chart instanceof ChartWithAxes) {
            Axis xAxis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
            queryList.addAll(ChartBaseQueryHelper.getQueries(xAxis.getSeriesDefinitions()));
            EList axisList = xAxis.getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                EList sds = ((Axis)axisList.get(i)).getSeriesDefinitions();
                Query q = ((SeriesDefinition)sds.get(0)).getQuery();
                if (q != null) {
                    queryList.add(q);
                }
                queryList.addAll(ChartBaseQueryHelper.getQueries(sds));
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            queryList.addAll((Collection<Query>)sdBase.getDesignTimeSeries().getDataDefinition());
            Query q = ((SeriesDefinition)sdBase.getSeriesDefinitions().get(0)).getQuery();
            if (q != null) {
                queryList.add(q);
            }
            queryList.addAll(ChartBaseQueryHelper.getQueries(sdBase.getSeriesDefinitions()));
        }
        return queryList;
    }

    private static List getQueries(EList seriesDefinitions) {
        ArrayList querys = new ArrayList();
        Iterator iter = seriesDefinitions.iterator();
        while (iter.hasNext()) {
            querys.addAll(((SeriesDefinition)iter.next()).getDesignTimeSeries().getDataDefinition());
        }
        return querys;
    }

    public static IGroupDefinition handleGroup(GroupHandle handle, IBaseQueryDefinition query) {
        GroupDefinition groupDefn = new GroupDefinition(handle.getName());
        groupDefn.setKeyExpression(handle.getKeyExpr());
        String interval = handle.getInterval();
        if (interval != null) {
            groupDefn.setInterval(ChartBaseQueryHelper.parseInterval(interval));
        }
        groupDefn.setIntervalRange(handle.getIntervalRange());
        groupDefn.setIntervalStart((Object)handle.getIntervalBase());
        String direction = handle.getSortDirection();
        if (direction != null) {
            groupDefn.setSortDirection(ChartBaseQueryHelper.parseSortDirection(direction));
        }
        groupDefn.getSorts().addAll(ChartBaseQueryHelper.createSorts(handle));
        groupDefn.getFilters().addAll(ChartBaseQueryHelper.createFilters(handle));
        query.getGroups().add(groupDefn);
        return groupDefn;
    }

    private static int parseInterval(String interval) {
        if ("year".equals(interval)) {
            return 1;
        }
        if ("month".equals(interval)) {
            return 2;
        }
        if ("week".equals(interval)) {
            return 4;
        }
        if ("quarter".equals(interval)) {
            return 3;
        }
        if ("day".equals(interval)) {
            return 5;
        }
        if ("hour".equals(interval)) {
            return 6;
        }
        if ("minute".equals(interval)) {
            return 7;
        }
        if ("prefix".equals(interval)) {
            return 100;
        }
        if ("second".equals(interval)) {
            return 8;
        }
        if ("interval".equals(interval)) {
            return 99;
        }
        return 0;
    }

    private static int parseSortDirection(String direction) {
        if ("asc".equals(direction)) {
            return 0;
        }
        if ("desc".equals(direction)) {
            return 1;
        }
        assert (false);
        return 0;
    }

    private static ArrayList createFilters(GroupHandle group) {
        return ChartBaseQueryHelper.createFilters(group.filtersIterator());
    }

    private static ISortDefinition createSort(SortKeyHandle handle) {
        SortDefinition sort = new SortDefinition();
        sort.setExpression(handle.getKey());
        sort.setSortDirection(handle.getDirection().equals("asc") ? 0 : 1);
        return sort;
    }

    public static ArrayList createSorts(Iterator iter) {
        ArrayList<ISortDefinition> sorts = new ArrayList<ISortDefinition>();
        if (iter != null) {
            while (iter.hasNext()) {
                SortKeyHandle handle = (SortKeyHandle)iter.next();
                sorts.add(ChartBaseQueryHelper.createSort(handle));
            }
        }
        return sorts;
    }

    private static ArrayList createSorts(GroupHandle group) {
        return ChartBaseQueryHelper.createSorts(group.sortsIterator());
    }
}

