/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.ChartChoiceDefinitionImpl;
import org.eclipse.birt.chart.reportitem.ChartElementCommandImpl;
import org.eclipse.birt.chart.reportitem.ChartPropertyDefinitionImpl;
import org.eclipse.birt.chart.reportitem.ChartPropertyMethodInfo;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartSimplePropertyCommandImpl;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.CompatibleExpressionUpdater;
import org.eclipse.birt.chart.reportitem.ScriptClassInfo;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.IChartEventHandler;
import org.eclipse.birt.chart.script.internal.ChartWithAxesImpl;
import org.eclipse.birt.chart.script.internal.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IChoiceDefinition;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IElementCommand;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.ReportItem;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.simpleapi.IReportItem;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;

public final class ChartReportItemImpl
extends ReportItem
implements ICompatibleReportItem,
IResourceFinder,
IExternalizer {
    private Chart cm = null;
    private Object oDesignerRepresentation = null;
    private static final List<IChoiceDefinition> liLegendPositions;
    private static final List<IChoiceDefinition> liLegendAnchors;
    private static final List<IChoiceDefinition> liChartDimensions;
    private transient ExtendedItemHandle handle = null;
    private transient ScaleContext sharedScale = null;
    private transient boolean bCopied = false;
    private static ILogger logger;

    static {
        ChartChoiceDefinitionImpl icd;
        String sLowercaseName;
        String sName;
        liLegendPositions = new LinkedList<IChoiceDefinition>();
        liLegendAnchors = new LinkedList<IChoiceDefinition>();
        liChartDimensions = new LinkedList<IChoiceDefinition>();
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
        List li = Position.VALUES;
        Iterator it = li.iterator();
        while (it.hasNext()) {
            sName = ((Position)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            if (sLowercaseName.equals("outside")) continue;
            icd = new ChartChoiceDefinitionImpl("choice.legend.position." + sLowercaseName, sName, null);
            liLegendPositions.add((IChoiceDefinition)icd);
        }
        li = Anchor.VALUES;
        it = li.iterator();
        while (it.hasNext()) {
            sName = ((Anchor)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            icd = new ChartChoiceDefinitionImpl("choice.legend.anchor." + sLowercaseName, sName, null);
            liLegendAnchors.add((IChoiceDefinition)icd);
        }
        li = ChartDimension.VALUES;
        it = li.iterator();
        while (it.hasNext()) {
            sName = ((ChartDimension)it.next()).getName();
            sLowercaseName = sName.toLowerCase(Locale.US);
            icd = new ChartChoiceDefinitionImpl("choice.chart.dimension." + sLowercaseName, sName, null);
            liChartDimensions.add((IChoiceDefinition)icd);
        }
    }

    public ChartReportItemImpl(ExtendedItemHandle handle) {
        this.handle = handle;
    }

    public void setModel(Chart chart) {
        this.cm = chart;
    }

    public void setScale(ScaleContext sharedScale) {
        this.sharedScale = sharedScale;
    }

    public ExtendedItemHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ExtendedItemHandle handle) {
        if (this.handle != handle) {
            this.handle = handle;
        } else {
            this.bCopied = false;
        }
    }

    public void executeSetSimplePropertyCommand(DesignElementHandle eih, String propName, Object oldValue, Object newValue) {
        if (this.handle == null) {
            return;
        }
        ChartSimplePropertyCommandImpl command = new ChartSimplePropertyCommandImpl(eih, this, propName, newValue, oldValue);
        this.handle.getModuleHandle().getCommandStack().execute((IElementCommand)command);
    }

    public void executeSetModelCommand(ExtendedItemHandle eih, Chart oldChart, Chart newChart) {
        if (this.handle == null) {
            return;
        }
        ChartElementCommandImpl command = new ChartElementCommandImpl(eih, this, oldChart, newChart);
        this.handle.getModuleHandle().getCommandStack().execute((IElementCommand)command);
    }

    public final void setDesignerRepresentation(Object oDesignerRepresentation) {
        this.oDesignerRepresentation = oDesignerRepresentation;
    }

    public final Object getDesignerRepresentation() {
        return this.oDesignerRepresentation;
    }

    public ByteArrayOutputStream serialize(String propName) {
        if (propName != null && propName.equalsIgnoreCase("xmlRepresentation") && !ChartXTabUtil.isAxisChart((DesignElementHandle)this.handle)) {
            try {
                return SerializerImpl.instance().asXml(this.cm, true);
            }
            catch (Exception e) {
                logger.log(e);
                return new ByteArrayOutputStream();
            }
        }
        return null;
    }

    public void deserialize(String propName, ByteArrayInputStream data) throws ExtendedElementException {
        if (propName != null && propName.equalsIgnoreCase("xmlRepresentation")) {
            try {
                this.cm = SerializerImpl.instance().fromXml(data, true);
                String reportVer = this.handle.getModuleHandle().getVersion();
                this.adjustNumberFormat(reportVer);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cm = null;
            }
        }
    }

    private void adjustNumberFormat(String reportVer) {
        block9: {
            ChartWithoutAxes cwa;
            EList categories;
            block8: {
                if (reportVer == null || ChartReportItemImpl.compareVersion(reportVer, "3.2.9") > 0) {
                    return;
                }
                if (!(this.cm instanceof ChartWithAxes)) break block8;
                ChartWithAxes cwa2 = (ChartWithAxes)this.cm;
                Axis[] baseAxis = cwa2.getBaseAxes();
                if (baseAxis.length <= 0) {
                    return;
                }
                this.adjustSingleNumberFormat(baseAxis[0].getFormatSpecifier());
                Axis[] yAxis = cwa2.getOrthogonalAxes(baseAxis[0], true);
                if (yAxis.length <= 0) {
                    return;
                }
                int i = 0;
                while (i < yAxis.length) {
                    this.adjustSingleNumberFormat(yAxis[i].getFormatSpecifier());
                    EList sds = yAxis[i].getSeriesDefinitions();
                    int j = 0;
                    while (j < sds.size()) {
                        SeriesDefinition sd = (SeriesDefinition)sds.get(j);
                        this.adjustSingleNumberFormat(sd.getFormatSpecifier());
                        EList dpcs = sd.getDesignTimeSeries().getDataPoint().getComponents();
                        int k = 0;
                        while (k < dpcs.size()) {
                            this.adjustSingleNumberFormat(((DataPointComponent)dpcs.get(k)).getFormatSpecifier());
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                break block9;
            }
            if (!(this.cm instanceof ChartWithoutAxes) || (categories = (cwa = (ChartWithoutAxes)this.cm).getSeriesDefinitions()).size() <= 0) break block9;
            EList sds = ((SeriesDefinition)categories.get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < sds.size()) {
                SeriesDefinition sd = (SeriesDefinition)sds.get(j);
                this.adjustSingleNumberFormat(sd.getFormatSpecifier());
                EList dpcs = sd.getDesignTimeSeries().getDataPoint().getComponents();
                int k = 0;
                while (k < dpcs.size()) {
                    this.adjustSingleNumberFormat(((DataPointComponent)dpcs.get(k)).getFormatSpecifier());
                    ++k;
                }
                ++j;
            }
        }
    }

    private void adjustSingleNumberFormat(FormatSpecifier fs) {
        double multiplier;
        if (!(fs instanceof NumberFormatSpecifier)) {
            return;
        }
        NumberFormatSpecifier nfs = (NumberFormatSpecifier)fs;
        String suffix = nfs.getSuffix();
        if ("%".equals(suffix) && !Double.isNaN(multiplier = nfs.getMultiplier()) && multiplier == 0.01) {
            nfs.setMultiplier(100.0 * multiplier);
        }
    }

    private static int compareVersion(String va, String vb) {
        return ChartUtil.compareVersion((String)va, (String)vb);
    }

    public IPropertyDefinition getScriptPropertyDefinition() {
        if (this.cm == null) {
            logger.log(2, Messages.getString("ChartReportItemImpl.log.RequestForScriptPropertyDefn"));
            return null;
        }
        return new ChartPropertyDefinitionImpl(null, "script", "property.script", false, 0, null, null, null);
    }

    public IPropertyDefinition[] getPropertyDefinitions() {
        if (this.cm == null) {
            return null;
        }
        return new IPropertyDefinition[]{new ChartPropertyDefinitionImpl(null, "title.value", "property.label.title.value", false, 0, null, null, null), new ChartPropertyDefinitionImpl(null, "title.font.rotation", "property.label.title.font.rotation", false, 14, null, null, null), new ChartPropertyDefinitionImpl(null, "legend.position", "property.label.legend.position", false, 5, liLegendPositions, null, null), new ChartPropertyDefinitionImpl(null, "legend.anchor", "property.label.legend.anchor", false, 5, liLegendAnchors, null, null), new ChartPropertyDefinitionImpl(null, "chart.dimension", "property.label.chart.dimension", false, 5, liChartDimensions, null, null), new ChartPropertyDefinitionImpl(null, "plot.transposed", "property.label.chart.plot.transposed", false, 6, null, null, null), new ChartPropertyDefinitionImpl(null, "script", "property.script", false, 0, null, null, null), new ChartPropertyDefinitionImpl(null, "onRender", "property.onRender", false, 18, null, null, null, new ChartPropertyMethodInfo("onRender", null, null, null, null, false, false))};
    }

    public IMethodInfo[] getMethods(String scriptName) {
        if (scriptName != null && scriptName.equals("onRender")) {
            ScriptClassInfo info = new ScriptClassInfo(IChartEventHandler.class);
            List list = info.getMethods();
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof IMethodInfo && arg1 instanceof IMethodInfo) {
                        String name0 = ((IMethodInfo)arg0).getName();
                        String name1 = ((IMethodInfo)arg1).getName();
                        if (name0.startsWith("before") && name1.startsWith("after")) {
                            return -1;
                        }
                        if (name0.startsWith("after") && name1.startsWith("before")) {
                            return 1;
                        }
                        return name0.compareToIgnoreCase(name1);
                    }
                    return -1;
                }
            });
            return list.toArray(new IMethodInfo[list.size()]);
        }
        return null;
    }

    public final Object getProperty(String propName) {
        if (this.cm == null) {
            this.initHostChart();
            if (this.cm == null) {
                return null;
            }
        }
        if (propName.equals("title.value")) {
            return this.cm.getTitle().getLabel().getCaption().getValue();
        }
        if (propName.equals("title.font.rotation")) {
            return new Double(this.cm.getTitle().getLabel().getCaption().getFont().getRotation());
        }
        if (propName.equals("legend.position")) {
            return this.cm.getLegend().getPosition().getName();
        }
        if (propName.equals("legend.anchor")) {
            return this.cm.getLegend().getAnchor().getName();
        }
        if (propName.equals("chart.dimension")) {
            return this.cm.getDimension().getName();
        }
        if (propName.equals("plot.transposed")) {
            return new Boolean(this.cm instanceof ChartWithAxes ? ((ChartWithAxes)this.cm).isTransposed() : false);
        }
        if (propName.equals("script") || propName.equals("onRender")) {
            return this.cm.getScript();
        }
        if (propName.equals("chart.instance")) {
            return this.cm;
        }
        if (propName.equals("chart.scale")) {
            return this.sharedScale;
        }
        return null;
    }

    private void initHostChart() {
        if (ChartXTabUtil.isAxisChart((DesignElementHandle)this.handle)) {
            ExtendedItemHandle hostChartHandle = (ExtendedItemHandle)this.handle.getElementProperty("hostChart");
            if (hostChartHandle == null || hostChartHandle == this.handle) {
                return;
            }
            this.cm = ChartReportItemUtil.getChartFromHandle(hostChartHandle);
        }
    }

    public void checkProperty(String propName, Object value) throws ExtendedElementException {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.checkProperty", new Object[]{propName, value}));
    }

    public void setProperty(String propName, Object value) {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.setProperty", new Object[]{propName, value}));
        this.executeSetSimplePropertyCommand((DesignElementHandle)this.handle, propName, this.getProperty(propName), value);
    }

    void basicSetProperty(String propName, Object value) {
        if (propName.equals("title.value")) {
            this.cm.getTitle().getLabel().getCaption().setValue((String)value);
        } else if (propName.equals("title.font.rotation")) {
            this.cm.getTitle().getLabel().getCaption().getFont().setRotation(((Double)value).doubleValue());
        } else if (propName.equals("legend.position")) {
            this.cm.getLegend().setPosition(Position.get((String)((String)value)));
        } else if (propName.equals("legend.anchor")) {
            this.cm.getLegend().setAnchor(Anchor.get((String)((String)value)));
        } else if (propName.equals("chart.dimension")) {
            this.cm.setDimension(ChartDimension.get((String)((String)value)));
        } else if (propName.equals("plot.transposed")) {
            if (this.cm instanceof ChartWithAxes) {
                ((ChartWithAxes)this.cm).setTransposed(((Boolean)value).booleanValue());
            } else {
                logger.log(4, Messages.getString("ChartReportItemImpl.log.CannotSetState"));
            }
        } else if (propName.equals("script") || propName.equals("onRender")) {
            this.cm.setScript((String)value);
        } else if (propName.equals("chart.instance")) {
            this.cm = (Chart)value;
        }
    }

    protected void checkScriptSyntax(String string) throws RhinoException {
        if (string == null) {
            return;
        }
        if (!this.isJavaClassName(string)) {
            try {
                Context cx = Context.enter();
                cx.compileString(string, "chartScript", 1, null);
            }
            finally {
                Context.exit();
            }
        }
    }

    protected boolean isJavaClassName(String string) {
        return string.matches("\\w+(\\.\\w*)*");
    }

    public List validate() {
        logger.log(1, Messages.getString("ChartReportItemImpl.log.validate"));
        ArrayList<ExtendedElementException> list = new ArrayList<ExtendedElementException>();
        if (this.cm != null) {
            try {
                this.checkScriptSyntax(this.cm.getScript());
            }
            catch (RhinoException e) {
                logger.log((Exception)((Object)e));
                ExtendedElementException extendedException = new ExtendedElementException(this.getHandle().getElement(), "org.eclipse.birt.chart.reportitem", "exception.script.syntaxError", new Object[]{e.getLocalizedMessage()}, Messages.getResourceBundle());
                extendedException.setProperty("lineNo", (Object)String.valueOf(e.lineNumber()));
                extendedException.setProperty("sub_editor", (Object)"script");
                list.add(extendedException);
            }
        }
        return list;
    }

    public final org.eclipse.birt.report.model.api.extension.IReportItem copy() {
        ChartReportItemImpl crii = new ChartReportItemImpl(this.handle);
        crii.bCopied = true;
        if (!ChartXTabUtil.isAxisChart((DesignElementHandle)this.handle)) {
            crii.cm = this.cm == null ? null : (Chart)EcoreUtil.copy((EObject)this.cm);
        }
        return crii;
    }

    public boolean refreshPropertyDefinition() {
        return false;
    }

    public List getRowExpressions() {
        try {
            boolean needChangeValueExpr = true;
            if (this.handle.getDataBindingReference() != null || this.handle.getContainer() instanceof MultiViewsHandle) {
                needChangeValueExpr = false;
            }
            return Generator.instance().getRowExpressions(this.cm, (IActionEvaluator)new BIRTActionEvaluator(), needChangeValueExpr);
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
            return null;
        }
    }

    public void updateRowExpressions(Map newExpressions) {
        CompatibleExpressionUpdater.update(this.cm, newExpressions);
    }

    public IReportItem getSimpleElement() {
        try {
            if (this.cm instanceof ChartWithAxes) {
                return new ChartWithAxesImpl(this.handle, (ChartWithAxes)this.cm);
            }
            if (this.cm instanceof ChartWithoutAxes) {
                return new ChartWithoutAxesImpl(this.handle, (ChartWithoutAxes)this.cm);
            }
            return null;
        }
        catch (Exception e) {
            logger.log(e);
            return null;
        }
    }

    public boolean isCopied() {
        return this.bCopied;
    }

    public URL findResource(String fileName) {
        if (this.handle != null) {
            return this.handle.getModule().findResource(fileName, 0);
        }
        return null;
    }

    public String externalizedMessage(String sKey, String sDefaultValue, ULocale locale) {
        return ModuleUtil.getExternalizedValue((DesignElementHandle)this.handle, (String)sKey, (String)sDefaultValue, (ULocale)locale);
    }

    public boolean canExport() {
        return !(this.handle.getContainer() instanceof MultiViewsHandle) && !ChartXTabUtil.isPlotChart((DesignElementHandle)this.handle) && !ChartXTabUtil.isAxisChart((DesignElementHandle)this.handle);
    }

    public boolean isLayoutDirectionRTL() {
        if (this.handle.getContainer() == null) {
            return false;
        }
        return this.handle.getContainer().isDirectionRTL();
    }
}

