/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationBase;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ChartReportItemPresentationAxisImpl
extends ChartReportItemPresentationBase {
    public void setModelObject(ExtendedItemHandle eih) {
        this.handle = (ExtendedItemHandle)eih.getElementProperty("hostChart");
        IReportItem item = this.getReportItem(this.handle);
        if (item == null) {
            return;
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.setChartModelObject(item);
    }

    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = (Bounds)EcoreUtil.copy((EObject)originalBounds);
        if (this.cm instanceof ChartWithAxes) {
            ChartWithAxes chart = (ChartWithAxes)this.cm;
            if (chart.isTransposed()) {
                bounds.setHeight(0.0);
            } else {
                bounds.setWidth(0.0);
            }
        }
        return bounds;
    }

    protected void updateChartModel() {
        ChartXTabUtil.updateModelToRenderAxis(this.cm, this.rtc.isRightToLeft());
    }

    protected IDataRowExpressionEvaluator createEvaluator(IBaseResultSet set) throws ChartException {
        ChartWithAxes cwa;
        Axis yAxis;
        if (this.rtc.getScale() == null || !this.rtc.getScale().isShared()) {
            return super.createEvaluator(set);
        }
        final boolean bDatetypeAxis = this.cm instanceof ChartWithAxes ? (yAxis = (cwa = (ChartWithAxes)this.cm).getOrthogonalAxes(cwa.getBaseAxes()[0], true)[0]).getType() == AxisType.DATE_TIME_LITERAL : false;
        return new IDataRowExpressionEvaluator(){
            private int count = 1;

            public void close() {
            }

            public Object evaluate(String expression) {
                return bDatetypeAxis ? Calendar.getInstance() : new Integer(1);
            }

            public Object evaluateGlobal(String expression) {
                return this.evaluate(expression);
            }

            public boolean first() {
                return true;
            }

            public boolean next() {
                return this.count-- > 0;
            }
        };
    }
}

