/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.computation.withaxes.ScaleContext;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.reportitem.BIRTActionEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTActionRenderer;
import org.eclipse.birt.chart.reportitem.BIRTChartXtabResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTExternalContext;
import org.eclipse.birt.chart.reportitem.BIRTGroupedQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTMessageLookup;
import org.eclipse.birt.chart.reportitem.BIRTQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BIRTScriptClassLoader;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.ChartXTabUtil;
import org.eclipse.birt.chart.reportitem.SharedCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.ChartScriptContext;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.ReportItemPresentationBase;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.mozilla.javascript.EvaluatorException;

public class ChartReportItemPresentationBase
extends ReportItemPresentationBase {
    protected InputStream fis = null;
    protected String imageMap = null;
    protected String sExtension = null;
    private String sSupportedFormats = null;
    private String outputFormat = null;
    private int outputType = -1;
    protected Chart cm = null;
    protected IDeviceRenderer idr = null;
    protected ExtendedItemHandle handle;
    protected RunTimeContext rtc = null;
    private static List<String> registeredDevices = null;
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private Bounds boundsRuntime = null;

    static {
        registeredDevices = new ArrayList<String>();
        try {
            String[][] formats = PluginSettings.instance().getRegisteredOutputFormats();
            int i = 0;
            while (i < formats.length) {
                registeredDevices.add(formats[i][0]);
                ++i;
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
    }

    private boolean isOutputRendererSupported(String format) {
        if (format != null && this.sSupportedFormats != null && this.sSupportedFormats.indexOf(format) != -1) {
            return registeredDevices.contains(format);
        }
        return false;
    }

    private String getFirstSupportedFormat(String formats) {
        if (formats != null && formats.length() > 0) {
            int idx = formats.indexOf(59);
            if (idx == -1) {
                if (this.isOutputRendererSupported(formats)) {
                    return formats;
                }
            } else {
                String ext = formats.substring(0, idx);
                if (this.isOutputRendererSupported(ext)) {
                    return ext;
                }
                return this.getFirstSupportedFormat(formats.substring(idx + 1));
            }
        }
        return "PNG";
    }

    public void setModelObject(ExtendedItemHandle eih) {
        IReportItem item = this.getReportItem(eih);
        if (item == null) {
            return;
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        this.handle = eih;
        this.setChartModelObject(item);
    }

    protected void setChartModelObject(IReportItem item) {
        Object of = this.handle.getProperty("outputFormat");
        if (of instanceof String) {
            this.outputFormat = (String)of;
        }
        if ((of = item.getProperty("chart.scale")) instanceof ScaleContext) {
            if (this.rtc == null) {
                this.rtc = new RunTimeContext();
            }
            this.rtc.setScale((ScaleContext)of);
        }
    }

    protected IReportItem getReportItem(ExtendedItemHandle eih) {
        IReportItem item = null;
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log((Exception)((Object)e));
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log((Exception)((Object)eeex));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
            }
        }
        return item;
    }

    public final void setLocale(Locale lcl) {
        if (this.rtc == null) {
            this.rtc = new RunTimeContext();
        }
        this.rtc.setLocale(lcl);
    }

    public void setOutputFormat(String sOutputFormat) {
        this.sExtension = sOutputFormat.equalsIgnoreCase("HTML") ? (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : (this.outputFormat != null && this.outputFormat.toUpperCase().equals("GIF") && this.isOutputRendererSupported("PNG") ? "PNG" : (this.isOutputRendererSupported("SVG") ? "SVG" : this.getFirstSupportedFormat(this.sSupportedFormats)))) : (sOutputFormat.equalsIgnoreCase("PDF") ? (this.outputFormat != null && this.outputFormat.toUpperCase().equals("SVG") ? "PNG" : (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : (this.isOutputRendererSupported("PNG") ? "PNG" : this.getFirstSupportedFormat(this.sSupportedFormats)))) : (this.isOutputRendererSupported(this.outputFormat) ? this.outputFormat : this.getFirstSupportedFormat(this.sSupportedFormats)));
    }

    public void setSupportedImageFormats(String sSupportedFormats) {
        this.sSupportedFormats = sSupportedFormats;
    }

    public void deserialize(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if ("org.eclipse.birt.chart.internal.script.ChartScriptContext".equals(desc.getName())) {
                        return ChartScriptContext.class;
                    }
                    return super.resolveClass(desc);
                }
            };
            Object o = SecurityUtil.readObject((ObjectInputStream)ois);
            if (o instanceof RunTimeContext) {
                Object oMaxRow;
                RunTimeContext drtc = (RunTimeContext)o;
                if (this.rtc != null) {
                    drtc.setULocale(this.rtc.getULocale());
                    drtc.setScale(this.rtc.getScale());
                }
                this.rtc = drtc;
                if (this.cm != null && this.handle != null) {
                    IReportItem item = this.handle.getReportItem();
                    ((ChartReportItemImpl)item).setModel(this.cm);
                    ((ChartReportItemImpl)item).setScale(this.rtc.getScale());
                }
                if ((oMaxRow = this.context.getAppContext().get("EXTENDED_ITEM_MAX_ROW")) != null) {
                    this.rtc.putState((Object)"CHART_MAX_ROW", oMaxRow);
                } else {
                    oMaxRow = this.context.getGlobalVariable("EXTENDED_ITEM_MAX_ROW");
                    if (oMaxRow != null) {
                        this.rtc.putState((Object)"CHART_MAX_ROW", oMaxRow);
                    }
                }
            }
            ois.close();
        }
        catch (Exception e) {
            logger.log(e);
        }
    }

    public int getOutputType() {
        if (this.outputType == -1) {
            this.outputType = "SVG".equals(this.sExtension) || "SWF".equals(this.sExtension) ? 1 : 6;
        }
        return this.outputType;
    }

    public String getImageMIMEType() {
        if (this.idr == null) {
            return null;
        }
        return this.idr.getMimeType();
    }

    public Object getOutputContent() {
        return null;
    }

    public void finish() {
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.finishStart"));
        try {
            this.imageMap = null;
            if (this.fis != null) {
                this.fis.close();
                this.fis = null;
            }
        }
        catch (IOException ioex) {
            logger.log((Exception)ioex);
        }
        if (this.idr != null) {
            this.idr.dispose();
            this.idr = null;
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.finishEnd"));
    }

    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = (Bounds)EcoreUtil.copy((EObject)originalBounds);
        return bounds;
    }

    protected IDataRowExpressionEvaluator createEvaluator(IBaseResultSet set) throws ChartException {
        if (set instanceof IQueryResultSet) {
            if (ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.handle, this.cm)) {
                return new BIRTQueryResultSetEvaluator((IQueryResultSet)set);
            }
            if (ChartReportItemUtil.isGroupingDefined(this.cm) || ChartReportItemUtil.hasAggregation(this.cm)) {
                return new BIRTGroupedQueryResultSetEvaluator((IQueryResultSet)set, ChartReportItemUtil.isSetSummaryAggregation(this.cm), this.isSubQuery(), this.cm, this.handle);
            }
            return new BIRTQueryResultSetEvaluator((IQueryResultSet)set);
        }
        if (set instanceof ICubeResultSet) {
            if (ChartXTabUtil.isPlotChart((DesignElementHandle)this.handle) || ChartXTabUtil.isAxisChart((DesignElementHandle)this.handle)) {
                return new BIRTChartXtabResultSetEvaluator((ICubeResultSet)set, this.handle);
            }
            ReportItemHandle itemHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.handle);
            boolean isChartCubeReference = ChartReportItemUtil.isChartReportItemHandle(itemHandle);
            if (itemHandle != null && !isChartCubeReference) {
                return new SharedCubeResultSetEvaluator((ICubeResultSet)set, this.cm);
            }
            return new BIRTCubeResultSetEvaluator((ICubeResultSet)set);
        }
        return null;
    }

    private boolean isSubQuery() {
        return this.handle.getDataSet() == null;
    }

    protected ScaleContext createSharedScale(IBaseResultSet baseResultSet) throws BirtException {
        if (baseResultSet instanceof IQueryResultSet) {
            Object min = baseResultSet.evaluate("row._outer[\"chart__min\"]");
            Object max = baseResultSet.evaluate("row._outer[\"chart__max\"]");
            return ScaleContext.createSimpleScale((Object)min, (Object)max);
        }
        if (baseResultSet instanceof CubeResultSet) {
            try {
                List edgeCursors = ((CubeResultSet)baseResultSet).getCubeCursor().getOrdinateEdge();
                for (EdgeCursor edge : edgeCursors) {
                    edge.first();
                }
                Axis xAxis = (Axis)((ChartWithAxes)this.cm).getAxes().get(0);
                SeriesDefinition sdValue = (SeriesDefinition)((ChartWithAxes)this.cm).getOrthogonalAxes(xAxis, true)[0].getSeriesDefinitions().get(0);
                Query queryValue = (Query)sdValue.getDesignTimeSeries().getDataDefinition().get(0);
                String bindingValue = ChartXTabUtil.getBindingName(queryValue.getDefinition(), false);
                String maxBindingName = "chart__max" + bindingValue;
                String minBindingName = "chart__min" + bindingValue;
                Object min = baseResultSet.evaluate(ExpressionUtil.createJSDataExpression((String)minBindingName));
                Object max = baseResultSet.evaluate(ExpressionUtil.createJSDataExpression((String)maxBindingName));
                if (min != null && max != null) {
                    return ScaleContext.createSimpleScale((Object)min, (Object)max);
                }
            }
            catch (OLAPException e) {
                logger.log((Exception)((Object)e));
            }
            catch (BirtException birtException) {
            }
            catch (EvaluatorException evaluatorException) {}
        }
        return null;
    }

    public Size getSize() {
        if (this.boundsRuntime != null) {
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeStart"));
            Size sz = new Size();
            sz.setWidth((float)this.boundsRuntime.getWidth());
            sz.setHeight((float)this.boundsRuntime.getHeight());
            sz.setUnit("pt");
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.getSizeEnd"));
            return sz;
        }
        return super.getSize();
    }

    public Object onRowSets(IBaseResultSet[] baseResultSet) throws BirtException {
        IBaseResultSet resultSet = this.getDataToRender(baseResultSet);
        if (resultSet == null) {
            return new Object[]{new byte[1]};
        }
        if (ChartReportItemUtil.isEmpty(resultSet)) {
            return null;
        }
        Bounds bo = this.cm.getBlock().getBounds();
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return null;
        }
        try {
            if (this.rtc.getScale() == null && ChartReportItemUtil.canScaleShared((ReportItemHandle)this.handle, this.cm)) {
                this.rtc.setScale(this.createSharedScale(resultSet));
            }
            boolean isSharingQuery = false;
            if (this.handle.getDataBindingReference() != null || this.handle.getContainer() instanceof MultiViewsHandle) {
                isSharingQuery = true;
            }
            this.rtc.setSharingQuery(isSharingQuery);
            BIRTExternalContext externalContext = new BIRTExternalContext(this.context);
            if (this.rtc.getScriptContext() != null && this.rtc.getScriptContext() instanceof ChartScriptContext) {
                ((ChartScriptContext)this.rtc.getScriptContext()).setExternalContext((IExternalContext)externalContext);
            }
            this.initializeScriptHandler(externalContext);
            IDataRowExpressionEvaluator rowAdapter = this.createEvaluator(resultSet);
            BIRTActionEvaluator evaluator = new BIRTActionEvaluator();
            Generator.instance().bindData(rowAdapter, (IActionEvaluator)evaluator, this.cm, this.rtc);
            this.prepareDeviceRenderer();
            GeneratedChartState gcs = this.buildChart(rowAdapter, externalContext);
            this.renderToImageFile(gcs);
            rowAdapter.close();
            if (this.rtc.getScale() != null && !this.rtc.getScale().isShared()) {
                this.rtc.getScale().setShared(true);
                ((ChartReportItemImpl)this.getReportItem(this.handle)).setScale(this.rtc.getScale());
            }
            return this.getImageToDisplay();
        }
        catch (BirtException birtException) {
            if (this.isNoDataException(birtException)) {
                return null;
            }
            throw birtException;
        }
        catch (RuntimeException ex) {
            logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
            logger.log((Exception)ex);
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ex);
        }
    }

    private IBaseResultSet getDataToRender(IBaseResultSet[] baseResultSet) throws BirtException {
        if (baseResultSet == null || baseResultSet.length < 1) {
            logger.log(1, Messages.getString("ChartReportItemPresentationImpl.error.NoData"));
            return null;
        }
        IBaseResultSet resultSet = baseResultSet[0];
        if (resultSet == null) {
            return null;
        }
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsStart"));
        if (this.handle == null) {
            assert (false);
            return null;
        }
        return resultSet;
    }

    private void initializeScriptHandler(BIRTExternalContext externalContext) throws ChartException {
        String javaHandlerClass = this.handle.getEventHandlerClass();
        if (javaHandlerClass != null && javaHandlerClass.length() > 0) {
            this.cm.setScript(javaHandlerClass);
        }
        this.rtc.setScriptClassLoader((IScriptClassLoader)new BIRTScriptClassLoader(this.appClassLoader));
        ScriptHandler sh = this.rtc.getScriptHandler();
        if (sh == null) {
            sh = new ScriptHandler();
            this.rtc.setScriptHandler(sh);
            sh.setScriptClassLoader(this.rtc.getScriptClassLoader());
            sh.setScriptContext(this.rtc.getScriptContext());
            String sScriptContent = this.cm.getScript();
            if (externalContext != null && externalContext.getScriptable() != null) {
                sh.init(externalContext.getScriptable());
            } else {
                sh.init(null);
            }
            sh.setRunTimeModel(this.cm);
            if (sScriptContent != null && sScriptContent.length() > 0 && this.rtc.isScriptingEnabled()) {
                sh.register(ModuleUtil.getScriptUID((Object)this.handle.getPropertyHandle("onRender")), sScriptContent);
            }
        }
    }

    protected GeneratedChartState buildChart(IDataRowExpressionEvaluator rowAdapter, BIRTExternalContext externalContext) throws ChartException {
        Bounds bo = this.computeBounds();
        this.initializeRuntimeContext(rowAdapter);
        this.updateChartModel();
        GeneratedChartState gcs = Generator.instance().build(this.idr.getDisplayServer(), this.cm, bo, (IExternalContext)externalContext, this.rtc, (IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)this.handle, true, this.style));
        this.boundsRuntime = gcs.getChartModel().getBlock().getBounds();
        return gcs;
    }

    protected Object getImageToDisplay() {
        if (this.getOutputType() == 1) {
            return this.fis;
        }
        if (this.getOutputType() == 6) {
            return new Object[]{this.fis, this.imageMap};
        }
        throw new IllegalArgumentException();
    }

    protected void renderToImageFile(GeneratedChartState gcs) throws ChartException {
        logger.log(1, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsRendering"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        this.idr.setProperty("device.file.identifier", (Object)bos);
        this.idr.setProperty("device.component", (Object)new EmptyUpdateNotifier(this.cm, gcs.getChartModel()));
        Generator.instance().render(this.idr, gcs);
        try {
            bos.close();
            this.fis = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception ioex) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)ioex);
        }
        if (this.getOutputType() == 6) {
            this.imageMap = ((IImageMapEmitter)this.idr).getImageMap();
        }
    }

    private boolean isNoDataException(BirtException birtException) {
        Throwable ex = birtException;
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 16) {
            return true;
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 20) {
            return true;
        }
        if (ex instanceof ChartException && ((ChartException)ex).getType() == 18) {
            logger.log((Exception)((Object)birtException));
            return true;
        }
        logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.onRowSetsFailed"));
        logger.log((Exception)((Object)birtException));
        return false;
    }

    private void initializeRuntimeContext(IDataRowExpressionEvaluator rowAdapter) {
        this.rtc.setActionRenderer((IActionRenderer)new BIRTActionRenderer((DesignElementHandle)this.handle, this.ah, rowAdapter, this.context));
        this.rtc.setMessageLookup((IMessageLookup)new BIRTMessageLookup(this.context));
        this.rtc.setRightToLeftText(this.handle.isDirectionRTL());
        ChartReportItemImpl crii = (ChartReportItemImpl)this.getReportItem(this.handle);
        this.rtc.setRightToLeft(crii.isLayoutDirectionRTL());
        this.rtc.setResourceFinder((IResourceFinder)crii);
        this.rtc.setExternalizer((IExternalizer)crii);
    }

    protected void prepareDeviceRenderer() throws ChartException {
        this.idr = ChartEngine.instance().getRenderer("dv." + this.sExtension.toUpperCase(Locale.US));
        this.idr.setProperty("device.resolution", (Object)new Integer(this.dpi));
        if ("SVG".equalsIgnoreCase(this.sExtension)) {
            this.idr.setProperty("resize.svg", (Object)Boolean.TRUE);
        }
    }

    protected void updateChartModel() {
    }
}

