/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import javax.olap.cursor.RowDataNavigation;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedCubeResultSetEvaluator
extends BIRTCubeResultSetEvaluator {
    private int fRowInnerLevelIndex;
    private int fColInnerLevelIndex;
    private CursorPositionNode fMainPositionNodes;
    private CursorPositionNode fSubPositionNodes;
    private boolean fIsColEdgeAsMainCursor;

    public SharedCubeResultSetEvaluator(ICubeResultSet rs, Chart cm) {
        super(rs);
        this.parseLevelIndex(rs.getCubeQuery(), cm);
    }

    public SharedCubeResultSetEvaluator(ICubeQueryResults qr, IBaseCubeQueryDefinition queryDefinition, Chart cm) {
        super(qr);
        this.parseLevelIndex(queryDefinition, cm);
    }

    private void parseLevelIndex(IBaseCubeQueryDefinition queryDefintion, Chart cm) {
        this.fRowInnerLevelIndex = -1;
        this.fColInnerLevelIndex = -1;
        if (queryDefintion instanceof ICubeQueryDefinition) {
            List rowLevelNames = Collections.EMPTY_LIST;
            List colLevelNames = Collections.EMPTY_LIST;
            String[] categoryExprs = ChartUtil.getCategoryExpressions((Chart)cm);
            ICubeQueryDefinition cqd = (ICubeQueryDefinition)queryDefintion;
            IEdgeDefinition rowED = cqd.getEdge(1);
            IEdgeDefinition colED = cqd.getEdge(2);
            if (rowED != null) {
                rowLevelNames = this.getLevelNames(rowED);
                if (categoryExprs != null && categoryExprs.length > 0) {
                    this.fRowInnerLevelIndex = this.findInnerLevelIndex(categoryExprs[0], rowLevelNames);
                    if (this.fRowInnerLevelIndex < 0 && colED != null) {
                        rowLevelNames = this.getLevelNames(colED);
                        this.fRowInnerLevelIndex = this.findInnerLevelIndex(categoryExprs[0], rowLevelNames);
                        this.fIsColEdgeAsMainCursor = true;
                        return;
                    }
                }
            }
            if (colED != null) {
                if (rowED == null && this.fRowInnerLevelIndex < 0) {
                    rowLevelNames = this.getLevelNames(colED);
                    if (categoryExprs != null && categoryExprs.length > 0) {
                        this.fRowInnerLevelIndex = this.findInnerLevelIndex(categoryExprs[0], rowLevelNames);
                        this.fIsColEdgeAsMainCursor = true;
                    }
                } else {
                    colLevelNames = this.getLevelNames(colED);
                    String[] yOptionalExprs = ChartUtil.getYOptoinalExpressions((Chart)cm);
                    if (yOptionalExprs != null && yOptionalExprs.length > 0) {
                        this.fColInnerLevelIndex = this.findInnerLevelIndex(yOptionalExprs[0], colLevelNames);
                    }
                }
            }
        }
    }

    private int findInnerLevelIndex(String expr, List<String> levelNames) {
        List bindings;
        int index = -1;
        if (ChartUtil.isEmpty((String)expr)) {
            return index;
        }
        try {
            bindings = ExpressionUtil.extractColumnExpressions((String)expr, (String)"data");
        }
        catch (BirtException birtException) {
            return index;
        }
        for (IColumnBinding bind : bindings) {
            String name = bind.getResultSetColumnName();
            int levelIndex = levelNames.indexOf(name);
            if (levelIndex <= index) continue;
            index = levelIndex;
        }
        return index;
    }

    private List getLevelNames(IEdgeDefinition ed) {
        ArrayList<String> levelNames = new ArrayList<String>();
        List dimensions = ed.getDimensions();
        for (IDimensionDefinition d : dimensions) {
            List hieDefs = d.getHierarchy();
            for (IHierarchyDefinition hd : hieDefs) {
                List levels = hd.getLevels();
                for (ILevelDefinition ld : levels) {
                    levelNames.add(ld.getName());
                }
            }
        }
        return levelNames;
    }

    @Override
    protected void initCubeCursor() throws OLAPException, BirtException {
        List dimCursors;
        if (this.cubeCursor == null) {
            this.cubeCursor = this.rs != null ? (ICubeCursor)this.rs.getCubeCursor() : this.qr.getCubeCursor();
            List edges = this.cubeCursor.getOrdinateEdge();
            if (edges.size() == 0) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, Messages.getString("exception.no.cube.edge"));
            }
            if (edges.size() == 1) {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = null;
            } else {
                this.mainEdgeCursor = (EdgeCursor)edges.get(0);
                this.subEdgeCursor = (EdgeCursor)edges.get(1);
            }
        }
        if (this.fRowInnerLevelIndex >= 0 && this.fColInnerLevelIndex < 0 && this.subEdgeCursor != null) {
            if (!this.fIsColEdgeAsMainCursor) {
                this.mainEdgeCursor = this.subEdgeCursor;
            }
            this.subEdgeCursor = null;
        }
        if (this.subEdgeCursor == null) {
            dimCursors = this.mainEdgeCursor.getDimensionCursor();
            if (this.fRowInnerLevelIndex >= 0) {
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fRowInnerLevelIndex);
            } else if (this.fColInnerLevelIndex >= 0) {
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fColInnerLevelIndex);
            }
        } else {
            if (this.fRowInnerLevelIndex >= 0) {
                dimCursors = this.subEdgeCursor.getDimensionCursor();
                this.fSubPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fRowInnerLevelIndex);
            }
            if (this.fColInnerLevelIndex >= 0) {
                dimCursors = this.mainEdgeCursor.getDimensionCursor();
                this.fMainPositionNodes = this.initCursorPositionsNodes(dimCursors, this.fColInnerLevelIndex);
            }
        }
    }

    private CursorPositionNode initCursorPositionsNodes(List dimCursorList, int innerLevelIndex) {
        CursorPositionNode pn = null;
        CursorPositionNode rootPN = null;
        int i = innerLevelIndex;
        while (i >= 0) {
            if (pn == null) {
                rootPN = pn = new CursorPositionNode((RowDataNavigation)dimCursorList.get(i));
            } else {
                pn.setParentNode(new CursorPositionNode((RowDataNavigation)dimCursorList.get(i)));
                pn = pn.getParentNode();
            }
            --i;
        }
        return rootPN;
    }

    @Override
    public boolean next() {
        block9: {
            boolean hasNext;
            block10: {
                ++this.iIndex;
                if (this.subEdgeCursor == null) break block9;
                hasNext = false;
                while (hasNext = this.subEdgeCursor.next()) {
                    if (this.fSubPositionNodes.positionIsChanged()) break;
                }
                this.fSubPositionNodes.updatePosition();
                if (!hasNext) break block10;
                return true;
            }
            this.lstBreaks.add(new Integer(this.iIndex));
            this.subEdgeCursor.first();
            this.fSubPositionNodes.updatePosition();
            hasNext = false;
            while (hasNext = this.mainEdgeCursor.next()) {
                if (this.fMainPositionNodes.positionIsChanged()) break;
            }
            this.fMainPositionNodes.updatePosition();
            if (hasNext) {
                return true;
            }
        }
        try {
            boolean hasNext = false;
            while (hasNext = this.mainEdgeCursor.next()) {
                if (this.fMainPositionNodes.positionIsChanged()) break;
            }
            this.fMainPositionNodes.updatePosition();
            if (hasNext) {
                return true;
            }
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    @Override
    public boolean first() {
        try {
            this.initCubeCursor();
            this.mainEdgeCursor.first();
            this.fMainPositionNodes.updatePosition();
            if (this.subEdgeCursor != null) {
                this.subEdgeCursor.first();
                this.fSubPositionNodes.updatePosition();
            } else {
                this.bWithoutSub = true;
            }
            return true;
        }
        catch (OLAPException e) {
            logger.log((Exception)((Object)e));
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
        }
        return false;
    }

    class CursorPositionNode {
        private RowDataNavigation fCursor;
        private CursorPositionNode fParentNode;
        private long fPosition = -1L;

        public CursorPositionNode getParentNode() {
            return this.fParentNode;
        }

        void setParentNode(CursorPositionNode parentNode) {
            this.fParentNode = parentNode;
        }

        CursorPositionNode(RowDataNavigation cursor) {
            this.fCursor = cursor;
        }

        long getPosition() {
            return this.fPosition;
        }

        void updatePosition() throws OLAPException {
            this.fPosition = this.fCursor.getPosition();
            if (this.fParentNode != null) {
                this.fParentNode.updatePosition();
            }
        }

        boolean positionIsChanged() throws OLAPException {
            if (this.fPosition != this.fCursor.getPosition()) {
                return true;
            }
            if (this.fCursor.getPosition() == 0L && this.fParentNode != null) {
                return this.fParentNode.positionIsChanged();
            }
            return false;
        }
    }
}

