/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal.component;

import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.BubbleSeries;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.script.api.component.IValueSeries;
import org.eclipse.birt.chart.script.internal.component.SeriesImpl;
import org.eclipse.birt.chart.script.internal.series.AreaImpl;
import org.eclipse.birt.chart.script.internal.series.BarImpl;
import org.eclipse.birt.chart.script.internal.series.BubbleImpl;
import org.eclipse.birt.chart.script.internal.series.DifferenceImpl;
import org.eclipse.birt.chart.script.internal.series.GanttImpl;
import org.eclipse.birt.chart.script.internal.series.LineImpl;
import org.eclipse.birt.chart.script.internal.series.MeterImpl;
import org.eclipse.birt.chart.script.internal.series.PieImpl;
import org.eclipse.birt.chart.script.internal.series.ScatterImpl;
import org.eclipse.birt.chart.script.internal.series.StockImpl;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.simpleapi.IAction;
import org.eclipse.emf.common.util.EList;

public abstract class ValueSeriesImpl
extends SeriesImpl
implements IValueSeries {
    protected ValueSeriesImpl(SeriesDefinition sd, Chart cm) {
        super(sd, cm);
    }

    public String getTitle() {
        return (String)this.series.getSeriesIdentifier();
    }

    public boolean isVisible() {
        return this.series.isVisible();
    }

    public void setTitle(String title) {
        this.series.setSeriesIdentifier((Object)title);
    }

    public void setVisible(boolean visible) {
        this.series.setVisible(visible);
    }

    public IAction getAction() {
        EList triggers = this.series.getTriggers();
        Action chartAction = null;
        int i = 0;
        while (i < triggers.size()) {
            chartAction = ((Trigger)triggers.get(i)).getAction();
            if (ActionType.URL_REDIRECT_LITERAL.equals(chartAction.getType())) {
                ActionHandle action;
                URLValue uv = (URLValue)chartAction.getValue();
                String sa = uv.getBaseUrl();
                try {
                    action = ModuleUtil.deserializeAction((String)sa);
                }
                catch (DesignFileException e) {
                    Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace").log((Exception)((Object)e));
                    return null;
                }
                return new IAction(){

                    public String getFormatType() {
                        return action.getFormatType();
                    }

                    public String getLinkType() {
                        return action.getLinkType();
                    }

                    public String getReportName() {
                        return action.getReportName();
                    }

                    public String getTargetBookmark() {
                        return action.getTargetBookmark();
                    }

                    public String getTargetWindow() {
                        return action.getTargetWindow();
                    }

                    public String getURI() {
                        return action.getURI();
                    }

                    public void setFormatType(String type) throws SemanticException {
                        action.setFormatType(type);
                    }

                    public void setLinkType(String type) throws SemanticException {
                        action.setLinkType(type);
                    }

                    public void setReportName(String reportName) throws SemanticException {
                        action.setReportName(reportName);
                    }

                    public void setTargetBookmark(String bookmark) throws SemanticException {
                        action.setTargetBookmark(bookmark);
                    }

                    public void setTargetWindow(String window) throws SemanticException {
                        action.setTargetWindow(window);
                    }

                    public void setURI(String uri) throws SemanticException {
                        action.setURI(uri);
                    }
                };
            }
            ++i;
        }
        return null;
    }

    protected SeriesGrouping getBaseGrouping() {
        SeriesGrouping grouping = null;
        if (this.cm instanceof ChartWithAxes) {
            Axis bAxis = (Axis)((ChartWithAxes)this.cm).getAxes().get(0);
            SeriesDefinition bSd = (SeriesDefinition)bAxis.getSeriesDefinitions().get(0);
            grouping = bSd.getGrouping();
        }
        if (this.cm instanceof ChartWithoutAxes) {
            SeriesDefinition bSd = (SeriesDefinition)((ChartWithoutAxes)this.cm).getSeriesDefinitions().get(0);
            grouping = bSd.getGrouping();
        }
        return grouping;
    }

    public String getAggregateExpr() {
        String expr = "";
        SeriesGrouping baseGrouping = this.getBaseGrouping();
        if (baseGrouping.isEnabled()) {
            if (this.sd.getGrouping().isEnabled()) {
                expr = this.sd.getGrouping().getAggregateExpression();
            }
            if (expr.trim().length() == 0) {
                return baseGrouping.getAggregateExpression();
            }
        }
        return expr;
    }

    public void setAggregateExpr(String aggregateExpr) {
        SeriesGrouping baseGrouping = this.getBaseGrouping();
        if (aggregateExpr == null) {
            this.sd.getGrouping().setEnabled(false);
            this.sd.getGrouping().setAggregateExpression("");
            baseGrouping.setEnabled(false);
        } else {
            this.sd.getGrouping().setEnabled(true);
            this.sd.getGrouping().setAggregateExpression(aggregateExpr);
            baseGrouping.setEnabled(true);
        }
    }

    protected Axis getAxis() {
        if (this.cm instanceof ChartWithAxes && this.sd.eContainer() instanceof Axis) {
            return (Axis)this.sd.eContainer();
        }
        return null;
    }

    public boolean isPercent() {
        Axis axis = this.getAxis();
        if (axis != null) {
            return axis.isPercent();
        }
        return false;
    }

    public void setPercent(boolean percent) {
        Axis axis = this.getAxis();
        if (axis != null) {
            axis.setPercent(percent);
        }
    }

    public static IValueSeries createValueSeries(SeriesDefinition sd, Chart cm) {
        Series series = sd.getDesignTimeSeries();
        if (series instanceof BarSeries) {
            return new BarImpl(sd, cm);
        }
        if (series instanceof DifferenceSeries) {
            return new DifferenceImpl(sd, cm);
        }
        if (series instanceof BubbleSeries) {
            return new BubbleImpl(sd, cm);
        }
        if (series instanceof AreaSeries) {
            return new AreaImpl(sd, cm);
        }
        if (series instanceof ScatterSeries) {
            return new ScatterImpl(sd, cm);
        }
        if (series instanceof LineSeries) {
            return new LineImpl(sd, cm);
        }
        if (series instanceof StockSeries) {
            return new StockImpl(sd, cm);
        }
        if (series instanceof PieSeries) {
            return new PieImpl(sd, cm);
        }
        if (series instanceof DialSeries) {
            return new MeterImpl(sd, cm);
        }
        if (series instanceof GanttSeries) {
            return new GanttImpl(sd, cm);
        }
        return null;
    }
}

