/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.DefaultStatusHandler;
import org.eclipse.birt.report.engine.api.HTMLActionHandler;
import org.eclipse.birt.report.engine.api.HTMLCompleteImageHandler;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.IEngineConfig;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocumentLockManager;
import org.eclipse.birt.report.engine.api.IStatusHandler;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class EngineConfig
extends PlatformConfig
implements IEngineConfig {
    private Map<String, String> defaultEmitterIdsOfFormats = new HashMap<String, String>();

    public EngineConfig() {
        HTMLEmitterConfig emitterConfig = new HTMLEmitterConfig();
        emitterConfig.setActionHandler(new HTMLActionHandler());
        emitterConfig.setImageHandler(new HTMLCompleteImageHandler());
        this.getEmitterConfigs().put("html", emitterConfig);
    }

    public void setEngineHome(String birtHome) {
        this.setProperty("BIRT_HOME", birtHome);
    }

    public void setConfigurationVariable(String name, String value) {
        this.setProperty(name, value);
    }

    public HashMap getConfigMap() {
        return this.properties;
    }

    public void setLogConfig(String directoryName, Level level) {
        this.setProperty("logDest", directoryName);
        this.setProperty("logLevel", level);
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger can't be NULL");
        }
        this.setProperty("org.eclipse.birt.report.engine.logger", logger);
    }

    public Logger getLogger() {
        Object logger = this.getProperty("org.eclipse.birt.report.engine.logger");
        if (logger instanceof Logger) {
            return (Logger)logger;
        }
        return null;
    }

    public HashMap getScriptObjects() {
        return this.getAppContext();
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.getScriptObjects().put(jsName, obj);
    }

    public HashMap getAppContext() {
        HashMap appContext = (HashMap)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.scriptObjects");
        if (appContext == null) {
            appContext = new HashMap();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.scriptObjects", appContext);
        }
        return appContext;
    }

    public void setAppContext(HashMap appContext) {
        this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.scriptObjects", appContext);
    }

    public void setEmitterConfiguration(String format, Object emitterConfig) {
        if (emitterConfig instanceof HashMap) {
            this.getEmitterConfigs().put(format, new RenderOption((HashMap)emitterConfig));
        } else if (emitterConfig instanceof IRenderOption) {
            this.getEmitterConfigs().put(format, emitterConfig);
        } else {
            throw new IllegalArgumentException("the agr1 must be an instance of HashMap or IRenderOption");
        }
    }

    public HashMap getEmitterConfigs() {
        HashMap emitterConfigs = (HashMap)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.emitterConfigs");
        if (emitterConfigs == null) {
            emitterConfigs = new HashMap();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.emitterConfigs", emitterConfigs);
        }
        return emitterConfigs;
    }

    public IStatusHandler getStatusHandler() {
        IStatusHandler statusHandler = (IStatusHandler)this.getProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler");
        if (statusHandler == null) {
            statusHandler = new DefaultStatusHandler();
            this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler", statusHandler);
        }
        return statusHandler;
    }

    public void setStatusHandler(IStatusHandler handler) {
        this.setProperty("org.eclipse.birt.report.engine.api.EngineConfig.statusHandler", handler);
    }

    public Level getLogLevel() {
        Level level = (Level)this.getProperty("logLevel");
        return level;
    }

    public String getLogDirectory() {
        String logDestination = (String)this.getProperty("logDest");
        return logDestination;
    }

    public String getLogFile() {
        String logFile = (String)this.getProperty("logFile");
        return logFile;
    }

    public void setLogFile(String filename) {
        this.setProperty("logFile", filename);
    }

    public void setTempDir(String tmpDir) {
        this.setProperty("tmpDir", tmpDir);
    }

    public String getTempDir() {
        String tempDir = (String)this.getProperty("tmpDir");
        if (tempDir == null) {
            tempDir = FileUtil.getJavaTmpDir();
        }
        return tempDir;
    }

    public IReportDocumentLockManager getReportDocumentLockManager() {
        Object manager = this.getProperty("org.eclipse.birt.report.engine.api.IReportDocumentLockManager");
        if (manager instanceof IReportDocumentLockManager) {
            return (IReportDocumentLockManager)manager;
        }
        return null;
    }

    public void setReportDocumentLockManager(IReportDocumentLockManager manager) {
        this.setProperty("org.eclipse.birt.report.engine.api.IReportDocumentLockManager", manager);
    }

    public void setEngineContext(IPlatformContext context) {
        this.setPlatformContext(context);
    }

    public IPlatformContext getServletContext() {
        return this.getPlatformContext();
    }

    public IResourceLocator getResourceLocator() {
        Object locator = this.getProperty("resourceLocator");
        if (locator instanceof IResourceLocator) {
            return (IResourceLocator)locator;
        }
        return null;
    }

    public void setResourceLocator(IResourceLocator resourceLocator) {
        this.setProperty("resourceLocator", resourceLocator);
    }

    public String getResourcePath() {
        Object resourcePath = this.getProperty("resourcePath");
        if (resourcePath instanceof String) {
            return (String)resourcePath;
        }
        return null;
    }

    public void setResourcePath(String resourcePath) {
        this.setProperty("resourcePath", resourcePath);
    }

    public void setMaxRowsPerQuery(int maxRows) {
        this.setProperty("maxRowsPerQuery", new Integer(maxRows));
    }

    public int getMaxRowsPerQuery() {
        Object maxRows = this.getProperty("maxRowsPerQuery");
        if (maxRows instanceof Integer) {
            return (Integer)maxRows;
        }
        return 0;
    }

    public void setDefualtEmitter(String format, String emitterId) {
        this.defaultEmitterIdsOfFormats.put(format, emitterId);
    }

    public String getDefualtEmitter(String format) {
        return this.defaultEmitterIdsOfFormats.get(format);
    }

    public String toString() {
        String str = "EngineConfig: ";
        if (this.properties == null) {
            str = String.valueOf(str) + "null";
        } else {
            for (Map.Entry entry : this.properties.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                str = String.valueOf(str) + (key == null ? "<null>" : key.toString());
                str = String.valueOf(str) + "=";
                str = String.valueOf(str) + (value == null ? "<null>" : value.toString());
                str = String.valueOf(str) + ";";
            }
        }
        return str;
    }
}

