/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.CascadingParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ParameterDefnBase;
import org.eclipse.birt.report.engine.api.impl.ParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterHelper;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;

public class GetParameterDefinitionTask
extends EngineTask
implements IGetParameterDefinitionTask {
    protected Collection parameterDefns = null;
    protected static Logger log = Logger.getLogger(GetParameterDefinitionTask.class.getName());

    public GetParameterDefinitionTask(ReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 0);
    }

    public Collection getParameterDefns(boolean includeParameterGroups) {
        ReportDesignHandle handle = this.executionContext.getDesign();
        ArrayList original = this.getParameters(handle, includeParameterGroups);
        Iterator iter = original.iterator();
        this.parameterDefns = new ArrayList();
        while (iter.hasNext()) {
            ParameterDefnBase pBase = (ParameterDefnBase)iter.next();
            try {
                this.parameterDefns.add(pBase.clone());
            }
            catch (CloneNotSupportedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.parameterDefns != null) {
            ReportDesignHandle designHandle = this.executionContext.getDesign();
            for (IParameterDefnBase pBase : this.parameterDefns) {
                if (pBase instanceof ScalarParameterDefn) {
                    ((ScalarParameterDefn)pBase).setReportDesign(designHandle);
                    ((ScalarParameterDefn)pBase).setLocale(this.locale);
                    ((ScalarParameterDefn)pBase).evaluateSelectionList();
                    continue;
                }
                if (!(pBase instanceof ParameterGroupDefn)) continue;
                ((ParameterGroupDefn)pBase).setReportDesign(designHandle);
                for (IParameterDefnBase p : ((ParameterGroupDefn)pBase).getContents()) {
                    if (!(p instanceof ScalarParameterDefn)) continue;
                    ((ScalarParameterDefn)p).setReportDesign(designHandle);
                    ((ScalarParameterDefn)p).setLocale(this.locale);
                    ((ScalarParameterDefn)p).evaluateSelectionList();
                }
            }
        }
        return this.parameterDefns;
    }

    public void evaluateDefaults() throws EngineException {
    }

    public IParameterDefnBase getParameterDefn(String name) {
        IParameterDefnBase ret = null;
        if (name == null) {
            return ret;
        }
        ReportDesignHandle handle = this.executionContext.getDesign();
        ArrayList original = this.getParameters(handle, true);
        Iterator iter = original.iterator();
        while (iter.hasNext()) {
            ret = this.getParamDefnBaseByName((ParameterDefnBase)iter.next(), name);
            if (ret != null) break;
        }
        if (ret != null) {
            if (ret instanceof ScalarParameterDefn) {
                ((ScalarParameterDefn)ret).setReportDesign(handle);
                ((ScalarParameterDefn)ret).setLocale(this.locale);
                ((ScalarParameterDefn)ret).evaluateSelectionList();
            } else if (ret instanceof ParameterGroupDefn) {
                ((ParameterGroupDefn)ret).setReportDesign(handle);
                ((ParameterGroupDefn)ret).setLocale(this.locale);
                for (IParameterDefnBase p : ((ParameterGroupDefn)ret).getContents()) {
                    if (!(p instanceof ScalarParameterDefn)) continue;
                    ((ScalarParameterDefn)p).setReportDesign(handle);
                    ((ScalarParameterDefn)p).setLocale(this.locale);
                    ((ScalarParameterDefn)p).evaluateSelectionList();
                }
            }
        }
        return ret;
    }

    public SlotHandle getParameters() {
        ReportDesignHandle report = this.executionContext.getDesign();
        return report.getParameters();
    }

    public ParameterHandle getParameter(String name) {
        ReportDesignHandle report = this.executionContext.getDesign();
        return report.findParameter(name);
    }

    public HashMap getDefaultValues() {
        this.usingParameterValues();
        final HashMap values = new HashMap();
        new EngineTask.ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                String expr = param.getDefaultValue();
                String type = param.getDataType();
                Object value = GetParameterDefinitionTask.this.convertToType(expr, type);
                values.put(name, value);
                return true;
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object userData) {
                return this.visitParametersInGroup(group, userData);
            }
        }.visit(this.executionContext.getDesign());
        return values;
    }

    public Object getDefaultValue(IParameterDefnBase param) {
        return param == null ? null : this.getDefaultValue(param.getName());
    }

    public Object getDefaultValue(String name) {
        ReportDesignHandle report = this.executionContext.getDesign();
        ScalarParameterHandle parameter = (ScalarParameterHandle)report.findParameter(name);
        if (parameter == null) {
            return null;
        }
        this.usingParameterValues();
        String expr = parameter.getDefaultValue();
        String dataType = parameter.getDataType();
        if (expr == null || expr.length() == 0 && !"string".equals(dataType)) {
            return null;
        }
        return this.convertToType(expr, dataType);
    }

    public Collection getSelectionList(String name) {
        try {
            this.switchToOsgiClassLoader();
            Collection collection = this.doGetSelectionList(name);
            return collection;
        }
        finally {
            this.switchClassLoaderBack();
        }
    }

    private Collection doGetSelectionList(String name) {
        this.usingParameterValues();
        ReportDesignHandle report = this.executionContext.getDesign();
        ScalarParameterHandle parameter = (ScalarParameterHandle)report.findParameter(name);
        if (parameter == null) {
            this.executionContext.addException(new EngineException("Error.ParameterIsNotFoundByName", name));
            return Collections.EMPTY_LIST;
        }
        String selectionType = parameter.getValueType();
        String dataType = parameter.getDataType();
        boolean fixedOrder = parameter.isFixedOrder();
        boolean sortByLabel = "label".equalsIgnoreCase(parameter.getSortBy());
        boolean sortDirectionValue = "asc".equalsIgnoreCase(parameter.getSortDirection());
        if ("dynamic".equals(selectionType)) {
            CascadingParameterGroupHandle group = null;
            if (this.isCascadingParameter(parameter)) {
                group = this.getCascadingGroup(parameter);
            }
            if (group != null) {
                if ("single".equals(group.getDataSetMode())) {
                    return this.getCascadingParameterList(parameter);
                }
                if (parameter.getDataSetName() != null) {
                    return this.getChoicesFromParameterQuery(parameter);
                }
            } else if (parameter.getDataSetName() != null) {
                return this.getChoicesFromParameterQuery(parameter);
            }
        } else if ("static".equals(selectionType)) {
            Iterator iter = parameter.choiceIterator();
            ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
            while (iter.hasNext()) {
                SelectionChoiceHandle choice = (SelectionChoiceHandle)iter.next();
                String label = report.getMessage(choice.getLabelKey(), this.locale);
                if (label == null) {
                    label = choice.getLabel();
                }
                Object value = this.convertToType(choice.getValue(), dataType);
                choices.add(new SelectionChoice(label, value));
            }
            if (!fixedOrder) {
                Collections.sort(choices, new SelectionChoiceComparator(sortByLabel, parameter.getPattern(), sortDirectionValue, ULocale.forLocale((Locale)this.locale)));
            }
            return choices;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getCascadingParameterList(ScalarParameterHandle parameter) {
        Object[] parameterValuesAhead = this.getParameterValuesAhead(parameter);
        return this.getChoicesFromParameterGroup(parameter, parameterValuesAhead);
    }

    private Collection populateToList(IResultIterator iterator, ScalarParameterHandle parameter, SelectionFilter filter) {
        ParameterHelper parameterHelper = new ParameterHelper(parameter, this.locale, this.timeZone);
        Collection choices = parameterHelper.createSelectionCollection();
        int limit = parameter.getListlimit();
        try {
            while (iterator.next() && (limit <= 0 || choices.size() < limit)) {
                if (filter != null && !filter.accept(iterator)) continue;
                String label = parameterHelper.getLabel(iterator);
                Object value = parameterHelper.getValue(iterator);
                choices.add(new SelectionChoice(label, value));
            }
        }
        catch (BirtException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
            this.executionContext.addException((DesignElementHandle)parameter, ex);
        }
        return choices;
    }

    private DataRequestSession createDataSession(DataSetHandle dataSet) {
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        DataRequestSession dteSession = this.getDataSession();
        dataEngine.defineDataSet(dataSet);
        return dteSession;
    }

    private QueryDefinition createQueryDefinition(DataSetHandle dataSet) {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(dataSet.getQualifiedName());
        queryDefn.setAutoBinding(true);
        return queryDefn;
    }

    private IResultIterator executeQuery(DataRequestSession dteSession, QueryDefinition queryDefn) throws BirtException {
        IPreparedQuery query = dteSession.prepare((IQueryDefinition)queryDefn, this.getAppContext());
        IQueryResults result = query.execute(this.executionContext.getSharedScope());
        return result.getResultIterator();
    }

    public void evaluateQuery(String parameterGroupName) {
    }

    public Collection getSelectionListForCascadingGroup(String parameterGroupName, Object[] groupKeyValues) {
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (parameterGroup == null) {
            this.executionContext.addException(new EngineException("Error.ParameterGroupIsNotFoundByGroupname", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        SlotHandle slotHandle = parameterGroup.getParameters();
        if (groupKeyValues.length >= slotHandle.getCount()) {
            this.executionContext.addException(new EngineException("Error.ParameterInvalidGroupLevel", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        int i = 0;
        while (i < groupKeyValues.length) {
            String parameterName = ((ScalarParameterHandle)slotHandle.get(i)).getName();
            this.setParameterValue(parameterName, groupKeyValues[i]);
            ++i;
        }
        ScalarParameterHandle requestedParam = (ScalarParameterHandle)slotHandle.get(groupKeyValues.length);
        if (requestedParam == null) {
            this.executionContext.addException(new EngineException("Error.ParameterInGroupIsnotScalar", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        return this.getSelectionList(requestedParam.getName());
    }

    public Collection getSelectionTreeForCascadingGroup(String parameterGroupName) {
        try {
            this.switchToOsgiClassLoader();
            Collection collection = this.doGetSelectionTreeForCascadingGroup(parameterGroupName);
            return collection;
        }
        finally {
            this.switchClassLoaderBack();
        }
    }

    private Collection doGetSelectionTreeForCascadingGroup(String parameterGroupName) {
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (parameterGroup == null) {
            this.executionContext.addException(new EngineException("Error.ParameterGroupIsNotFoundByGroupname", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        SlotHandle parameters = parameterGroup.getParameters();
        int parameterCount = parameters.getCount();
        if ("single".equals(parameterGroup.getDataSetMode())) {
            IResultIterator resultIterator = this.getResultSetOfCascadingGroup(parameterGroup);
            if (resultIterator == null) {
                return Collections.EMPTY_LIST;
            }
            Collection selectionTree = this.populateToSelectionTree(resultIterator, parameterGroup);
            this.close(resultIterator);
            return selectionTree;
        }
        ParameterHelper[] parameterHelpers = this.getParameterHelpers(parameterGroup);
        ChoiceListCache cache = new ChoiceListCache(parameterHelpers);
        assert (parameterCount > 0);
        return this.getSelectionTree(parameters, parameterHelpers, cache, new Object[0]);
    }

    private Collection getSelectionTree(SlotHandle parameters, ParameterHelper[] parameterHelpers, ChoiceListCache cache, Object[] parameterValueAhead) {
        int parameterIndex = parameterValueAhead.length;
        int parameterCount = parameters.getCount();
        ScalarParameterHandle parameter = (ScalarParameterHandle)parameters.get(parameterIndex);
        Collection choices = this.getChoicesFromParameterQuery(parameter);
        Iterator iterator = choices.iterator();
        Collection result = null;
        while (iterator.hasNext()) {
            Object value;
            Object[] values = new Object[parameterIndex + 1];
            int i = 0;
            while (i < parameterValueAhead.length) {
                values[i] = parameterValueAhead[i];
                ++i;
            }
            IParameterSelectionChoice choice = (IParameterSelectionChoice)iterator.next();
            values[parameterIndex] = value = choice.getValue();
            Collection children = null;
            if (parameterIndex == parameterCount - 1) {
                children = Collections.EMPTY_LIST;
            } else if (cache.containsChildren(values, parameterIndex)) {
                children = cache.getChildren(values, parameterIndex);
            } else {
                this.executionContext.setParameter(parameter.getName(), value, choice.getLabel());
                children = this.getSelectionTree(parameters, parameterHelpers, cache, values);
            }
            result = cache.getParent(values, parameterIndex);
            CascadingParameterSelectionChoice groupChoice = parameterHelpers[parameterIndex].createCascadingParameterSelectionChoice(choice);
            result.add(groupChoice);
            groupChoice.setChildren(children);
        }
        return result;
    }

    private void close(IResultIterator resultIterator) {
        try {
            resultIterator.close();
        }
        catch (BirtException birtException) {
            log.log(Level.WARNING, "close results");
        }
    }

    private Collection populateToSelectionTree(IResultIterator iterator, CascadingParameterGroupHandle parameterGroup) {
        assert (iterator != null);
        ParameterHelper[] parameterHelpers = this.getParameterHelpers(parameterGroup);
        ChoiceListCache cache = new ChoiceListCache(parameterHelpers);
        int parameterCount = parameterHelpers.length;
        try {
            while (iterator.next()) {
                Object[] values = new Object[parameterCount];
                int i = 0;
                while (i < parameterCount) {
                    ParameterHelper parameterHelper = parameterHelpers[i];
                    CascadingParameterSelectionChoice choice = parameterHelper.createCascadingParameterSelectionChoice(iterator);
                    values[i] = choice.getValue();
                    cache.getParent(values, i).add(choice);
                    choice.setChildren(cache.getChildren(values, i));
                    ++i;
                }
            }
        }
        catch (BirtException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
            this.executionContext.addException((DesignElementHandle)parameterGroup, ex);
        }
        return cache.getRoot();
    }

    private ParameterHelper[] getParameterHelpers(CascadingParameterGroupHandle parameterGroup) {
        SlotHandle parameters = parameterGroup.getParameters();
        int parameterCount = parameters.getCount();
        ParameterHelper[] parameterHelpers = new ParameterHelper[parameterCount];
        int i = 0;
        while (i < parameterCount) {
            ScalarParameterHandle parameter = (ScalarParameterHandle)parameters.get(i);
            parameterHelpers[i] = new ParameterHelper(parameter, this.locale, this.timeZone);
            ++i;
        }
        return parameterHelpers;
    }

    private Collection getChoicesFromParameterGroup(ScalarParameterHandle parameter, Object[] groupKeyValues) {
        assert (this.isCascadingParameter(parameter));
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        IResultIterator iterator = this.getResultSetOfCascadingGroup(parameterGroup);
        if (iterator == null) {
            return Collections.EMPTY_LIST;
        }
        return this.populateToList(iterator, parameter, new ParameterGroupFilter(groupKeyValues, parameterGroup));
    }

    private IResultIterator getResultSetOfCascadingGroup(CascadingParameterGroupHandle parameterGroup) {
        if (parameterGroup == null) {
            return null;
        }
        DataSetHandle dataSet = parameterGroup.getDataSet();
        if (dataSet != null) {
            try {
                QueryDefinition queryDefn = this.createQueryDefinition(dataSet);
                for (Object parameter : parameterGroup.getParameters()) {
                    if (!(parameter instanceof ScalarParameterHandle)) continue;
                    ParameterHelper.addParameterBinding(queryDefn, (ScalarParameterHandle)parameter);
                    ParameterHelper.addParameterSortBy(queryDefn, (ScalarParameterHandle)parameter);
                }
                DataRequestSession dteSession = this.createDataSession(dataSet);
                return this.executeQuery(dteSession, queryDefn);
            }
            catch (BirtException ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
                this.executionContext.addException((DesignElementHandle)dataSet, ex);
            }
        }
        return null;
    }

    private CascadingParameterGroupHandle getCascadingParameterGroup(String name) {
        ReportDesignHandle report = this.executionContext.getDesign();
        return report.findCascadingParameterGroup(name);
    }

    private boolean isCascadingParameter(ScalarParameterHandle parameter) {
        return parameter.getContainer() instanceof CascadingParameterGroupHandle;
    }

    private Object[] getParameterValuesAhead(ScalarParameterHandle parameter) {
        assert (this.isCascadingParameter(parameter));
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        SlotHandle parameters = parameterGroup.getParameters();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while (i < parameters.getCount()) {
            ScalarParameterHandle tempParameter = (ScalarParameterHandle)parameters.get(i);
            if (tempParameter == parameter) break;
            values.add(this.getParameterValue(tempParameter.getName()));
            ++i;
        }
        return values.toArray();
    }

    private CascadingParameterGroupHandle getCascadingGroup(ScalarParameterHandle parameter) {
        DesignElementHandle handle = parameter.getContainer();
        assert (handle instanceof CascadingParameterGroupHandle);
        CascadingParameterGroupHandle parameterGroup = (CascadingParameterGroupHandle)handle;
        return parameterGroup;
    }

    private Collection getChoicesFromParameterQuery(ScalarParameterHandle parameter) {
        IResultIterator iter = this.getResultSetForParameter(parameter);
        if (iter == null) {
            return Collections.EMPTY_LIST;
        }
        return this.populateToList(iter, parameter, null);
    }

    private IResultIterator getResultSetForParameter(ScalarParameterHandle parameter) {
        ReportDesignHandle report = this.executionContext.getDesign();
        DataSetHandle dataSet = report.findDataSet(parameter.getDataSetName());
        IResultIterator iterator = null;
        if (dataSet != null) {
            try {
                QueryDefinition queryDefn = this.createQueryDefinition(dataSet);
                ParameterHelper.addParameterBinding(queryDefn, parameter);
                ParameterHelper.addParameterSortBy(queryDefn, parameter);
                DataRequestSession dteSession = this.createDataSession(dataSet);
                iterator = this.executeQuery(dteSession, queryDefn);
            }
            catch (BirtException ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
                this.executionContext.addException((DesignElementHandle)dataSet, ex);
            }
        }
        return iterator;
    }

    private IParameterDefnBase getParamDefnBaseByName(ParameterDefnBase param, String name) {
        ParameterDefnBase ret = null;
        if (param instanceof ScalarParameterDefn && name.equals(param.getName())) {
            ret = param;
        } else if (param instanceof ParameterGroupDefn) {
            if (name.equals(param.getName())) {
                ret = param;
            } else {
                for (ParameterDefnBase pBase : ((ParameterGroupDefn)param).getContents()) {
                    if (!name.equals(pBase.getName())) continue;
                    ret = pBase;
                    break;
                }
            }
        }
        if (ret != null) {
            try {
                return (IParameterDefnBase)ret.clone();
            }
            catch (CloneNotSupportedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return ret;
    }

    public ArrayList getParameters(ReportDesignHandle handle, boolean includeParameterGroups) {
        assert (handle != null);
        ParameterIRVisitor visitor = new ParameterIRVisitor(handle);
        ArrayList<IParameterDefnBase> parameters = new ArrayList<IParameterDefnBase>();
        SlotHandle paramSlot = handle.getParameters();
        int i = 0;
        while (i < paramSlot.getCount()) {
            visitor.apply(paramSlot.get(i));
            assert (visitor.currentElement != null);
            IParameterDefnBase param = (IParameterDefnBase)visitor.currentElement;
            assert (param.getName() != null);
            parameters.add(param);
            ++i;
        }
        if (includeParameterGroups) {
            return parameters;
        }
        return this.flattenParameter(parameters);
    }

    protected ArrayList flattenParameter(ArrayList params) {
        assert (params != null);
        ArrayList<IParameterDefnBase> allParameters = new ArrayList<IParameterDefnBase>();
        int n = 0;
        while (n < params.size()) {
            IParameterDefnBase param = (IParameterDefnBase)params.get(n);
            if (param.getParameterType() == 4 || param.getParameterType() == 5) {
                allParameters.addAll(this.flattenParameter(((IParameterGroupDefn)param).getContents()));
            } else {
                allParameters.add(param);
            }
            ++n;
        }
        return allParameters;
    }

    static class CascadingParameterSelectionChoice
    extends SelectionChoice
    implements ICascadingParameterSelectionChoice {
        Collection children;

        public CascadingParameterSelectionChoice(String label, Object value) {
            super(label, value);
        }

        public void setChildren(Collection children) {
            this.children = children;
        }

        public Collection getChildSelectionList() {
            return this.children;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CascadingParameterSelectionChoice)) {
                return false;
            }
            CascadingParameterSelectionChoice choice = (CascadingParameterSelectionChoice)obj;
            if (this.value == null) {
                return choice.value == null;
            }
            return this.value.equals(choice.value);
        }
    }

    static class ChoiceListCache {
        private ParameterHelper[] parameterHelpers;
        private Map[] cachedLists;
        private Collection root;
        private int parameterCount;

        public ChoiceListCache(ParameterHelper[] parameterHelpers) {
            this.parameterHelpers = parameterHelpers;
            this.parameterCount = parameterHelpers.length;
            this.cachedLists = new Map[this.parameterCount - 1];
            int i = 0;
            while (i < this.cachedLists.length) {
                this.cachedLists[i] = new HashMap();
                ++i;
            }
            this.root = parameterHelpers[0].createSelectionCollection();
        }

        public Collection getParent(Object[] values, int parameterIndex) {
            if (parameterIndex == 0) {
                return this.root;
            }
            int parentIndex = parameterIndex - 1;
            Map cache = this.cachedLists[parentIndex];
            ValueGroup valueGroup = new ValueGroup(values, parentIndex);
            Collection parent = (Collection)cache.get(valueGroup);
            if (parent == null) {
                parent = this.parameterHelpers[parameterIndex].createSelectionCollection();
                cache.put(valueGroup, parent);
            }
            return parent;
        }

        public boolean containsChildren(Object[] values, int parameterIndex) {
            if (parameterIndex == this.parameterCount - 1) {
                return false;
            }
            ValueGroup valueGroup = new ValueGroup(values, parameterIndex);
            Map cache = this.cachedLists[parameterIndex];
            return cache.containsKey(valueGroup);
        }

        public Collection getChildren(Object[] values, int parameterIndex) {
            if (parameterIndex == this.parameterCount - 1) {
                return Collections.EMPTY_LIST;
            }
            Map cache = this.cachedLists[parameterIndex];
            ValueGroup valueGroup = new ValueGroup(values, parameterIndex);
            Collection parent = (Collection)cache.get(valueGroup);
            if (parent == null) {
                parent = this.parameterHelpers[parameterIndex + 1].createSelectionCollection();
                cache.put(valueGroup, parent);
            }
            return parent;
        }

        public Collection getRoot() {
            return this.root;
        }
    }

    class ParameterBinding {
        String labelColumnName;
        String valueColumnName;
        String valueType;

        public ParameterBinding(String labelColumnName, String valueColumnName, String valueType) {
            this.labelColumnName = labelColumnName;
            this.valueColumnName = valueColumnName;
            this.valueType = valueType;
        }
    }

    private class ParameterGroupFilter
    implements SelectionFilter {
        Object[] keyValues;
        String[] valueColumnNames;
        String[] valueTypes;

        public ParameterGroupFilter(Object[] keyValues, CascadingParameterGroupHandle parameterGroup) {
            this.keyValues = keyValues;
            this.valueColumnNames = new String[keyValues.length];
            this.valueTypes = new String[keyValues.length];
            SlotHandle parameterSlots = parameterGroup.getParameters();
            int i = 0;
            while (i < keyValues.length) {
                ScalarParameterHandle tempParameter = (ScalarParameterHandle)parameterSlots.get(i);
                this.valueColumnNames[i] = ParameterHelper.getValueColumnName(tempParameter);
                this.valueTypes[i] = tempParameter.getDataType();
                ++i;
            }
        }

        public boolean accept(IResultIterator iterator) throws BirtException {
            int i = 0;
            while (i < this.valueColumnNames.length) {
                Object value = iterator.getValue(this.valueColumnNames[i]);
                if ((value = GetParameterDefinitionTask.this.convertToType(value, this.valueTypes[i])) == null && this.keyValues[i] != null || value != null && !value.equals(this.keyValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class ParameterIRVisitor
    extends DesignVisitor {
        protected ReportDesignHandle handle;
        protected Object currentElement;

        ParameterIRVisitor(ReportDesignHandle handle) {
            this.handle = handle;
        }

        public void visitParameterGroup(ParameterGroupHandle handle) {
            ParameterGroupDefn paramGroup = new ParameterGroupDefn();
            paramGroup.setHandle((ReportElementHandle)handle);
            paramGroup.setParameterType(4);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            paramGroup.setPromptText(handle.getPromptText());
            paramGroup.setPromptTextKey(handle.getPromptTextKey());
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
            CascadingParameterGroupDefn paramGroup = new CascadingParameterGroupDefn();
            paramGroup.setLocale(GetParameterDefinitionTask.this.locale);
            paramGroup.setHandle((ReportElementHandle)handle);
            paramGroup.setParameterType(5);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            paramGroup.setPromptText(handle.getPromptText());
            paramGroup.setPromptTextKey(handle.getPromptTextKey());
            DataSetHandle dset = handle.getDataSet();
            if (dset != null) {
                paramGroup.setDataSet(dset.getName());
            }
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        public void visitScalarParameter(ScalarParameterHandle handle) {
            assert (handle.getName() != null);
            ScalarParameterDefn scalarParameter = new ScalarParameterDefn();
            scalarParameter.setHandle((ReportElementHandle)handle);
            scalarParameter.setLocale(GetParameterDefinitionTask.this.locale);
            scalarParameter.setParameterType(0);
            scalarParameter.setName(handle.getName());
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                scalarParameter.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            String align = handle.getAlignment();
            if ("center".equals(align)) {
                scalarParameter.setAlignment(2);
            } else if ("left".equals(align)) {
                scalarParameter.setAlignment(1);
            } else if ("right".equals(align)) {
                scalarParameter.setAlignment(3);
            } else {
                scalarParameter.setAlignment(0);
            }
            scalarParameter.setAllowBlank(handle.allowBlank());
            scalarParameter.setAllowNull(handle.allowNull());
            scalarParameter.setIsRequired(handle.isRequired());
            scalarParameter.setScalarParameterType(handle.getParamType());
            String controlType = handle.getControlType();
            if ("check-box".equals(controlType)) {
                scalarParameter.setControlType(3);
            } else if ("list-box".equals(controlType)) {
                scalarParameter.setControlType(1);
            } else if ("radio-button".equals(controlType)) {
                scalarParameter.setControlType(2);
            } else if ("auto-suggest".equals(controlType)) {
                scalarParameter.setControlType(4);
            } else {
                scalarParameter.setControlType(0);
            }
            scalarParameter.setDefaultValue(handle.getDefaultValue());
            scalarParameter.setDisplayName(handle.getDisplayName());
            scalarParameter.setDisplayNameKey(handle.getDisplayNameKey());
            scalarParameter.setFormat(handle.getPattern());
            scalarParameter.setHelpText(handle.getHelpText());
            scalarParameter.setHelpTextKey(handle.getHelpTextKey());
            scalarParameter.setPromptText(handle.getPromptText());
            scalarParameter.setPromptTextKey(handle.getPromptTextID());
            scalarParameter.setIsHidden(handle.isHidden());
            scalarParameter.setName(handle.getName());
            String valueType = handle.getDataType();
            if ("boolean".equals(valueType)) {
                scalarParameter.setDataType(5);
            } else if ("dateTime".equals(valueType)) {
                scalarParameter.setDataType(4);
            } else if ("date".equals(valueType)) {
                scalarParameter.setDataType(7);
            } else if ("time".equals(valueType)) {
                scalarParameter.setDataType(8);
            } else if ("decimal".equals(valueType)) {
                scalarParameter.setDataType(3);
            } else if ("float".equals(valueType)) {
                scalarParameter.setDataType(2);
            } else if ("string".equals(valueType)) {
                scalarParameter.setDataType(1);
            } else if ("integer".equals(valueType)) {
                scalarParameter.setDataType(6);
            } else {
                scalarParameter.setDataType(0);
            }
            ArrayList<ParameterSelectionChoice> values = new ArrayList<ParameterSelectionChoice>();
            Iterator selectionIter = handle.choiceIterator();
            while (selectionIter.hasNext()) {
                SelectionChoiceHandle selection = (SelectionChoiceHandle)selectionIter.next();
                ParameterSelectionChoice selectionChoice = new ParameterSelectionChoice(this.handle);
                selectionChoice.setLabel(selection.getLabelKey(), selection.getLabel());
                selectionChoice.setValue(selection.getValue(), scalarParameter.getDataType());
                values.add(selectionChoice);
            }
            scalarParameter.setSelectionList(values);
            scalarParameter.setAllowNewValues(!handle.isMustMatch());
            scalarParameter.setFixedOrder(handle.isFixedOrder());
            String paramType = handle.getValueType();
            if ("static".equals(paramType) && scalarParameter.getSelectionList() != null && scalarParameter.getSelectionList().size() > 0) {
                scalarParameter.setSelectionListType(2);
            } else if ("dynamic".equals(paramType)) {
                scalarParameter.setSelectionListType(1);
            } else {
                scalarParameter.setSelectionListType(0);
            }
            scalarParameter.setValueConcealed(handle.isConcealValue());
            this.currentElement = scalarParameter;
            scalarParameter.setAutoSuggestThreshold(handle.getAutoSuggestThreshold());
        }
    }

    static class SelectionChoice
    implements IParameterSelectionChoice {
        String label;
        Object value;

        SelectionChoice(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SelectionChoice)) {
                return false;
            }
            SelectionChoice choice = (SelectionChoice)obj;
            if (this.value == null) {
                return choice.value == null;
            }
            return this.value.equals(choice.value);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }

    private static interface SelectionFilter {
        public boolean accept(IResultIterator var1) throws BirtException;
    }

    static class ValueGroup {
        private Object[] values;
        private int parameterIndex;

        public ValueGroup(Object[] values, int parameterIndex) {
            this.values = values;
            this.parameterIndex = parameterIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            int i = 0;
            while (i <= this.parameterIndex) {
                hashCode += 13 * this.values[i].hashCode();
                ++i;
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueGroup)) {
                return false;
            }
            ValueGroup valueGroup = (ValueGroup)obj;
            if (this.parameterIndex != valueGroup.parameterIndex) {
                return false;
            }
            int i = 0;
            while (i <= this.parameterIndex) {
                if (!this.equal(this.values[i], valueGroup.values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean equal(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }
}

