/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ContextPageBreakHandler;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.executor.ReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.emitter.PDFLayoutEmitterProxy;

public class RunAndRenderTask
extends EngineTask
implements IRunAndRenderTask {
    protected IReportLayoutEngine layoutEngine;
    protected IPageHandler pageHandler;

    public RunAndRenderTask(ReportEngine engine, IReportRunnable runnable) {
        super(engine, runnable, 3);
    }

    public void run() throws EngineException {
        try {
            this.switchToOsgiClassLoader();
            this.changeStatusToRunning();
            this.doRun();
        }
        finally {
            this.changeStatusToStopped();
            this.switchClassLoaderBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRun() throws EngineException {
        this.doValidateParameters();
        this.setupRenderOption();
        this.loadDesign();
        this.prepareDesign();
        this.startFactory();
        this.updateRtLFlag();
        this.startRender();
        try {
            Object htmlOption;
            IContentEmitter emitter = this.createContentEmitter();
            IReportExecutor executor = new ReportExecutor(this.executionContext);
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(this.executionContext, executor);
            this.executionContext.setExecutor(executor);
            if ("paper-size-pagination".equals(this.pagination)) {
                emitter = new PDFLayoutEmitterProxy(executor, emitter, this.renderOptions, this.executionContext, 0L);
            }
            this.initializeContentEmitter(emitter, executor);
            String format = this.executionContext.getOutputFormat();
            boolean paginate = true;
            if ("html".equalsIgnoreCase(format)) {
                htmlOption = new HTMLRenderOption(this.renderOptions);
                paginate = ((HTMLRenderOption)htmlOption).getHtmlPagination();
            }
            if ("no-pagination".equals(this.pagination)) {
                paginate = false;
            }
            htmlOption = this;
            synchronized (htmlOption) {
                if (!this.executionContext.isCanceled()) {
                    this.layoutEngine = this.createReportLayoutEngine(this.pagination, this.renderOptions);
                }
            }
            if (this.layoutEngine != null) {
                this.layoutEngine.setLocale(this.executionContext.getLocale());
                CompositeLayoutPageHandler layoutPageHandler = new CompositeLayoutPageHandler();
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(this.executionContext);
                layoutPageHandler.addPageHandler(handle);
                layoutPageHandler.addPageHandler(new ContextPageBreakHandler(this.executionContext));
                layoutPageHandler.addPageHandler(new LayoutPageHandler());
                this.layoutEngine.setPageHandler(layoutPageHandler);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                IReportContent report = executor.execute();
                outputEmitters.start(report);
                this.layoutEngine.layout(executor, report, outputEmitters, paginate);
                this.layoutEngine.close();
                outputEmitters.end(report);
            }
            this.closeRender();
            this.executionContext.closeDataEngine();
            this.closeFactory();
        }
        catch (EngineException e) {
            throw e;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
            throw new EngineException("Error.ReportRunError", ex);
        }
        catch (OutOfMemoryError err) {
            this.log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
            throw err;
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Error happened while running the report.", t);
            throw new EngineException("Error.ReportRunError", t);
        }
    }

    public void cancel() {
        super.cancel();
        if (this.layoutEngine != null) {
            this.layoutEngine.cancel();
        }
    }

    public void setMaxRowsPerQuery(int maxRows) {
        this.executionContext.setMaxRowsPerQuery(maxRows);
    }

    public void setPageHandler(IPageHandler callback) {
        this.pageHandler = callback;
    }

    class LayoutPageHandler
    implements ILayoutPageHandler {
        LayoutPageHandler() {
        }

        public void onPage(long pageNumber, Object context) {
            if (RunAndRenderTask.this.pageHandler != null) {
                RunAndRenderTask.this.pageHandler.onPage((int)pageNumber, false, null);
            }
        }
    }
}

