/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractStyle
implements IStyle {
    protected CSSEngine engine;

    public AbstractStyle(CSSEngine engine) {
        this.engine = engine;
    }

    public CSSEngine getCSSEngine() {
        return this.engine;
    }

    public void setProperties(IStyle style) {
        int i = 0;
        while (i < 60) {
            CSSValue v = style.getProperty(i);
            if (v != null) {
                this.setProperty(i, v);
            }
            ++i;
        }
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 60) {
            CSSValue value = this.getProperty(i);
            if (value != null) {
                sb.append(this.engine.getPropertyName(i));
                sb.append(": ");
                short type = value.getCssValueType();
                block0 : switch (type) {
                    case 1: {
                        CSSPrimitiveValue pv = (CSSPrimitiveValue)value;
                        short unitType = pv.getPrimitiveType();
                        switch (unitType) {
                            case 19: {
                                sb.append("'");
                                sb.append(pv.getStringValue());
                                sb.append("'");
                                break block0;
                            }
                            case 20: {
                                sb.append("url('");
                                sb.append(pv.getStringValue());
                                sb.append("')");
                                break block0;
                            }
                        }
                        sb.append(value.getCssText());
                        break;
                    }
                    default: {
                        sb.append(value.getCssText());
                    }
                }
                sb.append("; ");
            }
            ++i;
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    protected String getCssText(CSSValue value) {
        if (value == null) {
            return null;
        }
        return value.getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        IStyle style = (IStyle)this.engine.parseStyleDeclaration(cssText);
        int i = 0;
        while (i < 60) {
            CSSValue value = style.getProperty(i);
            if (value != null) {
                this.setProperty(i, value);
            }
            ++i;
        }
    }

    protected int getPropertyIndex(String propertyName) {
        return this.engine.getPropertyIndex(propertyName);
    }

    public String getPropertyValue(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            return this.getCssText(index);
        }
        return null;
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            return this.getProperty(index);
        }
        return null;
    }

    public String removeProperty(String propertyName) throws DOMException {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            this.setProperty(index, null);
        }
        return null;
    }

    public String getPropertyPriority(String propertyName) {
        throw new DOMException(9, "getPropertyPriority");
    }

    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        int index = this.getPropertyIndex(propertyName);
        if (index != -1) {
            this.setCssText(index, value);
        }
    }

    public int getLength() {
        throw new DOMException(9, "getLength");
    }

    public String item(int index) {
        throw new DOMException(9, "item");
    }

    public CSSRule getParentRule() {
        throw new DOMException(9, "getParentRule");
    }

    public String getCssText(int index) {
        CSSValue value = this.getProperty(index);
        if (value != null) {
            return value.getCssText();
        }
        return null;
    }

    public void setCssText(int index, String cssText) {
        if (cssText != null) {
            CSSValue value = this.engine.parsePropertyValue(index, cssText);
            this.setProperty(index, value);
        } else {
            this.setProperty(index, null);
        }
    }

    public String getFontFamily() {
        return this.getCssText(52);
    }

    public String getFontStyle() {
        return this.getCssText(4);
    }

    public String getFontVariant() {
        return this.getCssText(6);
    }

    public String getFontWeight() {
        return this.getCssText(46);
    }

    public String getFontSize() {
        return this.getCssText(3);
    }

    public String getColor() {
        return this.getCssText(12);
    }

    public String getBackgroundColor() {
        return this.getCssText(20);
    }

    public String getBackgroundImage() {
        return this.getCssText(37);
    }

    public String getBackgroundRepeat() {
        return this.getCssText(14);
    }

    public String getBackgroundAttachment() {
        return this.getCssText(32);
    }

    public String getBackgroundPositionX() {
        return this.getCssText(48);
    }

    public String getBackgroundPositionY() {
        return this.getCssText(54);
    }

    public String getWordSpacing() {
        return this.getCssText(55);
    }

    public String getLetterSpacing() {
        return this.getCssText(49);
    }

    public String getTextUnderline() {
        return this.getCssText(39);
    }

    public String getTextOverline() {
        return this.getCssText(15);
    }

    public String getTextLineThrough() {
        return this.getCssText(42);
    }

    public String getVerticalAlign() {
        return this.getCssText(31);
    }

    public String getTextTransform() {
        return this.getCssText(27);
    }

    public String getTextAlign() {
        return this.getCssText(23);
    }

    public String getTextIndent() {
        return this.getCssText(29);
    }

    public String getLineHeight() {
        return this.getCssText(16);
    }

    public String getWhiteSpace() {
        return this.getCssText(53);
    }

    public String getMarginTop() {
        return this.getCssText(28);
    }

    public String getMarginBottom() {
        return this.getCssText(18);
    }

    public String getMarginLeft() {
        return this.getCssText(1);
    }

    public String getMarginRight() {
        return this.getCssText(2);
    }

    public String getPaddingTop() {
        return this.getCssText(50);
    }

    public String getPaddingBottom() {
        return this.getCssText(45);
    }

    public String getPaddingLeft() {
        return this.getCssText(30);
    }

    public String getPaddingRight() {
        return this.getCssText(44);
    }

    public String getBorderTopWidth() {
        return this.getCssText(57);
    }

    public String getBorderBottomWidth() {
        return this.getCssText(22);
    }

    public String getBorderLeftWidth() {
        return this.getCssText(51);
    }

    public String getBorderRightWidth() {
        return this.getCssText(21);
    }

    public String getBorderTopColor() {
        return this.getCssText(13);
    }

    public String getBorderBottomColor() {
        return this.getCssText(8);
    }

    public String getBorderLeftColor() {
        return this.getCssText(41);
    }

    public String getBorderRightColor() {
        return this.getCssText(7);
    }

    public String getBorderTopStyle() {
        return this.getCssText(9);
    }

    public String getBorderBottomStyle() {
        return this.getCssText(11);
    }

    public String getBorderLeftStyle() {
        return this.getCssText(43);
    }

    public String getBorderRightStyle() {
        return this.getCssText(10);
    }

    public String getDisplay() {
        return this.getCssText(33);
    }

    public String getOrphans() {
        return this.getCssText(25);
    }

    public String getWidows() {
        return this.getCssText(24);
    }

    public String getPageBreakAfter() {
        return this.getCssText(56);
    }

    public String getPageBreakBefore() {
        return this.getCssText(58);
    }

    public String getPageBreakInside() {
        return this.getCssText(59);
    }

    public String getMasterPage() {
        return this.getCssText(5);
    }

    public String getShowIfBlank() {
        return this.getCssText(26);
    }

    public String getCanShrink() {
        return this.getCssText(19);
    }

    public String getVisibleFormat() {
        return this.getCssText(35);
    }

    public void setBackgroundAttachment(String backgroundAttachment) {
        this.setCssText(32, backgroundAttachment);
    }

    public void setBackgroundColor(String backgroundColor) {
        this.setCssText(20, backgroundColor);
    }

    public void setBackgroundImage(String backgroundImage) {
        this.setCssText(37, backgroundImage);
    }

    public void setBackgroundPositionX(String backgroundPositionX) {
        this.setCssText(48, backgroundPositionX);
    }

    public void setBackgroundPositionY(String backgroundPositionY) {
        this.setCssText(54, backgroundPositionY);
    }

    public void setBackgroundRepeat(String backgroundRepeat) {
        this.setCssText(14, backgroundRepeat);
    }

    public void setBorderBottomColor(String borderBottomColor) {
        this.setCssText(8, borderBottomColor);
    }

    public void setBorderBottomStyle(String borderBottomStyle) {
        this.setCssText(11, borderBottomStyle);
    }

    public void setBorderBottomWidth(String borderBottomWidth) {
        this.setCssText(22, borderBottomWidth);
    }

    public void setBorderLeftColor(String borderLeftColor) {
        this.setCssText(41, borderLeftColor);
    }

    public void setBorderLeftStyle(String borderLeftStyle) {
        this.setCssText(43, borderLeftStyle);
    }

    public void setBorderLeftWidth(String borderLeftWidth) {
        this.setCssText(51, borderLeftWidth);
    }

    public void setBorderRightColor(String borderRightColor) {
        this.setCssText(7, borderRightColor);
    }

    public void setBorderRightStyle(String borderRightStyle) {
        this.setCssText(10, borderRightStyle);
    }

    public void setBorderRightWidth(String borderRightWidth) {
        this.setCssText(21, borderRightWidth);
    }

    public void setBorderTopColor(String borderTopColor) {
        this.setCssText(13, borderTopColor);
    }

    public void setBorderTopStyle(String borderTopStyle) {
        this.setCssText(9, borderTopStyle);
    }

    public void setBorderTopWidth(String borderTopWidth) {
        this.setCssText(57, borderTopWidth);
    }

    public void setCanShrink(String canShrink) {
        this.setCssText(19, canShrink);
    }

    public void setColor(String color) {
        this.setCssText(12, color);
    }

    public void setDisplay(String display) {
        this.setCssText(33, display);
    }

    public void setFontFamily(String fontFamily) {
        this.setCssText(52, fontFamily);
    }

    public void setFontSize(String fontSize) {
        this.setCssText(3, fontSize);
    }

    public void setFontStyle(String fontStyle) {
        this.setCssText(4, fontStyle);
    }

    public void setFontVariant(String fontVariant) {
        this.setCssText(6, fontVariant);
    }

    public void setFontWeight(String fontWeight) {
        this.setCssText(46, fontWeight);
    }

    public void setLetterSpacing(String letterSpacing) {
        this.setCssText(49, letterSpacing);
    }

    public void setLineHeight(String lineHeight) {
        this.setCssText(16, lineHeight);
    }

    public void setMarginBottom(String marginBottom) {
        this.setCssText(18, marginBottom);
    }

    public void setMarginLeft(String marginLeft) {
        this.setCssText(1, marginLeft);
    }

    public void setMarginRight(String marginRight) {
        this.setCssText(2, marginRight);
    }

    public void setMarginTop(String marginTop) {
        this.setCssText(28, marginTop);
    }

    public void setMasterPage(String masterPage) {
        this.setCssText(5, masterPage);
    }

    public void setOrphans(String orphans) {
        this.setCssText(25, orphans);
    }

    public void setPaddingBottom(String paddingBottom) {
        this.setCssText(45, paddingBottom);
    }

    public void setPaddingLeft(String paddingLeft) {
        this.setCssText(30, paddingLeft);
    }

    public void setPaddingRight(String paddingRight) {
        this.setCssText(44, paddingRight);
    }

    public void setPaddingTop(String paddingTop) {
        this.setCssText(50, paddingTop);
    }

    public void setPageBreakAfter(String pageBreakAfter) {
        this.setCssText(56, pageBreakAfter);
    }

    public void setPageBreakBefore(String pageBreakBefore) {
        this.setCssText(58, pageBreakBefore);
    }

    public void setPageBreakInside(String pageBreakInside) {
        this.setCssText(59, pageBreakInside);
    }

    public void setShowIfBlank(String showIfBlank) {
        this.setCssText(26, showIfBlank);
    }

    public void setTextAlign(String textAlign) {
        this.setCssText(23, textAlign);
    }

    public void setTextIndent(String textIndent) {
        this.setCssText(29, textIndent);
    }

    public void setTextLineThrough(String textLineThrough) {
        this.setCssText(42, textLineThrough);
    }

    public void setTextOverline(String textOverline) {
        this.setCssText(15, textOverline);
    }

    public void setTextTransform(String textTransform) {
        this.setCssText(27, textTransform);
    }

    public void setTextUnderline(String textUnderline) {
        this.setCssText(39, textUnderline);
    }

    public void setVerticalAlign(String verticalAlign) {
        this.setCssText(31, verticalAlign);
    }

    public void setWhiteSpace(String whiteSpace) {
        this.setCssText(53, whiteSpace);
    }

    public void setWidows(String widows) {
        this.setCssText(24, widows);
    }

    public void setWordSpacing(String wordSpacing) throws DOMException {
        this.setCssText(55, wordSpacing);
    }

    public void setStringFormat(String format) throws DOMException {
        this.setCssText(47, format);
    }

    public void setNumberFormat(String format) throws DOMException {
        this.setCssText(34, format);
    }

    public void setDateFormat(String format) throws DOMException {
        this.setCssText(36, format);
    }

    public void setDateTimeFormat(String format) throws DOMException {
        this.setCssText(38, format);
    }

    public void setTimeFormat(String format) throws DOMException {
        this.setCssText(40, format);
    }

    public void setNumberAlign(String align) throws DOMException {
        this.setCssText(17, align);
    }

    public void setVisibleFormat(String formats) throws DOMException {
        this.setCssText(35, formats);
    }

    public String getStringFormat() {
        return this.getCssText(47);
    }

    public String getNumberFormat() {
        return this.getCssText(34);
    }

    public String getDateFormat() {
        return this.getCssText(36);
    }

    public String getDateTimeFormat() {
        return this.getCssText(38);
    }

    public String getTimeFormat() {
        return this.getCssText(40);
    }

    public String getNumberAlign() {
        return this.getCssText(17);
    }

    public String getAzimuth() {
        return null;
    }

    public void setAzimuth(String azimuth) throws DOMException {
    }

    public String getBackground() {
        return null;
    }

    public void setBackground(String background) throws DOMException {
    }

    public String getBackgroundPosition() {
        return null;
    }

    public void setBackgroundPosition(String backgroundPosition) throws DOMException {
    }

    public String getBorder() {
        return null;
    }

    public void setBorder(String border) throws DOMException {
    }

    public String getBorderCollapse() {
        return null;
    }

    public void setBorderCollapse(String borderCollapse) throws DOMException {
    }

    public String getBorderColor() {
        return null;
    }

    public void setBorderColor(String borderColor) throws DOMException {
    }

    public String getBorderSpacing() {
        return null;
    }

    public void setBorderSpacing(String borderSpacing) throws DOMException {
    }

    public String getBorderStyle() {
        return null;
    }

    public void setBorderStyle(String borderStyle) throws DOMException {
    }

    public String getBorderTop() {
        return null;
    }

    public void setBorderTop(String borderTop) throws DOMException {
    }

    public String getBorderRight() {
        return null;
    }

    public void setBorderRight(String borderRight) throws DOMException {
    }

    public String getBorderBottom() {
        return null;
    }

    public void setBorderBottom(String borderBottom) throws DOMException {
    }

    public String getBorderLeft() {
        return null;
    }

    public void setBorderLeft(String borderLeft) throws DOMException {
    }

    public String getBorderWidth() {
        return null;
    }

    public void setBorderWidth(String borderWidth) throws DOMException {
    }

    public String getBottom() {
        return null;
    }

    public void setBottom(String bottom) throws DOMException {
    }

    public String getCaptionSide() {
        return null;
    }

    public void setCaptionSide(String captionSide) throws DOMException {
    }

    public String getClear() {
        return null;
    }

    public void setClear(String clear) throws DOMException {
    }

    public String getClip() {
        return null;
    }

    public void setClip(String clip) throws DOMException {
    }

    public String getContent() {
        return null;
    }

    public void setContent(String content) throws DOMException {
    }

    public String getCounterIncrement() {
        return null;
    }

    public void setCounterIncrement(String counterIncrement) throws DOMException {
    }

    public String getCounterReset() {
        return null;
    }

    public void setCounterReset(String counterReset) throws DOMException {
    }

    public String getCue() {
        return null;
    }

    public void setCue(String cue) throws DOMException {
    }

    public String getCueAfter() {
        return null;
    }

    public void setCueAfter(String cueAfter) throws DOMException {
    }

    public String getCueBefore() {
        return null;
    }

    public void setCueBefore(String cueBefore) throws DOMException {
    }

    public String getCursor() {
        return null;
    }

    public void setCursor(String cursor) throws DOMException {
    }

    public String getDirection() {
        return this.getCssText(0);
    }

    public void setDirection(String direction) throws DOMException {
        this.setCssText(0, direction);
    }

    public String getElevation() {
        return null;
    }

    public void setElevation(String elevation) throws DOMException {
    }

    public String getEmptyCells() {
        return null;
    }

    public void setEmptyCells(String emptyCells) throws DOMException {
    }

    public String getCssFloat() {
        return null;
    }

    public void setCssFloat(String cssFloat) throws DOMException {
    }

    public String getFont() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setFont(String font) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getFontSizeAdjust() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setFontSizeAdjust(String fontSizeAdjust) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getFontStretch() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setFontStretch(String fontStretch) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getHeight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setHeight(String height) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getLeft() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setLeft(String left) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getListStyle() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setListStyle(String listStyle) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getListStyleImage() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setListStyleImage(String listStyleImage) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getListStylePosition() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setListStylePosition(String listStylePosition) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getListStyleType() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setListStyleType(String listStyleType) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMargin() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMargin(String margin) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMarkerOffset() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMarkerOffset(String markerOffset) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMarks() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMarks(String marks) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMaxHeight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMaxHeight(String maxHeight) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMaxWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMaxWidth(String maxWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMinHeight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMinHeight(String minHeight) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getMinWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setMinWidth(String minWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getOutline() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setOutline(String outline) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getOutlineColor() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setOutlineColor(String outlineColor) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getOutlineStyle() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setOutlineStyle(String outlineStyle) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getOutlineWidth() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setOutlineWidth(String outlineWidth) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getOverflow() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setOverflow(String overflow) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPadding() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPadding(String padding) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPage() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPage(String page) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPause() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPause(String pause) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPauseAfter() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPauseAfter(String pauseAfter) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPauseBefore() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPauseBefore(String pauseBefore) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPitch() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPitch(String pitch) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPitchRange() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPitchRange(String pitchRange) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPlayDuring() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPlayDuring(String playDuring) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getPosition() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setPosition(String position) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getQuotes() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setQuotes(String quotes) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getRichness() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setRichness(String richness) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getRight() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setRight(String right) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSize() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSize(String size) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSpeak() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSpeak(String speak) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSpeakHeader() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSpeakHeader(String speakHeader) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSpeakNumeral() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSpeakNumeral(String speakNumeral) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSpeakPunctuation() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSpeakPunctuation(String speakPunctuation) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getSpeechRate() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setSpeechRate(String speechRate) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getStress() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setStress(String stress) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getTableLayout() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setTableLayout(String tableLayout) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getTextDecoration() {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public void setTextDecoration(String textDecoration) throws DOMException {
        throw this.createUnsupportedPropertyException("text-decoration");
    }

    public String getTextShadow() {
        throw this.createUnsupportedPropertyException("text-shadow");
    }

    public void setTextShadow(String textShadow) throws DOMException {
        throw this.createUnsupportedPropertyException("text-shadow");
    }

    public String getTop() {
        throw this.createUnsupportedPropertyException("top");
    }

    public void setTop(String top) throws DOMException {
        throw this.createUnsupportedPropertyException("top");
    }

    public String getUnicodeBidi() {
        throw this.createUnsupportedPropertyException("unicode-bidi");
    }

    public void setUnicodeBidi(String unicodeBidi) throws DOMException {
        throw this.createUnsupportedPropertyException("unicode-bidi");
    }

    public String getVisibility() {
        throw this.createUnsupportedPropertyException("visibility");
    }

    public void setVisibility(String visibility) throws DOMException {
        throw this.createUnsupportedPropertyException("visibility");
    }

    public String getVoiceFamily() {
        throw this.createUnsupportedPropertyException("voice-family");
    }

    public void setVoiceFamily(String voiceFamily) throws DOMException {
        throw this.createUnsupportedPropertyException("voice-family");
    }

    public String getVolume() {
        throw this.createUnsupportedPropertyException("volumn");
    }

    public void setVolume(String volume) throws DOMException {
        throw this.createUnsupportedPropertyException("volumn");
    }

    public String getWidth() {
        throw this.createUnsupportedPropertyException("width");
    }

    public void setWidth(String width) throws DOMException {
        throw this.createUnsupportedPropertyException("width");
    }

    public String getZIndex() {
        throw this.createUnsupportedPropertyException("zindex");
    }

    public void setZIndex(String zIndex) throws DOMException {
        throw this.createUnsupportedPropertyException("zindex");
    }

    private DOMException createUnsupportedPropertyException(String property) {
        return new DOMException(9, property);
    }

    public void write(DataOutputStream out) throws IOException {
        CSSValue value;
        int validCount = 0;
        int i = 0;
        while (i < 60) {
            value = this.getProperty(i);
            if (value != null) {
                ++validCount;
            }
            ++i;
        }
        IOUtil.writeInt((OutputStream)out, (int)validCount);
        i = 0;
        while (i < 60) {
            value = this.getProperty(i);
            if (value != null) {
                IOUtil.writeString((DataOutputStream)out, (String)this.engine.getPropertyName(i));
                IOUtil.writeString((DataOutputStream)out, (String)value.getCssText());
            }
            ++i;
        }
    }

    public void read(DataInputStream in) throws IOException {
        int validCount = IOUtil.readInt((InputStream)in);
        int i = 0;
        while (i < validCount) {
            String propertyName = IOUtil.readString((DataInputStream)in);
            String propertyCssText = IOUtil.readString((DataInputStream)in);
            int index = this.getPropertyIndex(propertyName);
            this.setCssText(index, propertyCssText);
            ++i;
        }
    }
}

