/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;

public class EmitterUtil {
    protected static Logger logger = Logger.getLogger(EmitterUtil.class.getName());

    public static OutputStream getOuputStream(IEmitterServices services, String defaultOutputFile) {
        FilterOutputStream out = null;
        Object fd = services.getOption("outputFile");
        File file = null;
        try {
            if (fd != null) {
                file = new File(fd.toString());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new BufferedOutputStream(new FileOutputStream(file));
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (out == null) {
            Object value = services.getOption("outputStream");
            if (value != null && value instanceof OutputStream) {
                Object closeOnExitValue = services.getOption("closeOutputStreamOnExit");
                boolean closeOnExit = false;
                if (closeOnExitValue != null && closeOnExitValue instanceof Boolean) {
                    closeOnExit = (Boolean)closeOnExitValue;
                }
                out = new EmitterOutputStream((OutputStream)value, closeOnExit);
            } else {
                try {
                    file = new File(defaultOutputFile);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return out;
    }

    private static class EmitterOutputStream
    extends FilterOutputStream {
        private boolean closeOutputStreamOnExit;

        public EmitterOutputStream(OutputStream out, boolean closeOutputStreamOnExit) {
            super(out);
            this.closeOutputStreamOnExit = closeOutputStreamOnExit;
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {}
            if (this.closeOutputStreamOnExit) {
                this.out.close();
            }
        }
    }
}

