/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptLibHandle;

public class ApplicationClassLoader
extends ClassLoader {
    protected static Logger logger = Logger.getLogger(ApplicationClassLoader.class.getName());
    private URLClassLoader designClassLoader = null;
    private IReportRunnable runnable;
    private ExecutionContext executionContext = null;
    private ReportEngine engine;

    public ApplicationClassLoader(ReportEngine engine, IReportRunnable reportRunnable, ExecutionContext executionContext) {
        this.runnable = reportRunnable;
        this.engine = engine;
        this.executionContext = executionContext;
    }

    public void close() {
        if (this.designClassLoader != null) {
            this.designClassLoader.close();
            this.designClassLoader = null;
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        return this.designClassLoader.loadClass(className);
    }

    public URL getResource(String name) {
        if (this.designClassLoader == null) {
            this.createDesignClassLoader();
        }
        return this.designClassLoader.getResource(name);
    }

    protected synchronized void createDesignClassLoader() {
        if (this.designClassLoader != null) {
            return;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.runnable != null) {
            ModuleHandle module = (ModuleHandle)this.runnable.getDesignHandle();
            Iterator iter = module.scriptLibsIterator();
            while (iter.hasNext()) {
                ScriptLibHandle lib = (ScriptLibHandle)iter.next();
                String libPath = lib.getName();
                URL url = module.findResource(libPath, 2);
                if (url != null) {
                    urls.add(url);
                    continue;
                }
                if (this.executionContext != null) {
                    this.executionContext.addException(new EngineException("Error.JarNotFoundError", libPath));
                }
                logger.log(Level.SEVERE, "Can not find specified jar: " + libPath);
            }
        }
        URL[] jarUrls = urls.toArray(new URL[0]);
        this.designClassLoader = new URLClassLoader(jarUrls, this.engine.getEngineClassLoader());
    }
}

