/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.script.BirtHashMap;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.birt.core.script.CoreJavaScriptWrapper;
import org.eclipse.birt.core.script.IJavascriptWrapper;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.core.script.ScriptableParameters;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.ILinkedResult;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.executor.ApplicationClassLoader;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExtendedItemManager;
import org.eclipse.birt.report.engine.executor.IPageBreakListener;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionOptimize;
import org.eclipse.birt.report.engine.executor.optimize.ExecutionPolicy;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class ExecutionContext {
    protected static final int ERROR_TOTAL_COUNT = 60;
    private ReportEngine engine;
    private EngineTask task;
    private Logger log;
    private boolean presentationMode = false;
    private boolean factoryMode = true;
    private ScriptContext scriptContext;
    private IDataEngine dataEngine;
    private IReportExecutor executor;
    private TOCBuilder tocBuilder;
    protected ReportRunnable runnable;
    protected ReportRunnable originalRunnable;
    private Map configs = new BirtHashMap();
    private Map params = new BirtHashMap();
    private Map persistentBeans = new HashMap();
    private Map transientBeans = new HashMap();
    private ReportDocumentWriter docWriter;
    private Report reportIR;
    private Map appContext;
    private IReportContext reportContext;
    private IRenderOption renderOption;
    private Locale locale;
    private TimeZone timeZone;
    private IReportDocument reportDoc;
    private IReportContent reportContent;
    private ReportItemDesign design;
    private IContent content;
    private IBaseResultSet[] rsets;
    private Stack reportHandles = new Stack();
    private long totalPage;
    private long pageNumber;
    private long filteredTotalPage;
    private long filteredPageNumber;
    private long pageCount;
    private List onPrepareErrors = new ArrayList();
    private boolean isCancelled = false;
    private boolean cancelOnError = false;
    private HashMap stringFormatters = new HashMap();
    private HashMap numberFormatters = new HashMap();
    private HashMap dateFormatters = new HashMap();
    private ClassLoader applicationClassLoader;
    private boolean closeClassLoader;
    private int MAX_ERRORS = 100;
    private DocumentDataSource dataSource;
    private List pageBreakListeners;
    private ExtendedItemManager extendedItemManager = new ExtendedItemManager();
    private EngineExtensionManager engineExtensionManager = new EngineExtensionManager(this);
    private int maxRowsPerQuery = -1;
    protected HashMap elementExceptions = new HashMap();
    boolean isExecutingMasterPage = false;
    protected ExecutionPolicy executionPolicy;
    private String[] engineExts;
    private boolean enableProgreesiveViewing = true;

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(EngineTask engineTask) {
        if (engineTask != null) {
            this.task = engineTask;
            this.engine = (ReportEngine)this.task.getEngine();
            this.log = this.task.getLogger();
        } else {
            this.log = Logger.getLogger(ExecutionContext.class.getName());
        }
        this.locale = Locale.getDefault();
        this.timeZone = TimeZone.getDefault();
        this.pageCount = 0L;
    }

    private void initializeScriptContext() {
        Object scope;
        ScriptableObject rootScope = null;
        if (this.engine != null && (scope = this.engine.getRootScope()) instanceof ScriptableObject) {
            rootScope = (ScriptableObject)scope;
        }
        this.scriptContext = rootScope != null ? new ScriptContext(rootScope) : new ScriptContext();
        if (this.runnable != null && this.runnable instanceof ReportRunnable) {
            this.scriptContext.setCompiledScripts(this.runnable.getScriptCache());
        }
        Context context = this.scriptContext.getContext();
        context.setLocale(this.locale);
        this.initializeScriptContext(context, this.scriptContext.getRootScope());
        this.scriptContext.registerBean("report", (Object)new ReportObject());
        this.scriptContext.registerBean("params", (Object)new ScriptableParameters(this.params, this.scriptContext.getScope()));
        this.scriptContext.registerBean("config", (Object)this.configs);
        this.scriptContext.registerBean("currentPage", (Object)new Long(this.pageNumber));
        this.scriptContext.registerBean("totalPage", (Object)new Long(this.totalPage));
        this.scriptContext.registerBean("_jsContext", (Object)this);
        if (this.runnable != null) {
            this.registerDesign(this.runnable);
        }
        if (this.reportContext != null) {
            this.scriptContext.registerBean("reportContext", (Object)this.reportContext);
        }
        this.scriptContext.getContext().setLocale(this.locale);
        this.scriptContext.registerBean("pageNumber", (Object)new Long(this.pageNumber));
        this.scriptContext.registerBean("totalPage", (Object)new Long(this.totalPage));
        if (this.transientBeans != null) {
            for (Map.Entry entry : this.transientBeans.entrySet()) {
                this.scriptContext.registerBean((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.persistentBeans != null) {
            for (Map.Entry entry : this.persistentBeans.entrySet()) {
                this.registerInRoot((String)entry.getKey(), entry.getValue());
            }
        }
        this.scriptContext.setApplicationClassLoader(this.getApplicationClassLoader());
    }

    protected void initializeScriptContext(Context cx, Scriptable scope) {
        WrapFactory factory = new WrapFactory(){
            protected IJavascriptWrapper coreWrapper = new CoreJavaScriptWrapper();

            public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
                Object object = this.coreWrapper.wrap(cx, scope, obj, staticType);
                if (object != obj) {
                    return object;
                }
                return super.wrap(cx, scope, obj, staticType);
            }
        };
        this.scriptContext.getContext().setWrapFactory(factory);
        new CoreJavaScriptInitializer().initialize(cx, scope);
    }

    public ReportEngine getEngine() {
        return this.engine;
    }

    public void close() {
        if (this.extendedItemManager != null) {
            this.extendedItemManager.close();
            this.extendedItemManager = null;
        }
        if (this.engineExtensionManager != null) {
            this.engineExtensionManager.close();
            this.engineExtensionManager = null;
        }
        if (this.scriptContext != null) {
            this.scriptContext.exit();
            this.scriptContext = null;
        }
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Failed to close the data source", e);
            }
            this.dataSource = null;
        }
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
        if (this.closeClassLoader && this.applicationClassLoader instanceof ApplicationClassLoader) {
            ((ApplicationClassLoader)this.applicationClassLoader).close();
        }
        this.closeClassLoader = false;
        this.applicationClassLoader = null;
    }

    public void newScope() {
        this.getScriptContext().enterScope();
    }

    public void newScope(Object object) {
        ScriptContext scriptContext = this.getScriptContext();
        Object jsObject = scriptContext.javaToJs(object);
        if (jsObject instanceof Scriptable) {
            NativeObject nativeObj = new NativeObject();
            nativeObj.setPrototype((Scriptable)jsObject);
            scriptContext.enterScope((Scriptable)nativeObj);
        } else {
            scriptContext.enterScope();
        }
    }

    public void exitScope() {
        this.getScriptContext().exitScope();
    }

    public void registerBeans(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null) continue;
                String key = keyObj.toString();
                this.registerBean(key, value);
            }
        }
    }

    public void registerBean(String name, Object value) {
        this.transientBeans.put(name, value);
        if (this.scriptContext != null) {
            this.scriptContext.registerBean(name, value);
        }
    }

    public void unregisterBean(String name) {
        this.transientBeans.remove(name);
        if (this.scriptContext != null) {
            this.scriptContext.registerBean(name, null);
        }
    }

    public Map getBeans() {
        return this.transientBeans;
    }

    public void registerGlobalBeans(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object keyObj = entry.getKey();
                Object value = entry.getValue();
                if (keyObj == null || !(value instanceof Serializable)) continue;
                String key = keyObj.toString();
                this.registerGlobalBean(key, (Serializable)value);
            }
        }
    }

    public void registerGlobalBean(String name, Serializable value) {
        this.persistentBeans.put(name, value);
        if (this.scriptContext != null) {
            this.registerInRoot(name, value);
        }
    }

    public void unregisterGlobalBean(String name) {
        this.persistentBeans.remove(name);
        if (this.scriptContext != null) {
            this.registerInRoot(name, null);
        }
    }

    public Map getGlobalBeans() {
        return this.persistentBeans;
    }

    private void registerInRoot(String name, Object value) {
        Scriptable root = this.scriptContext.getRootScope();
        Object sObj = Context.javaToJS((Object)value, (Scriptable)root);
        root.put(name, root, sObj);
    }

    public Object evaluate(ScriptExpression expr) throws BirtException {
        if (expr != null && expr.getScriptText() != null) {
            return this.getScriptContext().eval(expr);
        }
        return null;
    }

    public Object evaluate(String scriptText) throws BirtException {
        return this.getScriptContext().eval(scriptText);
    }

    public Object evaluateCondExpr(IConditionalExpression expr) throws BirtException {
        IScriptExpression testExpr = expr.getExpression();
        ScriptContext scriptContext = this.getScriptContext();
        if (testExpr == null) {
            return Boolean.FALSE;
        }
        try {
            return ScriptEvalUtil.evalExpr((IBaseExpression)expr, (ScriptContext)scriptContext, (Scriptable)scriptContext.getScope(), (String)ScriptExpression.defaultID, (int)0);
        }
        catch (Throwable e) {
            throw new EngineException("Error.InvalidExpressionError", testExpr.getText(), e);
        }
    }

    public void execute(ScriptExpression expr) {
        try {
            this.evaluate(expr);
        }
        catch (BirtException ex) {
            this.addException(this.design, ex);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.scriptContext != null) {
            this.scriptContext.getContext().setLocale(locale);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void openDataEngine() {
        if (this.dataEngine == null) {
            try {
                this.dataEngine = DataEngineFactory.getInstance().createDataEngine(this);
            }
            catch (BirtException bex) {
                this.addException(bex);
            }
            catch (Exception ex) {
                this.addException(new EngineException(ex.getLocalizedMessage(), ex));
            }
        }
    }

    public IDataEngine getDataEngine() {
        if (this.dataEngine == null) {
            this.openDataEngine();
        }
        return this.dataEngine;
    }

    public void closeDataEngine() {
        if (this.dataEngine != null) {
            this.dataEngine.shutdown();
            this.dataEngine = null;
        }
    }

    public void setParameterValue(String name, Object value) {
        Object parameter = this.params.get(name);
        if (parameter instanceof ParameterAttribute) {
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.params.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setParameter(String name, Object value, String displayText) {
        this.params.put(name, new ParameterAttribute(value, displayText));
    }

    public void clearParameters() {
        this.params.clear();
    }

    public Object getParameterValue(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getValue();
        }
        return null;
    }

    public Map getParameterValues() {
        HashMap result = new HashMap();
        Set entries = this.params.entrySet();
        for (Map.Entry entry : entries) {
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Map getParameterDisplayTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        Set entries = this.params.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            ParameterAttribute value = (ParameterAttribute)entry.getValue();
            result.put(name, value.getDisplayText());
        }
        return result;
    }

    public String getParameterDisplayText(String name) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayText(String name, String displayText) {
        Object parameter = this.params.get(name);
        if (parameter != null) {
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        }
    }

    public Map getConfigs() {
        return this.configs;
    }

    public ReportDesignHandle getDesign() {
        return (ReportDesignHandle)this.runnable.getDesignHandle();
    }

    public IReportContent getReportContent() {
        return this.reportContent;
    }

    public void setReportContent(IReportContent content) {
        this.reportContent = content;
        content.getErrors().addAll(this.onPrepareErrors);
    }

    public void loadScript(String fileName) {
        ReportDesignHandle reportDesign = this.getDesign();
        URL url = null;
        if (reportDesign != null) {
            url = reportDesign.findResource(fileName, 2);
        }
        if (url == null) {
            this.log.log(Level.SEVERE, "loading external script file " + fileName + " failed.");
            this.addException(new EngineException("Error.ScriptFileLoadError", fileName));
            return;
        }
        try {
            InputStream in = url.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int size = in.read(buffer);
            while (size != -1) {
                out.write(buffer, 0, size);
                size = in.read(buffer);
            }
            byte[] script = out.toByteArray();
            ScriptExpression scriptExpr = new ScriptExpression(new String(script, "UTF-8"), fileName, 1);
            this.execute(scriptExpr);
            in.close();
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "loading external script file " + fileName + " failed.", ex);
            this.addException(new EngineException("Error.ScriptFileLoadError", url.toString(), (Throwable)ex));
        }
    }

    public Scriptable getScope() {
        return this.getScriptContext().getScope();
    }

    public Scriptable getSharedScope() {
        return this.getScriptContext().getSharedScope();
    }

    public ScriptContext getScriptContext() {
        if (this.scriptContext == null) {
            this.initializeScriptContext();
        }
        return this.scriptContext;
    }

    public IContent getContent() {
        return this.content;
    }

    public void setContent(IContent content) {
        this.content = content;
    }

    public ReportItemDesign getItemDesign() {
        return this.design;
    }

    public void setItemDesign(ReportItemDesign design) {
        this.design = design;
    }

    public void pushHandle(DesignElementHandle obj) {
        this.reportHandles.push(obj);
    }

    public DesignElementHandle popHandle() {
        return (DesignElementHandle)this.reportHandles.pop();
    }

    public DesignElementHandle getHandle() {
        if (this.reportHandles.empty()) {
            return null;
        }
        return (DesignElementHandle)this.reportHandles.peek();
    }

    public void addException(BirtException ex) {
        ReportDesignHandle handle = this.getDesign();
        if (this.design != null) {
            handle = this.design.getHandle();
        }
        this.addException((DesignElementHandle)handle, ex);
    }

    public void addException(ReportElementDesign design, BirtException ex) {
        DesignElementHandle handle = null;
        if (design != null) {
            handle = design.getHandle();
        }
        this.addException(handle, ex);
    }

    public void addException(DesignElementHandle element, BirtException ex) {
        ElementExceptionInfo exInfo = (ElementExceptionInfo)this.elementExceptions.get(element);
        if (exInfo == null) {
            exInfo = new ElementExceptionInfo(element);
            if (this.reportContent != null) {
                if (this.reportContent.getErrors().size() < 60) {
                    this.reportContent.getErrors().add(exInfo);
                }
            } else if (this.onPrepareErrors.size() < 60) {
                this.onPrepareErrors.add(exInfo);
            }
            if (this.elementExceptions.size() < 60) {
                this.elementExceptions.put(element, exInfo);
            }
        }
        EngineException engineEx = null;
        engineEx = ex instanceof EngineException ? (EngineException)ex : new EngineException(ex);
        if (element != null) {
            engineEx.setElementID(element.getID());
        }
        exInfo.addException(engineEx);
        if (this.cancelOnError && this.task != null) {
            this.task.cancel();
        }
    }

    public ReportRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(IReportRunnable runnable) {
        this.runnable = (ReportRunnable)runnable;
        if (this.scriptContext != null) {
            this.scriptContext.setCompiledScripts(((ReportRunnable)runnable).getScriptCache());
            this.registerDesign(runnable);
        }
    }

    public void updateRunnable(IReportRunnable newRunnable) {
        if (this.originalRunnable == null) {
            this.originalRunnable = this.runnable;
        }
        this.runnable = (ReportRunnable)newRunnable;
        if (this.scriptContext != null) {
            this.scriptContext.setCompiledScripts(this.runnable.getScriptCache());
            this.registerDesign(this.runnable);
        }
        this.reportIR = null;
    }

    public ReportRunnable getOriginalRunnable() {
        if (this.originalRunnable != null) {
            return this.originalRunnable;
        }
        return this.runnable;
    }

    private void registerDesign(IReportRunnable runnable) {
        ReportDesignHandle reportDesign = (ReportDesignHandle)runnable.getDesignHandle();
        IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)reportDesign);
        this.scriptContext.registerBean("design", (Object)element);
    }

    public IRenderOption getRenderOption() {
        return this.renderOption;
    }

    public void setRenderOption(IRenderOption renderOption) {
        this.renderOption = renderOption;
    }

    public String getOutputFormat() {
        if (this.renderOption != null) {
            return this.renderOption.getOutputFormat();
        }
        return "html";
    }

    public Map getAppContext() {
        return this.appContext;
    }

    public void setAppContext(Map appContext) {
        this.appContext = appContext;
    }

    public IReportContext getReportContext() {
        return this.reportContext;
    }

    public void setReportContext(IReportContext reportContext) {
        this.reportContext = reportContext;
        if (this.scriptContext != null) {
            this.scriptContext.registerBean("reportContext", (Object)reportContext);
        }
    }

    public void setPageNumber(long pageNo) {
        this.pageNumber = pageNo;
        if (this.scriptContext != null) {
            this.scriptContext.registerBean("pageNumber", (Object)new Long(this.pageNumber));
        }
        if (this.totalPage < this.pageNumber) {
            this.setTotalPage(this.pageNumber);
        }
    }

    public void setTotalPage(long totalPage) {
        if (totalPage > this.totalPage) {
            this.totalPage = totalPage;
            if (this.scriptContext != null) {
                this.scriptContext.registerBean("totalPage", (Object)new Long(totalPage));
            }
            if (this.reportContent instanceof ReportContent) {
                ((ReportContent)this.reportContent).setTotalPage(totalPage);
            }
        }
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setFilteredPageNumber(long pageNo) {
        this.filteredPageNumber = pageNo;
    }

    public void setFilteredTotalPage(long totalPage) {
        this.filteredTotalPage = totalPage;
    }

    public long getFilteredPageNumber() {
        if (this.filteredPageNumber <= 0L) {
            return this.pageNumber;
        }
        return this.filteredPageNumber;
    }

    public long getFilteredTotalPage() {
        if (this.filteredTotalPage <= 0L) {
            return this.totalPage;
        }
        return this.filteredTotalPage;
    }

    public boolean isInFactory() {
        return this.factoryMode;
    }

    public boolean isInPresentation() {
        return this.presentationMode;
    }

    public void setFactoryMode(boolean mode) {
        this.factoryMode = mode;
    }

    public boolean getFactoryMode() {
        return this.factoryMode;
    }

    public void setPresentationMode(boolean mode) {
        this.presentationMode = mode;
    }

    public StringFormatter getStringFormatter(String value) {
        StringFormatter fmt = (StringFormatter)this.stringFormatters.get(value);
        if (fmt == null) {
            fmt = new StringFormatter(value, ULocale.forLocale((Locale)this.locale));
            this.stringFormatters.put(value, fmt);
        }
        return fmt;
    }

    public NumberFormatter getNumberFormatter(String value) {
        NumberFormatter fmt = (NumberFormatter)this.numberFormatters.get(value);
        if (fmt == null) {
            fmt = new NumberFormatter(value, ULocale.forLocale((Locale)this.locale));
            this.numberFormatters.put(value, fmt);
        }
        return fmt;
    }

    public DateFormatter getDateFormatter(String value) {
        DateFormatter fmt = null;
        if (value != null) {
            fmt = (DateFormatter)this.dateFormatters.get(value);
            if (fmt == null) {
                fmt = new DateFormatter(value, ULocale.forLocale((Locale)this.locale), this.timeZone);
                this.dateFormatters.put(value, fmt);
            }
            return fmt;
        }
        return new DateFormatter(value, ULocale.forLocale((Locale)this.locale), this.timeZone);
    }

    public void setExecutor(IReportExecutor executor) {
        this.executor = executor;
    }

    public IReportExecutor getExecutor() {
        return this.executor;
    }

    public TOCBuilder getTOCBuilder() {
        return this.tocBuilder;
    }

    public void setTOCBuilder(TOCBuilder builder) {
        this.tocBuilder = builder;
    }

    public void setReportDocument(IReportDocument doc) {
        this.reportDoc = doc;
    }

    public IReportDocument getReportDocument() {
        return this.reportDoc;
    }

    public void setReportDocWriter(ReportDocumentWriter docWriter) {
        this.docWriter = docWriter;
    }

    public ReportDocumentWriter getReportDocWriter() {
        return this.docWriter;
    }

    public IHTMLActionHandler getActionHandler() {
        return this.renderOption.getActionHandler();
    }

    public IHTMLImageHandler getImageHandler() {
        return this.renderOption.getImageHandler();
    }

    public ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            this.closeClassLoader = true;
            this.applicationClassLoader = new ApplicationClassLoader(this.engine, this.runnable, this);
            if (this.scriptContext != null) {
                this.scriptContext.setApplicationClassLoader(this.applicationClassLoader);
            }
        }
        return this.applicationClassLoader;
    }

    public void setApplicationClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("null classloader");
        }
        if (this.closeClassLoader && this.applicationClassLoader instanceof ApplicationClassLoader) {
            ((ApplicationClassLoader)this.applicationClassLoader).close();
        }
        this.closeClassLoader = false;
        this.applicationClassLoader = classLoader;
        if (this.scriptContext != null) {
            this.scriptContext.setApplicationClassLoader(this.applicationClassLoader);
        }
    }

    public void cancel() {
        DataRequestSession session;
        this.isCancelled = true;
        if (this.dataEngine != null && (session = this.dataEngine.getDTESession()) != null) {
            session.cancel();
        }
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public void setCancelOnError(boolean cancel) {
        this.cancelOnError = cancel;
    }

    public void setDataSource(DocumentDataSource dataSource) throws IOException {
        this.dataSource = dataSource;
        this.dataSource.open();
    }

    public DocumentDataSource getDataSource() {
        return this.dataSource;
    }

    public IBaseResultSet executeQuery(IBaseResultSet parent, IDataQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IDataEngine dataEngine = this.getDataEngine();
        return dataEngine.execute(parent, query, queryOwner, useCache);
    }

    public IBaseResultSet getResultSet() {
        if (this.rsets != null) {
            return this.rsets[0];
        }
        return null;
    }

    public void setResultSet(IBaseResultSet rset) {
        if (rset != null) {
            if (this.rsets != null && this.rsets.length == 1 && this.rsets[0] == rset) {
                return;
            }
            this.setResultSets(new IBaseResultSet[]{rset});
        } else {
            this.setResultSets(null);
        }
    }

    public IBaseResultSet[] getResultSets() {
        return this.rsets;
    }

    public void setResultSets(IBaseResultSet[] rsets) {
        if (this.rsets == rsets) {
            return;
        }
        if (rsets != null) {
            this.rsets = rsets;
            if (rsets[0] != null) {
                Scriptable scope = this.getScriptContext().getRootScope();
                DataAdapterUtil.registerJSObject((Scriptable)scope, (ILinkedResult)new ResultIteratorTree(rsets[0]));
            }
        } else {
            this.rsets = null;
        }
    }

    public boolean hasErrors() {
        return !this.elementExceptions.isEmpty();
    }

    public List getErrors() {
        List errors = this.getAllErrors();
        if (errors.size() > this.MAX_ERRORS) {
            errors = errors.subList(0, this.MAX_ERRORS - 1);
        }
        return errors;
    }

    public List getAllErrors() {
        ArrayList errors = new ArrayList();
        for (Map.Entry entry : this.elementExceptions.entrySet()) {
            ArrayList elementExceptions = ((ElementExceptionInfo)entry.getValue()).getErrorList();
            errors.addAll(elementExceptions);
        }
        return errors;
    }

    public int getMaxErrors() {
        return this.MAX_ERRORS;
    }

    public void setMaxErrors(int maxErrors) {
        this.MAX_ERRORS = maxErrors;
    }

    public void setExecutingMasterPage(boolean isExecutingMasterPage) {
        this.isExecutingMasterPage = isExecutingMasterPage;
    }

    public boolean isExecutingMasterPage() {
        return this.isExecutingMasterPage;
    }

    public void addPageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners == null) {
            this.pageBreakListeners = new ArrayList();
        }
        this.pageBreakListeners.add(listener);
    }

    public void firePageBreakEvent() {
        if (this.pageBreakListeners != null) {
            int i = 0;
            while (i < this.pageBreakListeners.size()) {
                ((IPageBreakListener)this.pageBreakListeners.get(i)).onPageBreak();
                ++i;
            }
        }
    }

    public void removePageBreakListener(IPageBreakListener listener) {
        if (this.pageBreakListeners != null) {
            this.pageBreakListeners.remove(listener);
        }
    }

    public IEngineTask getEngineTask() {
        return this.task;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void optimizeExecution() {
        String[] engineExts;
        if (this.task != null && this.task.getTaskType() == 1 && ((engineExts = this.getEngineExtensions()) == null || engineExts.length == 0)) {
            this.executionPolicy = new ExecutionOptimize().optimize(this.getReport());
        }
    }

    public ExecutionPolicy getExecutionPolicy() {
        return this.executionPolicy;
    }

    public Report getReport() {
        if (this.reportIR != null) {
            return this.reportIR;
        }
        if (this.runnable != null) {
            this.reportIR = new ReportParser().parse((ReportDesignHandle)this.runnable.getDesignHandle());
        }
        return this.reportIR;
    }

    public void setReport(Report reportIR) {
        this.reportIR = reportIR;
    }

    public URL getResource(String resourceName) {
        if (this.getDesign() != null) {
            return this.getDesign().findResource(resourceName, 0);
        }
        return null;
    }

    public ExtendedItemManager getExtendedItemManager() {
        return this.extendedItemManager;
    }

    public EngineExtensionManager getEngineExtensionManager() {
        return this.engineExtensionManager;
    }

    public void setMaxRowsPerQuery(int maxRows) {
        if (maxRows >= 0) {
            this.maxRowsPerQuery = maxRows;
        }
    }

    public int getMaxRowsPerQuery() {
        return this.maxRowsPerQuery;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public String[] getEngineExtensions() {
        String engineExtensions;
        if (this.engineExts != null) {
            return this.engineExts;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        ReportDesignHandle design = this.getDesign();
        if (design.isEnableACL()) {
            resultList.add("PLS");
        }
        if ((engineExtensions = (String)design.getProperty("Engine extensions")) != null) {
            String[] exts;
            String[] stringArray = exts = engineExtensions.split(",");
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext != null && (ext = ext.trim()).length() > 0) {
                    resultList.add(ext);
                }
                ++n2;
            }
        }
        this.engineExts = resultList.toArray(new String[resultList.size()]);
        return this.engineExts;
    }

    public void enableProgressiveViewing(boolean enabled) {
        this.enableProgreesiveViewing = enabled;
    }

    public boolean isProgressiveViewingEnable() {
        return this.enableProgreesiveViewing;
    }

    public class ElementExceptionInfo {
        DesignElementHandle element;
        ArrayList exList = new ArrayList();
        ArrayList countList = new ArrayList();

        public ElementExceptionInfo(DesignElementHandle element) {
            this.element = element;
        }

        public void addException(BirtException e) {
            int i = 0;
            while (i < this.exList.size()) {
                BirtException err = (BirtException)((Object)this.exList.get(i));
                if (e.getErrorCode() != null && e.getErrorCode().equals(err.getErrorCode()) && e.getLocalizedMessage() != null && e.getLocalizedMessage().equals(err.getLocalizedMessage())) {
                    this.countList.set(i, new Integer((Integer)this.countList.get(i) + 1));
                    return;
                }
                ++i;
            }
            this.exList.add(e);
            this.countList.add(new Integer(1));
        }

        public String getType() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getDefn().getName();
        }

        public String getName() {
            if (this.element == null) {
                return "report";
            }
            return this.element.getName();
        }

        public String getID() {
            if (this.element == null) {
                return null;
            }
            return String.valueOf(this.element.getID());
        }

        public ArrayList getErrorList() {
            return this.exList;
        }

        public ArrayList getCountList() {
            return this.countList;
        }
    }

    public class ReportObject {
        public Object getDesign() {
            try {
                return ExecutionContext.this.getScriptContext().eval("design");
            }
            catch (BirtException ex) {
                ExecutionContext.this.addException(ex);
                return null;
            }
        }

        public Object getDocument() {
            return ExecutionContext.this.reportDoc;
        }

        public Map getParams() {
            return ExecutionContext.this.params;
        }

        public Object getDataSets() {
            try {
                return ExecutionContext.this.getScriptContext().eval("design.dataSets");
            }
            catch (BirtException ex) {
                ExecutionContext.this.addException(ex);
                return null;
            }
        }

        public Object getDataSources() {
            try {
                return ExecutionContext.this.getScriptContext().eval("design.dataSources");
            }
            catch (BirtException ex) {
                ExecutionContext.this.addException(ex);
                return null;
            }
        }

        public Map getConfig() {
            return ExecutionContext.this.configs;
        }

        public Object getReportContext() {
            return ExecutionContext.this.reportContext;
        }
    }

    private class ResultIteratorTree
    implements ILinkedResult {
        IBaseResultSet currentRset;
        int resultType = -1;

        public ResultIteratorTree(IBaseResultSet rset) {
            this.currentRset = rset;
            if (rset instanceof IQueryResultSet) {
                this.resultType = 2;
            } else if (rset instanceof ICubeResultSet) {
                this.resultType = 1;
            }
        }

        public ILinkedResult getParent() {
            return new ResultIteratorTree(this.currentRset.getParent());
        }

        public Object getCurrentResult() {
            if (this.resultType == 2) {
                return ((IQueryResultSet)this.currentRset).getResultIterator();
            }
            if (this.resultType == 1) {
                return ((ICubeResultSet)this.currentRset).getCubeCursor();
            }
            return null;
        }

        public int getCurrentResultType() {
            return this.resultType;
        }
    }
}

