/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.script.internal.OnPageBreakScriptVisitor;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    protected ExecutionContext executionContext;
    protected IContentEmitter emitter;
    protected HashMap designs = new HashMap();
    protected LinkedContent firstContent;
    protected LinkedContent lastContent;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.emitter = new PageContentEmitter();
        this.firstContent = new LinkedContent();
        this.firstContent.next = this.lastContent = new LinkedContent();
        this.lastContent.prev = this.firstContent;
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected void addContent(IContent content) {
        if (content == null) {
            return;
        }
        Object generateBy = content.getGenerateBy();
        if (!(generateBy instanceof ReportItemDesign)) {
            return;
        }
        ReportItemDesign design = (ReportItemDesign)generateBy;
        if (design.getOnPageBreak() != null || design.getJavaClass() != null) {
            LinkedContent cachedContent = (LinkedContent)this.designs.get(design);
            if (cachedContent != null) {
                LinkedContent next;
                LinkedContent prev = cachedContent.prev;
                prev.next = next = cachedContent.next;
                next.prev = prev;
            } else {
                cachedContent = new LinkedContent();
            }
            cachedContent.content = content;
            cachedContent.prev = this.lastContent.prev;
            this.lastContent.prev.next = cachedContent;
            cachedContent.next = this.lastContent;
            this.lastContent.prev = cachedContent;
            this.designs.put(design, cachedContent);
        }
    }

    public void onPage(long page, Object context) {
        if (this.executionContext == null) {
            return;
        }
        OnPageBreakScriptVisitor onPageBreakVisitor = new OnPageBreakScriptVisitor(this.executionContext);
        LinkedContent nextContent = this.firstContent.next;
        while (nextContent != this.lastContent) {
            IContent content = nextContent.content;
            nextContent = nextContent.next;
            onPageBreakVisitor.onPageBreak(content);
        }
        this.firstContent.next = this.lastContent;
        this.lastContent.prev = this.firstContent;
        this.designs.clear();
    }

    private class LinkedContent {
        IContent content;
        LinkedContent next;
        LinkedContent prev;

        private LinkedContent() {
        }
    }

    private class PageBreakContentCollector
    implements IAreaVisitor {
        private PageBreakContentCollector() {
        }

        public void visitText(ITextArea textArea) {
            OnPageBreakLayoutPageHandle.this.addContent(textArea.getContent());
        }

        public void visitAutoText(ITemplateArea templateArea) {
            OnPageBreakLayoutPageHandle.this.addContent(templateArea.getContent());
        }

        public void visitImage(IImageArea imageArea) {
            OnPageBreakLayoutPageHandle.this.addContent(imageArea.getContent());
        }

        public void visitContainer(IContainerArea container) {
            OnPageBreakLayoutPageHandle.this.addContent(container.getContent());
            Iterator iter = container.getChildren();
            while (iter.hasNext()) {
                IArea child = (IArea)iter.next();
                child.accept(this);
            }
        }
    }

    private class PageContentEmitter
    extends ContentEmitterAdapter {
        private PageContentEmitter() {
        }

        public void startPage(IPageContent page) {
            Object ext = page.getExtension(1);
            if (ext instanceof PageArea) {
                PageArea pageArea = (PageArea)ext;
                IContainerArea container = pageArea.getBody();
                container.accept(new PageBreakContentCollector());
            }
        }

        public void startContent(IContent content) {
            OnPageBreakLayoutPageHandle.this.addContent(content);
        }
    }
}

