/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;

public class CachedReportContentReaderV3 {
    protected ReportContentReaderV3 reader;
    protected HashMap caches = new HashMap();

    public CachedReportContentReaderV3(ReportContent reportContent, RAInputStream stream, ExecutionContext context) throws IOException {
        this.reader = new ReportContentReaderV3(reportContent, stream, context.getApplicationClassLoader());
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.caches.clear();
            this.reader = null;
        }
    }

    protected void addCache(long offset, IContent content) {
        this.caches.put(new Long(offset), new CacheEntry(offset, content));
    }

    protected void removeCache(long offset) {
        Long hashKey = new Long(offset);
        this.caches.remove(hashKey);
    }

    protected IContent findCache(long offset) {
        Long hashKey = new Long(offset);
        CacheEntry cache = (CacheEntry)this.caches.get(hashKey);
        if (cache != null) {
            return cache.content;
        }
        return null;
    }

    public void unloadContent(long offset) {
        this.removeCache(offset);
    }

    public IContent loadContent(long offset) throws IOException {
        IContent content = this.findCache(offset);
        if (content != null) {
            return content;
        }
        content = this.reader.readContent(offset);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        long pOffset = docExt.getParent();
        if (pOffset != -1L) {
            IContent parent = this.loadContent(pOffset);
            content.setParent(parent);
        }
        this.addCache(offset, content);
        return content;
    }

    protected class CacheEntry {
        long offset;
        IContent content;

        public CacheEntry(long offset, IContent content) {
            this.offset = offset;
            this.content = content;
        }
    }
}

