/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportBodyExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;

public class ReportletBodyExecutor
implements IReportItemExecutor {
    long offset;
    IReportItemExecutor bodyExecutor;
    ArrayList<IReportItemExecutor> parentExecutors = new ArrayList();
    IContent bodyContent;
    IReportItemExecutor childExecutor;

    ReportletBodyExecutor(ExecutorManager manager, Fragment fragment, long offset) {
        this.bodyExecutor = new ReportBodyExecutor(manager, fragment);
        this.offset = offset;
        this.parentExecutors.add(this.bodyExecutor);
        this.childExecutor = this.bodyExecutor;
    }

    public void close() {
        if (!this.parentExecutors.isEmpty()) {
            for (IReportItemExecutor executor : this.parentExecutors) {
                executor.close();
            }
            this.parentExecutors.clear();
        }
        this.bodyExecutor = null;
        this.childExecutor = null;
    }

    protected void doExecute() {
        IReportItemExecutor executor = this.bodyExecutor;
        while (executor.hasNextChild()) {
            executor = executor.getNextChild();
            this.parentExecutors.add(executor);
            IContent content = executor.execute();
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt == null || docExt.getIndex() != this.offset) continue;
            this.bodyContent = content;
            this.childExecutor = executor;
            break;
        }
    }

    public IContent execute() {
        if (this.bodyContent == null) {
            this.doExecute();
        }
        return this.bodyContent;
    }

    public IContent getContent() {
        return this.bodyContent;
    }

    public IExecutorContext getContext() {
        return this.bodyExecutor.getContext();
    }

    public Object getModelObject() {
        return this.bodyExecutor.getModelObject();
    }

    public IReportItemExecutor getNextChild() {
        if (this.childExecutor != null) {
            IReportItemExecutor executor = this.childExecutor;
            this.childExecutor = null;
            return executor;
        }
        return null;
    }

    public IReportItemExecutor getParent() {
        return null;
    }

    public IBaseResultSet[] getQueryResults() {
        return null;
    }

    public boolean hasNextChild() {
        return this.childExecutor != null;
    }

    public void setContext(IExecutorContext context) {
    }

    public void setModelObject(Object handle) {
    }

    public void setParent(IReportItemExecutor parent) {
    }
}

