/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class ReportItemReader
implements IReportItemExecutor {
    protected ExecutionContext context;
    protected CachedReportContentReaderV3 reader;
    protected ReportItemReader parent;
    protected Fragment fragment;
    long offset;
    IContent content;
    long child;
    IBaseResultSet[] rsets;
    protected IContentVisitor initalizeContentVisitor = new ContentVisitorAdapter(){

        public Object visitLabel(ILabelContent label, Object value) {
            if (label.getGenerateBy() instanceof TemplateDesign) {
                TemplateDesign design = (TemplateDesign)label.getGenerateBy();
                label.setLabelKey(design.getPromptTextKey());
                label.setLabelText(design.getPromptText());
            }
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            if (autoText.getType() == 0) {
                autoText.setText(String.valueOf(ReportItemReader.this.context.getTotalPage()));
            }
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            Report report = ReportItemReader.this.context.getReport();
            int colCount = table.getColumnCount();
            int i = 0;
            while (i < colCount) {
                IColumn col = table.getColumn(i);
                InstanceID id = col.getInstanceID();
                if (id != null) {
                    long cid = id.getComponentID();
                    ColumnDesign colDesign = (ColumnDesign)report.getReportItemByID(cid);
                    col.setGenerateBy(colDesign);
                }
                ++i;
            }
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            String bindingColumn;
            DataItemDesign design;
            if (data.getGenerateBy() instanceof DataItemDesign && (design = (DataItemDesign)data.getGenerateBy()).getMap() == null && (bindingColumn = design.getBindingColumn()) != null) {
                IBaseResultSet rset = ReportItemReader.this.context.getResultSet();
                if (rset instanceof IQueryResultSet) {
                    try {
                        Object dataValue = ((IQueryResultSet)rset).getValue(bindingColumn);
                        data.setValue(dataValue);
                    }
                    catch (BirtException ex) {
                        ReportItemReader.this.context.addException(design.getHandle(), ex);
                    }
                } else if (rset instanceof ICubeResultSet) {
                    try {
                        Object dataValue = ((ICubeResultSet)rset).getCubeCursor().getObject(bindingColumn);
                        data.setValue(dataValue);
                    }
                    catch (Exception exception) {}
                }
            }
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            int bandType = tableBand.getBandType();
            switch (bandType) {
                case 1: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getHeader());
                    break;
                }
                case 2: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getFooter());
                    break;
                }
                case 0: {
                    ITableContent table = this.getParentTable(tableBand);
                    Object genObj = table.getGenerateBy();
                    if (!(genObj instanceof TableItemDesign)) break;
                    TableItemDesign tableDesign = (TableItemDesign)genObj;
                    tableBand.setGenerateBy(tableDesign.getDetail());
                    break;
                }
                case 3: 
                case 4: {
                    this.setupGroupBand(tableBand);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return value;
        }

        ITableContent getParentTable(ITableBandContent band) {
            IContent parent = (IContent)band.getParent();
            while (parent != null) {
                if (parent instanceof ITableContent) {
                    return (ITableContent)parent;
                }
                parent = (IContent)parent.getParent();
            }
            return null;
        }

        IListContent getParentList(IListBandContent band) {
            IContent parent = (IContent)band.getParent();
            while (parent != null) {
                if (parent instanceof IListContent) {
                    return (IListContent)parent;
                }
                parent = (IContent)parent.getParent();
            }
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            int bandType = listBand.getBandType();
            switch (bandType) {
                case 1: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getHeader());
                    break;
                }
                case 2: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getFooter());
                    break;
                }
                case 0: {
                    IListContent list = this.getParentList(listBand);
                    Object genObj = list.getGenerateBy();
                    if (!(genObj instanceof ListItemDesign)) break;
                    ListItemDesign listDesign = (ListItemDesign)genObj;
                    listBand.setGenerateBy(listDesign.getDetail());
                    break;
                }
                case 3: 
                case 4: {
                    this.setupGroupBand(listBand);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            return value;
        }

        protected void setupGroupBand(IBandContent bandContent) {
            IGroupContent group;
            Object genBy;
            IContent parent = (IContent)bandContent.getParent();
            if (parent instanceof IGroupContent && (genBy = (group = (IGroupContent)parent).getGenerateBy()) instanceof GroupDesign) {
                GroupDesign groupDesign = (GroupDesign)genBy;
                int bandType = bandContent.getBandType();
                if (bandType == 3) {
                    bandContent.setGenerateBy(groupDesign.getHeader());
                } else {
                    bandContent.setGenerateBy(groupDesign.getFooter());
                }
            }
        }
    };

    ReportItemReader(ExecutionContext context) {
        this.context = context;
    }

    void initialize(ReportItemReader parent, long offset, Fragment frag) {
        assert (offset != -1L);
        this.parent = parent;
        if (parent != null) {
            this.reader = parent.reader;
        }
        this.offset = offset;
        this.content = null;
        this.child = -1L;
        this.rsets = null;
        this.fragment = frag;
    }

    public IContent getContent() {
        return this.content;
    }

    public IExecutorContext getContext() {
        throw new UnsupportedOperationException();
    }

    public Object getModelObject() {
        return null;
    }

    public IReportItemExecutor getParent() {
        return this.parent;
    }

    public IBaseResultSet[] getQueryResults() {
        return this.rsets;
    }

    public void setContext(IExecutorContext context) {
        throw new IllegalStateException("the caller should never call setContext() of system executor");
    }

    public void setModelObject(Object handle) {
        throw new IllegalStateException("the caller should never call setContext() of system executor");
    }

    public void setParent(IReportItemExecutor parent) {
        throw new IllegalStateException("the caller should never call setParent() of system executor");
    }

    public void close() {
        this.unloadContent();
    }

    public IContent execute() {
        try {
            this.loadContent();
            this.initializeContent();
        }
        catch (IOException ex) {
            this.context.addException(new EngineException(ex.getLocalizedMessage(), ex));
        }
        catch (BirtException bex) {
            this.context.addException(bex);
        }
        return this.content;
    }

    ReportItemReader createExecutor(ReportItemReader parent, long child, Fragment frag) {
        ReportItemReader reader = new ReportItemReader(this.context);
        reader.initialize(parent, this.offset, frag);
        return reader;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            try {
                Fragment childFrag = this.fragment == null ? null : this.fragment.getFragment(new Long(this.child));
                ReportItemReader childReader = this.createExecutor(this, this.child, childFrag);
                this.child = childReader.findNextSibling();
                if (this.child != -1L && this.fragment != null && !this.fragment.inFragment(new Long(this.child))) {
                    Fragment nextFragment = this.fragment.getNextFragment(new Long(this.child));
                    this.child = nextFragment != null ? (Long)nextFragment.index : -1L;
                }
                return childReader;
            }
            catch (IOException ex) {
                this.child = -1L;
                this.context.addException(new EngineException(ex.getLocalizedMessage(), ex));
            }
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.child != -1L;
    }

    protected long findFirstChild() throws IOException {
        this.loadContent();
        if (this.content != null) {
            DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
            long firstChild = docExt.getFirstChild();
            if (firstChild != -1L && this.fragment != null && !this.fragment.inFragment(new Long(firstChild))) {
                Fragment childFragment = this.fragment.getFirstFragment();
                if (childFragment != null) {
                    return (Long)childFragment.index;
                }
                return -1L;
            }
            return firstChild;
        }
        return -1L;
    }

    protected long findNextSibling() throws IOException {
        this.loadContent();
        if (this.content != null) {
            DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
            return docExt.getNext();
        }
        return -1L;
    }

    protected IBaseResultSet getResultSet() {
        if (this.rsets == null || this.rsets[0] == null) {
            if (this.parent != null) {
                return this.parent.getResultSet();
            }
            return null;
        }
        return this.rsets[0];
    }

    protected void loadContent() throws IOException {
        if (this.content == null) {
            this.content = this.reader.loadContent(this.offset);
            if (this.content != null) {
                DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
                this.child = docExt.getFirstChild();
                if (this.child != -1L && this.fragment != null && !this.fragment.inFragment(new Long(this.child))) {
                    Fragment childFragment = this.fragment.getFirstFragment();
                    this.child = childFragment != null ? (Long)childFragment.index : -1L;
                }
            }
        }
    }

    private void initializeContent() throws BirtException {
        long designId;
        assert (this.content != null);
        Report report = this.context.getReport();
        InstanceID id = this.content.getInstanceID();
        if (id != null && (designId = id.getComponentID()) != -1L) {
            ReportElementDesign generateBy = report.getReportItemByID(designId);
            this.content.setGenerateBy(generateBy);
            if (generateBy instanceof ReportItemDesign) {
                this.context.setItemDesign((ReportItemDesign)generateBy);
            }
        }
        this.context.setContent(this.content);
        if (this.fragment != null && this.hasNextChild()) {
            Object genBy = this.content.getGenerateBy();
            if (this.content instanceof ITableContent) {
                if (genBy instanceof TableItemDesign) {
                    TableItemDesign tableDesign = (TableItemDesign)genBy;
                    if (((ITableContent)this.content).isHeaderRepeat() && tableDesign.getHeader() != null) {
                        this.addHeaderToFragment(this.content);
                    }
                }
            } else if (this.content instanceof IGroupContent) {
                if (genBy instanceof GroupDesign) {
                    GroupDesign groupDesign = (GroupDesign)genBy;
                    if (((IGroupContent)this.content).isHeaderRepeat() && groupDesign.getHeader() != null) {
                        this.addHeaderToFragment(this.content);
                    }
                }
            } else if (this.content instanceof IListContent && genBy instanceof ListItemDesign) {
                ListItemDesign listDesign = (ListItemDesign)genBy;
                if (((IListContent)this.content).isHeaderRepeat() && listDesign.getHeader() != null) {
                    this.addHeaderToFragment(this.content);
                }
            }
        }
        IBaseResultSet prset = this.parent == null ? null : this.parent.getResultSet();
        this.context.setResultSet(prset);
        this.rsets = this.openQueries(prset, this.content);
        if (this.rsets != null) {
            this.context.setResultSets(this.rsets);
        }
        this.initalizeContentVisitor.visit(this.content, null);
    }

    private void addHeaderToFragment(IContent content) {
        long headerOffset;
        assert (this.fragment != null);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null && (headerOffset = docExt.getFirstChild()) != -1L) {
            this.fragment.addFragment(new Long[]{new Long(headerOffset)}, new Long[]{new Long(headerOffset)});
            Fragment headerFrag = this.fragment.getFragment(new Long(headerOffset));
            headerFrag.addFragment(new Object[]{Segment.LEFT_MOST_EDGE}, new Object[]{Segment.RIGHT_MOST_EDGE});
            this.child = headerOffset;
        }
    }

    protected void unloadContent() {
        if (this.rsets != null) {
            this.closeQueries(this.rsets);
            this.rsets = null;
        }
        this.reader.unloadContent(this.offset);
    }

    protected IBaseResultSet[] openQueries(IBaseResultSet rset, IContent content) throws BirtException {
        IBaseResultSet[] rsets = this.doOpenQueries(rset, content);
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ExtendedItemDesign) {
            if (rsets == null) {
                this.doPositionResultSet(rset, content);
            }
        } else {
            if (rsets != null) {
                rset = rsets[0];
            }
            this.doPositionResultSet(rset, content);
        }
        return rsets;
    }

    protected IBaseResultSet[] doOpenQueries(IBaseResultSet rset, IContent content) throws BirtException {
        IBaseResultSet[] rsets = null;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign) {
            DesignElementHandle itemHandle;
            ReportItemDesign design = (ReportItemDesign)generateBy;
            boolean useCache = design.useCachedResult();
            IDataQueryDefinition[] queries = design.getQueries();
            if (queries == null && (itemHandle = design.getHandle()) instanceof ReportElementHandle) {
                Report report = this.context.getReport();
                queries = report.getQueryByReportHandle((ReportElementHandle)itemHandle);
            }
            if (queries != null && queries.length > 0) {
                DataSetID dataSetId;
                DataID dataId;
                InstanceID iid = content.getInstanceID();
                if (iid != null && (dataId = iid.getDataID()) != null && (dataSetId = dataId.getDataSetID()) != null) {
                    DataSetID parentSetId = dataSetId.getParentID();
                    if (rset != null) {
                        IBaseResultSet qRset;
                        if (rset.getType() == 0) {
                            qRset = (IQueryResultSet)rset;
                            long parentRowId = dataSetId.getRowID();
                            if (parentSetId != null && parentRowId != -1L && parentRowId != qRset.getRowIndex()) {
                                qRset.skipTo(parentRowId);
                            }
                        } else if (rset.getType() == 1) {
                            qRset = (ICubeResultSet)rset;
                            String cellId = dataSetId.getCellID();
                            if (cellId != null && !cellId.equals(qRset.getCellIndex())) {
                                qRset.skipTo(cellId);
                            }
                        }
                    }
                }
                rsets = new IBaseResultSet[queries.length];
                int i = 0;
                while (i < rsets.length) {
                    try {
                        rsets[i] = this.context.executeQuery(rset, queries[i], design.getHandle(), useCache);
                    }
                    catch (BirtException ex) {
                        this.context.addException(design, ex);
                    }
                    ++i;
                }
            }
        }
        return rsets;
    }

    protected void doPositionResultSet(IBaseResultSet rset, IContent content) throws BirtException {
        DataID dataId;
        InstanceID iid = content.getInstanceID();
        if (iid != null && (dataId = iid.getDataID()) != null && rset != null) {
            if (rset.getType() == 0) {
                IQueryResultSet qRset = (IQueryResultSet)rset;
                long rowId = dataId.getRowID();
                if (rowId == -1L) {
                    qRset.next();
                }
                if (rowId != -1L && rowId != qRset.getRowIndex()) {
                    qRset.skipTo(rowId);
                }
            } else if (rset.getType() == 1) {
                ICubeResultSet qRset = (ICubeResultSet)rset;
                String cellId = dataId.getCellID();
                if (cellId != null && !cellId.equals(qRset.getCellIndex())) {
                    qRset.skipTo(cellId);
                }
            }
        }
    }

    protected void closeQueries(IBaseResultSet[] rsets) {
        if (rsets != null) {
            int i = 0;
            while (i < rsets.length) {
                if (rsets[i] != null) {
                    rsets[i].close();
                }
                ++i;
            }
        }
    }
}

