/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dup;

import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.executor.DataItemExecutionState;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplicateItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.util.FastPool;

public class SuppressDuplciateReportExecutor
extends WrappedReportExecutor {
    private IReportContent report;
    private SuppressDuplicateVisitor visitor;
    private FastPool executors = new FastPool();

    public SuppressDuplciateReportExecutor(IReportExecutor executor) {
        super(executor);
        this.visitor = new SuppressDuplicateVisitor();
    }

    public IReportContent execute() {
        if (this.report == null) {
            this.report = super.execute();
        }
        return this.report;
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return this.reportExecutor.createPageExecutor(pageNumber, pageDesign);
    }

    protected IReportItemExecutor createWrappedExecutor(IReportItemExecutor executor) {
        SuppressDuplicateItemExecutor wrappedExecutor = null;
        if (this.executors.isEmpty()) {
            wrappedExecutor = new SuppressDuplicateItemExecutor(this, executor);
        } else {
            wrappedExecutor = (SuppressDuplicateItemExecutor)this.executors.remove();
            wrappedExecutor.setExecutor(executor);
        }
        return wrappedExecutor;
    }

    protected void closeWrappedExecutor(IReportItemExecutor executor) {
        this.executors.add(executor);
    }

    IContent suppressDuplicate(IContent content) {
        switch (content.getContentType()) {
            case 3: 
            case 10: 
            case 13: 
            case 16: 
            case 17: {
                return (IContent)content.accept(this.visitor, content);
            }
        }
        return content;
    }

    private class SuppressDuplicateVisitor
    extends ContentVisitorAdapter {
        private SuppressDuplicateVisitor() {
        }

        public Object visitContent(IContent content, Object param) {
            return content;
        }

        public Object visitData(IDataContent data, Object param) {
            DataItemDesign dataDesign;
            IDataContent dataContent = data;
            Object genBy = dataContent.getGenerateBy();
            if (genBy instanceof DataItemDesign && (dataDesign = (DataItemDesign)genBy).getSuppressDuplicate()) {
                Object lastValue;
                Object value = dataContent.getValue();
                DataItemExecutionState state = (DataItemExecutionState)dataDesign.getExecutionState();
                if (state != null && ((lastValue = state.lastValue) == value || lastValue != null && lastValue.equals(value))) {
                    return null;
                }
                if (state == null) {
                    state = new DataItemExecutionState();
                    dataDesign.setExecutionState(state);
                }
                state.lastValue = value;
            }
            return data;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            Object genBy = group.getGenerateBy();
            if (genBy instanceof GroupDesign) {
                this.clearDuplicateFlags((GroupDesign)genBy);
            }
            return group;
        }

        public Object visitList(IListContent list, Object value) {
            Object genBy = list.getGenerateBy();
            if (genBy instanceof ListingDesign) {
                this.clearDuplicateFlags((ListingDesign)genBy);
            }
            return list;
        }

        public Object visitTable(ITableContent table, Object value) {
            Object genBy = table.getGenerateBy();
            if (genBy instanceof ListingDesign) {
                this.clearDuplicateFlags((ListingDesign)genBy);
            }
            return table;
        }

        protected void clearDuplicateFlags(ListingDesign listingDesign) {
            SuppressDuplicateUtil.clearDuplicateFlags(listingDesign);
        }

        protected void clearDuplicateFlags(GroupDesign groupDesign) {
            ListingDesign listingDesign = this.getListingDesign(groupDesign);
            int groupLevel = groupDesign.getGroupLevel();
            int groupCount = listingDesign.getGroupCount();
            int i = groupLevel;
            while (i < groupCount) {
                GroupDesign group = listingDesign.getGroup(i);
                SuppressDuplicateUtil.clearDuplicateFlags(group);
                ++i;
            }
            SuppressDuplicateUtil.clearDuplicateFlags(listingDesign.getDetail());
        }

        protected ListingDesign getListingDesign(GroupDesign groupDesign) {
            long listingId = groupDesign.getHandle().getContainer().getID();
            return (ListingDesign)SuppressDuplciateReportExecutor.this.report.getDesign().getReportItemByID(listingId);
        }
    }
}

