/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeMap
extends BTree<String, Long> {
    int indexVersion = 0;
    int indexType = 2;

    public static BTreeMap openTreeMap(IDocArchiveReader archive, String name) throws IOException {
        BTreeOption option = new BTreeOption();
        option.setReadOnly(true);
        option.setKeySerializer((BTreeSerializer)new StringSerializer());
        option.setHasValue(true);
        option.setAllowDuplicate(false);
        option.setValueSize(8);
        option.setValueSerializer((BTreeSerializer)new LongSerializer());
        option.setFile((BTreeFile)new ArchiveInputFile(archive, name));
        return new BTreeMap((BTreeOption<String, Long>)option);
    }

    public static BTreeMap createTreeMap(IDocArchiveWriter archive, String name) throws IOException {
        BTreeOption option = new BTreeOption();
        option.setKeySerializer((BTreeSerializer)new StringSerializer());
        option.setHasValue(true);
        option.setAllowDuplicate(false);
        option.setValueSize(8);
        option.setValueSerializer((BTreeSerializer)new LongSerializer());
        option.setFile((BTreeFile)new ArchiveOutputFile(archive, name));
        return new BTreeMap((BTreeOption<String, Long>)option);
    }

    private BTreeMap(BTreeOption<String, Long> option) throws IOException {
        super(option);
    }

    protected void readTreeHead(DataInput in) throws IOException {
        this.indexVersion = in.readInt();
        this.indexType = in.readInt();
        super.readTreeHead(in);
    }

    protected void writeTreeHead(DataOutput out) throws IOException {
        out.writeInt(this.indexVersion);
        out.writeInt(this.indexType);
        super.writeTreeHead(out);
    }

    public void close() throws IOException {
        super.close();
        if (this.file instanceof ArchiveInputFile) {
            ((ArchiveInputFile)this.file).close();
        }
        if (this.file instanceof ArchiveOutputFile) {
            ((ArchiveOutputFile)this.file).close();
        }
    }

    private static class ArchiveInputFile
    implements BTreeFile {
        IDocArchiveReader archive;
        String name;
        RAInputStream input;

        ArchiveInputFile(IDocArchiveReader archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            this.input = archive.getInputStream(name);
        }

        public int allocBlock() throws IOException {
            throw new IOException("read only stream");
        }

        public int getTotalBlock() throws IOException {
            return (int)((this.input.length() + 4096L - 1L) / 4096L);
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.seek((long)(blockId * 4096));
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            throw new IOException("read only stream");
        }

        public void close() {
        }
    }

    private static class ArchiveOutputFile
    implements BTreeFile {
        IDocArchiveWriter archive;
        String name;
        RAOutputStream output;
        RAInputStream input;
        int totalBlock;

        ArchiveOutputFile(IDocArchiveWriter archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            this.output = archive.createOutputStream(name);
            this.input = archive.getInputStream(name);
            this.totalBlock = 0;
        }

        void close() throws IOException {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
        }

        public int allocBlock() throws IOException {
            return this.totalBlock++;
        }

        public int getTotalBlock() throws IOException {
            return this.totalBlock;
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.refresh();
            this.input.seek((long)(blockId * 4096));
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            if (blockId >= this.totalBlock) {
                this.totalBlock = blockId + 1;
            }
            this.output.seek((long)(blockId * 4096));
            this.output.write(bytes);
            this.output.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSerializer
    implements BTreeSerializer<Long> {
        private LongSerializer() {
        }

        public byte[] getBytes(Long object) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream oo = new DataOutputStream(out);
            oo.writeLong(object);
            return out.toByteArray();
        }

        public Long getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
            return input.readLong();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSerializer
    implements BTreeSerializer<String> {
        private StringSerializer() {
        }

        public byte[] getBytes(String object) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream oo = new DataOutputStream(out);
            oo.writeUTF(object);
            return out.toByteArray();
        }

        public String getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
            return input.readUTF();
        }
    }
}

