/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.btree.BTreeCursor;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.internal.index.v2.BTreeMap;
import org.eclipse.birt.report.engine.internal.index.v2.IndexConstants;

public class IndexReader
implements IndexConstants {
    HashMap<String, Long> map;
    BTreeMap btree;

    public IndexReader(IDocArchiveReader archive, String name) throws IOException {
        if (archive.exists(name)) {
            RAInputStream input = archive.getInputStream(name);
            try {
                int version = input.readInt();
                if (version != 0) {
                    throw new IOException("unsupported index version " + version);
                }
                int type = input.readInt();
                if (type == 1) {
                    DataInputStream di = new DataInputStream((InputStream)input);
                    int entries = IOUtil.readInt((InputStream)di);
                    this.map = new HashMap(entries);
                    int i = 0;
                    while (i < entries) {
                        String key = IOUtil.readString((DataInputStream)di);
                        long offset = IOUtil.readLong((DataInputStream)di);
                        this.map.put(key, new Long(offset));
                        ++i;
                    }
                } else {
                    this.btree = BTreeMap.openTreeMap(archive, name);
                }
            }
            finally {
                input.close();
            }
        }
    }

    long get(String key) throws IOException {
        if (this.map != null) {
            Long offset = this.map.get(key);
            if (offset != null) {
                return offset;
            }
            return -1L;
        }
        if (this.btree != null) {
            Long offset = (Long)this.btree.getValue(key);
            if (offset != null) {
                return offset;
            }
            return -1L;
        }
        return -1L;
    }

    void close() throws IOException {
        this.map = null;
        if (this.btree != null) {
            try {
                this.btree.close();
            }
            finally {
                this.btree = null;
            }
        }
    }

    void forAllKeys(KeyListener listener) throws IOException {
        if (this.map != null) {
            for (String bookmark : this.map.keySet()) {
                listener.onKey(bookmark);
            }
        }
        if (this.btree != null) {
            BTreeCursor cursor = this.btree.createCursor();
            try {
                while (cursor.next()) {
                    String key = (String)cursor.getKey();
                    listener.onKey(key);
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    public static interface KeyListener {
        public void onKey(String var1);
    }
}

